// license:GPL_2.0
// copyright-holders:Robbbert
#include "../mame/drivers/namcos2.cpp"


/********
 Phelios
**********/

ROM_START( pheliosx )
	ROM_REGION( 0x040000, "maincpu", 0 )
	ROM_LOAD16_BYTE( "ps2_mpr1x.mpr0",  0x000001, 0x020000, CRC(e277e0a7) SHA1(5b97fb2d6918802a39275a8875260533ee874346) )
	ROM_LOAD16_BYTE( "ps2_mpr0.mpr0",  0x000000, 0x020000, CRC(28f04e1a) SHA1(06cb053f7281ec9cb59319a4aa1262c128b369c8) )

	ROM_REGION( 0x040000, "slave", 0 )
	ROM_LOAD16_BYTE( "ps2_spr0.spr0",  0x000000, 0x010000, CRC(e9c6987e) SHA1(325532b065999276e4629b10c27d7df083e81c33) )
	ROM_LOAD16_BYTE( "ps2_spr1.spr1",  0x000001, 0x010000, CRC(02b074fb) SHA1(4025c3dd83e26ac87de9f2f73753d1cb1211c1ae) )

	ROM_REGION( 0x020000, "audiocpu", 0 )
	ROM_LOAD( "ps2_snd0.snd0",  0x000000, 0x020000, CRC(da694838) SHA1(e1a20aedd18c49dcd12717e8ce479a5a441c10e6) )

	ROM_REGION( 0x8000, "c65mcu:external", ROMREGION_ERASE00 )
	ROM_LOAD( "sys2_c65c.3f",  0x000000, 0x008000, CRC(a5b2a4ff) SHA1(068bdfcc71a5e83706e8b23330691973c1c214dc) )

	ROM_REGION( 0x400000, "sprite", 0 )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-0.obj0",  0x000003, CRC(f323db2b) SHA1(fa3c42c618da06af161ad3f8aa1283e9c4bd63c0) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-1.obj1",  0x000002, CRC(faf7c2f5) SHA1(d0d33eddaf5de2b639717db83a85f441d81a5924) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-2.obj2",  0x000001, CRC(828178ba) SHA1(d35ab8020ebaad0b4c0b24fa9edc2886b713a8ed) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-3.obj3",  0x000000, CRC(e84771c8) SHA1(17bede39d8b703005b288f3596c4aaca266fa06b) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-4.obj4",  0x200003, CRC(81ea86c6) SHA1(27400b4e1d53c47bc6b821439c294d879bf58ae4) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-5.obj5",  0x200002, CRC(aaebd51a) SHA1(7acb88cfcaf7e7c41de171ed5952e1d0a13ef302) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-6.obj6",  0x200001, CRC(032ea497) SHA1(89f4deed8fa076683abc1f2e961ceb920ab9848d) )
	NAMCOS2_SPRROM_LOAD_256K( "ps_obj-7.obj7",  0x200000, CRC(f6183b36) SHA1(d1fec216e88f6a07f03d1e458a105548d0376ef3) )

	ROM_REGION( 0x400000, "c123tmap", 0 )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-0.chr0",  0x000000, CRC(668b6670) SHA1(35bdac5478cee37b82a8a5367a2a08c70014131d) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-1.chr1",  0x080000, CRC(80c30742) SHA1(e9307b6a4a6a749a97f76355fb3785945e303289) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-2.chr2",  0x100000, CRC(f4e11bf7) SHA1(4506fdc83956d7e58bee1a6661da9fe12f1317a9) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-3.chr3",  0x180000, CRC(97a93dc5) SHA1(9e89271a0bcb201122465d8f3b980b490e1e7350) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-4.chr4",  0x200000, CRC(81d965bf) SHA1(c7a2349c1ed34a5375d8643a3a373adffab554f4) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-5.chr5",  0x280000, CRC(8ca72d35) SHA1(e3af2d3772468bd26b552a3f15c8a9dd562b1361) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_chr-6.chr6",  0x300000, CRC(da3543a9) SHA1(085ac3a7e71db8cc60fc343d3a6b009a81f751ee) )

	ROM_REGION( 0x400000, "s2roz", 0 )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-0.roz0",  0x000000, CRC(68043d7e) SHA1(ee81e0f3fc1cd0aa903ad670aa7832c972613a80) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-1.roz1",  0x080000, CRC(029802b4) SHA1(b9966d13f80faa5befa43cfa9628afd6a4ff783e) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-2.roz2",  0x100000, CRC(bf0b76dc) SHA1(28f01dc16ee8818291f89cfc03b126c6cd7ced72) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-3.roz3",  0x180000, CRC(9c821455) SHA1(259f2cb4a7de69e751644511f66611392e60f59d) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-4.roz4",  0x200000, CRC(63a39b7a) SHA1(2fa8ced5beb7574cb4add0245f97282ce9149691) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-5.roz5",  0x280000, CRC(fc5a99d0) SHA1(e61d45347ec0ee6db27edd6da797e810052803a2) )
	NAMCOS2_GFXROM_LOAD_128K( "ps_roz-6.roz6",  0x300000, CRC(a2a17587) SHA1(44a58735e6efdfa815576ed134a1295db49430fb) )

	ROM_REGION( 0x080000, "c123tmap:mask", 0 )
	NAMCOS2_GFXROM_LOAD_128K( "ps_shape.shape",  0x000000, CRC(58e26fcf) SHA1(9edc3b54964f923ed07ee878520ccf3f188f04ad) )

	ROM_REGION16_BE( 0x200000, "data_rom", 0 )
	NAMCOS2_DATA_LOAD_E_128K( "ps2_dat0.13s",  0x000000, CRC(ee4194b0) SHA1(a0c2a807db70164ed761e5ad04301e5ae1173e7a) )
	NAMCOS2_DATA_LOAD_O_128K( "ps2_dat1.13p",  0x000000, CRC(5b22d714) SHA1(f6cb1fe661f7691269840245f06875845fd6eb33) )

	ROM_REGION16_BE( 0x200000, "c140", ROMREGION_ERASE00 )
	ROM_LOAD16_BYTE( "ps_voi-1.voice1",  0x000000, 0x080000, CRC(f67376ed) SHA1(b54257aad34c6ad03d5b040e6a5dda94a48b6780) )
ROM_END

ROM_START( valkyrien )
	ROM_REGION( 0x040000, "maincpu", 0 )
	ROM_LOAD16_BYTE( "wd1mpr0.en",  0x000000, 0x020000, CRC(e98e0da1) SHA1(17fd6d822ea0dae5f4877eba3d81db57112f95e0) )
	ROM_LOAD16_BYTE( "wd1mpr1.en",  0x000001, 0x020000, CRC(91f9fa03) SHA1(eaced548be789490cef0c0aa2503f567b1571051) )

	ROM_REGION( 0x040000, "slave", 0 )
	ROM_LOAD16_BYTE( "wd1spr0.bin",  0x000000, 0x010000, CRC(b2398321) SHA1(13b76d8756a5e47d7469f72ef5fd2837b3e24b3e) )
	ROM_LOAD16_BYTE( "wd1spr1.bin",  0x000001, 0x010000, CRC(38dba897) SHA1(22254186906b1accfb043172e6d0129d23d83b02) )

	ROM_REGION( 0x020000, "audiocpu", 0 )
	ROM_LOAD( "wd1snd0.bin",  0x000000, 0x020000, CRC(d0fbf58b) SHA1(bc149eefcf5566a8e37ae60a62f5037a6e0f10bd) )

	ROM_REGION( 0x8000, "c65mcu:external", ROMREGION_ERASE00 )
	ROM_LOAD( "sys2c65c.bin",  0x000000, 0x008000, CRC(a5b2a4ff) SHA1(068bdfcc71a5e83706e8b23330691973c1c214dc) )

	ROM_REGION( 0x400000, "sprite", 0 )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj0.bin",  0x000003, CRC(e8089451) SHA1(f4d05df0015de01ec570f5f89ea11592204e4fe2) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj1.bin",  0x000002, CRC(7ca65666) SHA1(39d792abf5a1a5f3906cb6ab4626f4a5b20cb081) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj2.bin",  0x000001, CRC(7c159407) SHA1(ed5472eb9df7990b8d80ff5a587e41d138f48db8) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj3.bin",  0x000000, CRC(649f8760) SHA1(3ac7eac5197b4d377686d68d80ab29562768c202) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj4.bin",  0x200003, CRC(7ca39ae7) SHA1(3db34eb7f8c819c7b30c3b61b5a13b8f990b27f8) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj5.bin",  0x200002, CRC(9ead2444) SHA1(0ba541b518be22460c267d35b050594b7cedb954) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj6.bin",  0x200001, CRC(9fa2ea21) SHA1(89cefc286cf4de7f6e32dc6dc689835a21bea2ed) )
	NAMCOS2_SPRROM_LOAD_256K( "wdobj7.bin",  0x200000, CRC(66e07a36) SHA1(2f84128bbdc9dcfd783d3a85cb47a92087e71272) )

	ROM_REGION( 0x400000, "c123tmap", 0 )
	NAMCOS2_GFXROM_LOAD_128K( "wdchr0.bin",  0x000000, CRC(debb0116) SHA1(ba4a9a166e22cf4930574eeadd127520ff7192b4) )
	NAMCOS2_GFXROM_LOAD_128K( "wdchr1.bin",  0x080000, CRC(8a1431e8) SHA1(ef3c81ea92f2541387760c24395ddf7a02f907f2) )
	NAMCOS2_GFXROM_LOAD_128K( "wdchr2.bin",  0x100000, CRC(62f75f69) SHA1(bcfd34c3c450cd05eb6a080307dc962687ccc799) )
	NAMCOS2_GFXROM_LOAD_128K( "wdchr3.bin",  0x180000, CRC(cc43bbe7) SHA1(9b01ac19feac60a68cd7ffcf3cab927cefa0e23a) )
	NAMCOS2_GFXROM_LOAD_128K( "wdchr4.bin",  0x200000, CRC(2f73d05e) SHA1(76341fd8c5e4216430eb09ded38ac554b5777ee5) )
	NAMCOS2_GFXROM_LOAD_128K( "wdchr5.bin",  0x280000, CRC(b632b2ec) SHA1(914cb9a0dd42067b93e47c8cf847d588f361854f) )

	ROM_REGION( 0x400000, "s2roz", 0 )
	NAMCOS2_GFXROM_LOAD_128K( "wdroz0.bin",  0x000000, CRC(f776bf66) SHA1(2b134d5f9ede1205260a2109fdcd0d5c47b397ba) )
	NAMCOS2_GFXROM_LOAD_128K( "wdroz1.bin",  0x080000, CRC(c1a345c3) SHA1(3d8c2ab457b81485014a83b4d9e8a80fe487ddef) )
	NAMCOS2_GFXROM_LOAD_128K( "wdroz2.bin",  0x100000, CRC(28ffb44a) SHA1(207343e76dd02cbfe7575edd9b18074f68bb6768) )
	NAMCOS2_GFXROM_LOAD_128K( "wdroz3.bin",  0x180000, CRC(7e77b46d) SHA1(db0ba244fb878120a4f06af4666ddc4cc430c97a) )

	ROM_REGION( 0x080000, "c123tmap:mask", 0 )
	NAMCOS2_GFXROM_LOAD_128K( "wdshape.bin",  0x000000, CRC(3b5e0249) SHA1(259bbabf57a8ad739c646c56aad6d0b92e10adcd) )

	ROM_REGION16_BE( 0x200000, "data_rom", 0 )
	NAMCOS2_DATA_LOAD_E_128K( "wd1dat0.13s",  0x000000, CRC(ea209f48) SHA1(5e73a745dc2faaa4ce6c633d4072d41e9e494276) )
	NAMCOS2_DATA_LOAD_O_128K( "wd1dat1.13p",  0x000000, CRC(04b48ada) SHA1(aa046f8856bdd5b56d481c2c12ad2808c6517a5f) )

	ROM_REGION16_BE( 0x200000, "c140", ROMREGION_ERASE00 )
	NAMCOS2_DATA_LOAD_E_256K( "wd1voi1.bin",  0x000000, CRC(f1ace193) SHA1(dd13bdf4b99c6bf4e356d623ff2e3da72db331dd) )
	NAMCOS2_DATA_LOAD_E_128K( "wd1voi2.bin",  0x100000, CRC(e95c5cf3) SHA1(4bfc7303bde23bcf6739c7877dd87671c33135bc) )
ROM_END

/*    YEAR  NAME            PARENT    MACHINE        INPUT       INIT             MONITOR COMPANY                 FULLNAME FLAGS */
// Phelios
GAME(1988, pheliosx,   phelios,  base2,    base,     namcos2_state, init_phelios,  ROT90,  "Wayder", "Phelios (Sound Bug fix - Final Battle)", 0)

// Translation by coinoplegacy.com
GAME(  1989, valkyrien, valkyrie, base3, base, namcos2_state, init_valkyrie, ROT90,  "hack", "Valkyrie no Densetsu (English Translation)", 0 )

