// license:GPL_2.0
// copyright-holders:Robbbert
// Metal Slug 3
#include "includes/neogeo.h"

// set default level to 8: ROM_FILL(0x2ea7,1,0x78) decrypted sets only

#if 0
void neogeo_state::init_mslug3()
{
	init_neogeo();
	m_sma_prot->mslug3_decrypt_68k(cpuregion);
	m_sprgen->m_fixed_layer_bank_type = 1;
	m_cmc_prot->cmc42_neogeo_gfx_decrypt(spr_region, spr_region_size, MSLUG3_GFX_KEY);
	m_sma_prot->mslug3_install_protection(m_maincpu, m_banked_cart);
}
#endif

void neogeo_state::init_mslug3n() // decrypt gfx and extract sx
{
	init_neogeo();
	m_sprgen->m_fixed_layer_bank_type = 1;
	m_cmc_prot->cmc42_neogeo_gfx_decrypt(spr_region, spr_region_size, MSLUG3_GFX_KEY);
	m_cmc_prot->neogeo_sfix_decrypt(spr_region, spr_region_size, fix_region, fix_region_size);
}

void neogeo_state::init_mslug3d()
{
	init_neogeo();
	m_sma_prot->mslug3_decrypt_68k(cpuregion);
	m_sprgen->m_fixed_layer_bank_type = 1;
	m_sma_prot->mslug3_install_protection(m_maincpu, m_banked_cart);
	m_cmc_prot->neogeo_sfix_decrypt(spr_region, spr_region_size, fix_region, fix_region_size);
}

void neogeo_state::init_mslug3fr()
{
	init_neogeo();
	m_sprgen->m_fixed_layer_bank_type = 1;
	m_sma_prot->mslug3_install_protection(m_maincpu, m_banked_cart);
	m_cmc_prot->neogeo_sfix_decrypt(spr_region, spr_region_size, fix_region, fix_region_size);
}


#if 0
ROM_START( mslug3 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",    0x0c0000, 0x040000, CRC(9cd55736) SHA1(d6efb2b313127c2911d47d9324626b3f1e7c6ccb) )
	ROM_LOAD16_WORD_SWAP( "256.p1", 0x100000, 0x400000, CRC(b07edfd5) SHA1(dcbd9e500bfae98d754e55cdbbbbf9401013f8ee) )
	ROM_LOAD16_WORD_SWAP( "256.p2", 0x500000, 0x400000, CRC(6097c26b) SHA1(248ec29d21216f29dc6f5f3f0e1ad1601b3501b6) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END
#endif

ROM_START( mslug3e02 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e02.p1",   0x000000, 0x100000, CRC(c9cf4ef8) SHA1(e1e10dcea6ce0c8b6939250adaa167e950069760) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )
	ROM_FILL(0x2ea7,1,0x78)

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e03 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e03.p1",   0x000000, 0x100000, CRC(77f64aa6) SHA1(8aa93f67e55461019dc677cb6f96ead3771232d1) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e04 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e04.p1",   0x000000, 0x100000, CRC(09e9fe91) SHA1(573bd25c77e79de85396812bb7632be8d93bdaa6) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e05 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e05.p1",   0x000000, 0x100000, CRC(c1a91748) SHA1(07227283b7fe0e040962a84bc345b231fe6417e3) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e06 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e06.p1",   0x000000, 0x100000, CRC(812cdce7) SHA1(5249bc026471c1abb2d37b2ac03267b3349a6345) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e07 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e07.p1",   0x000000, 0x100000, CRC(bb123461) SHA1(26a8fbb7792ebbd1052a09a78a38a72901644902) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e08 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e08.p1",   0x000000, 0x100000, CRC(7666aad5) SHA1(3d55be31a158501d74994a5abf31d6928626d7e3) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e09 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e09.p1",   0x000000, 0x100000, CRC(be26430c) SHA1(ee4d070885032bc5c2699d8c0b5abe7d1d7bc6cc) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e10 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e10.p1",   0x000000, 0x100000, CRC(e510ae7e) SHA1(35183a58c11e78c9da08643853c2b06eed74b87c) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e11 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e11.p1",   0x000000, 0x100000, CRC(2d5047a7) SHA1(89e720e8ccddbbc81c923ad8f7e5a371f9f0ecfc) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e12 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e12.p1",   0x000000, 0x100000, CRC(410a6c8e) SHA1(d89aaa1a6fa46c20a84b8fafd83c66fe43a93e86) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e13 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e13.p1",   0x000000, 0x100000, CRC(642335cb) SHA1(a17e7a48759a7589a3baf5ff4f69c937954de44c) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e14 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e14.p1",   0x000000, 0x100000, CRC(3e8538ca) SHA1(148732165a081bec2f7bdefc79ce7a2db6a2998d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e15 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e15.p1",   0x000000, 0x100000, CRC(f6c5d113) SHA1(555ce0ea6c7d3003c9239de8b7a580295096e9ff) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e16 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e16.p1",   0x000000, 0x100000, CRC(52df13e3) SHA1(9e24404b687284540d21b3be512108da1f1e2bbf) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e17 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e17.p1",   0x000000, 0x100000, CRC(9a9ffa3a) SHA1(3ce3ba9048aa94543a03798c710c4bea4075a072) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e18 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e18.p1",   0x000000, 0x100000, CRC(1a3c81fc) SHA1(b6f2ed4cb2b7f3f3dd3ef1bc97780ef136b2a82c) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e19 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e19.p1",   0x000000, 0x100000, CRC(d27c6825) SHA1(d58d0db2378f0541c18dd60fc933614537572dc7) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e20 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e20.p1",   0x000000, 0x100000, CRC(e4804e0d) SHA1(9d47e69e8ff737a977c9470a59024da7af35db9c) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e21 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e21.p1",   0x000000, 0x100000, CRC(2cc0a7d4) SHA1(7f640067d653c8c0b66ba3c33d0e948497786acf) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3e22 ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256e22.p1",   0x000000, 0x100000, CRC(7d648368) SHA1(d637a17d777f59596ad1b67b7898f182f8f4d577) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslg3eha ) /* Metal Slug 3 - Super Enhance by Ydmis - (Style remix) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256eha.p1",   0x000000, 0x100000, CRC(e04c6624) SHA1(de684f346ab9a2e5730a6753de6d53801a702cc8) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslg3ehs )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256eh.p1",   0x000000, 0x100000, CRC(bfb6a37f) SHA1(2ed7fc7936d732ff55f629612434f1d72c09976e) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslg3kho )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256kho.p1",   0x000000, 0x100000, CRC(820567e4) SHA1(c23d58e3c5c185715bb65839f4a6a04767992f3d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3kh ) /* Metal Slug 3 - Enhance by Fighters Kim and Ydmis - (Style remix 20030801) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256kh.p1",    0x000000, 0x100000, CRC(696aa1b4) SHA1(2e72191f12f4cbbddda1350fbe859e8bc70be62f) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3xg )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256xg.p1",    0x000000, 0x100000, CRC(a406ce23) SHA1(d41dee4f103d3ea1e3b88fd7e5ee8f221579d28e) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3d )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",    0x0c0000, 0x040000, CRC(9cd55736) SHA1(d6efb2b313127c2911d47d9324626b3f1e7c6ccb) )
	ROM_LOAD16_WORD_SWAP( "256.p1", 0x100000, 0x400000, CRC(b07edfd5) SHA1(dcbd9e500bfae98d754e55cdbbbbf9401013f8ee) )
	ROM_LOAD16_WORD_SWAP( "256.p2", 0x500000, 0x400000, CRC(6097c26b) SHA1(248ec29d21216f29dc6f5f3f0e1ad1601b3501b6) )

	//NEO_SFIX_128K( "256d.s1", CRC(6d9d4d0a) SHA1(4237247494aa0d734ffc728c7fc2808aca42539e) )
	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3eb )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "mslug3eb.sma", 0x0c0000, 0x040000, CRC(2a9935c2) SHA1(f39d47b0b6fbe0e741777d47fbaf37008c4e0599) )
	ROM_LOAD16_WORD_SWAP( "256eb.p1",     0x100000, 0x400000, CRC(6ec2e58d) SHA1(d83dd522a5c8a8b4bd32722967e3d934d2e73e08) )
	ROM_LOAD16_WORD_SWAP( "256eb.p2",     0x500000, 0x400000, CRC(ca4eb0d3) SHA1(eafd000ae27c0b904aea50f681f98ab67068da20) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3fr ) /* [OLD] Metal Slug 3 N - (mslug3fro) - Translation Hack by NEO-ARC - (French translation) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256fr.p1",    0x000000, 0x100000, CRC(1f5fcb35) SHA1(387e0e0121a26254991b446d6bbdf755cf2e3ad2) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256fr.c1", 0x0000000, 0x800000, CRC(6ac28a9f) SHA1(9dae9703d20af3644456eda228ea7fb52fe67bd7) )
	ROM_LOAD16_BYTE( "256fr.c2", 0x0000001, 0x800000, CRC(C9725CD0) SHA1(59A0A2778AE35DDCAC17FBA05A81F3DA5EACA1F1) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3fro ) /* Metal Slug 3 - Translation Hack by NEO-ARC - (French translation) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256fro.p1",   0x000000, 0x100000, CRC(ce3f408b) SHA1(c2752af1dd4373c37e90b2e718ab7ae038535ea1) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256fro.c1", 0x0000000, 0x800000, CRC(d799f41c) SHA1(d87cda305d054c56197112ba515299883d419bb4) )
	ROM_LOAD16_BYTE( "256fr.c2", 0x0000001, 0x800000, CRC(C9725CD0) SHA1(59A0A2778AE35DDCAC17FBA05A81F3DA5EACA1F1) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3hev ) // all confirmed: mslug3ehs with new p1
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256hev.p1",   0x000000, 0x100000, CRC(c824bccc) SHA1(cfe0caff7eedd33e98cdb66d3104b11597f62089) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3nd ) // all confirmed
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256nd.p1",  0x000000, 0x100000, CRC(9c42ca85) SHA1(7a8f77a89867b889295ae9b9dfd4ba28f02d234d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K
	//NEO_SFIX_MSLUG( "256nd.s1", CRC(6d9d4d0a) SHA1(4237247494aa0d734ffc728c7fc2808aca42539e) )  // this is missing the high score text

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3rb )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rb.p1",  0x000000, 0x100000, CRC(e575a406) SHA1(fcfab75f53c13353fcdd85293dee5bd71f614bb0) )
	ROM_LOAD16_WORD_SWAP( "256h68.p2", 0x100000, 0x400000, CRC(7eed7c81) SHA1(1d9a18178b14226be60af683c9c4a7cfada7f0bb) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3v ) // extreme violence
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256v.p1",     0x000000, 0x100000, CRC(47f9aeea) SHA1(db1c65681ac12b146e2fa21a8f28000f41a11fe2) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MSLUG( "256v.s1", CRC(6f8b9635) SHA1(86b0c8c0ccac913c6192ed6a96c35d4e1a5e8061) )

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h01.p1",   0x000000, 0x100000, CRC(ba813a71) SHA1(ce1c0fcb672f660c45a745fe503473978a7b8927) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h02.p1",   0x000000, 0x100000, CRC(ef03489c) SHA1(0bd71b57983fd53ca91ceef724f6748f7b7390cd) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h03.p1",     0x000000, 0x100000, CRC(2591b1f7) SHA1(3af19aad19d741a342d83bf20c564d8294a8daca) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MSLUG( "256v.s1", CRC(6f8b9635) SHA1(86b0c8c0ccac913c6192ed6a96c35d4e1a5e8061) )

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h04.p1",   0x000000, 0x100000, CRC(248123f3) SHA1(0a99b5f69766240883a98cef00a6f917462eaf9f) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h05.p1",   0x000000, 0x100000, CRC(a92df7c4) SHA1(19ed3ee71e63d8648c057718c38654a064f8942d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h06.p1",   0x000000, 0x100000, CRC(18c5c6f0) SHA1(4ac2bd2aa9183aaf95991fa9a2a7b2245ff4c9ce) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h07 ) //mslug3maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h07.p1",   0x000000, 0x100000, CRC(5a2c6c65) SHA1(9ff140f955091c94144b3f45a8f9bad3859fc245) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h08.p1",  0x000000, 0x100000, CRC(5716aac8) SHA1(749cec11d0e8cb8406afc386f97af101947b7389) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3h09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h09.p1",   0x000000, 0x100000, CRC(0e198a57) SHA1(721eeb956aeb50454fc487517ba780194a803032) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h10.p1",   0x000000, 0x100000, CRC(6062de85) SHA1(3ba7f91c7343bdda4f448c25756dc96d9c92889f) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h11.p1",   0x000000, 0x100000, CRC(82add0ba) SHA1(e437c002d76600f6dd478b717226a8a6ac9ba54e) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h12.p1",   0x000000, 0x100000, CRC(bb829a08) SHA1(47ee500754ff6a10d8937c05d7f0525cc8a15d89) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h13.p1",   0x000000, 0x100000, CRC(6e9e2cdd) SHA1(3ed78c9d6adcf605432ecb2905fd39bba7356f08) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h14.p1",   0x000000, 0x100000, CRC(9c2063d2) SHA1(ded2a73388d9f50ade36c04625d62cd5ec26a244) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h15.p1",   0x000000, 0x100000, CRC(07fd2df6) SHA1(57b7e99babc45606c911af7907acbf25c84e42fe) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h16.p1",   0x000000, 0x100000, CRC(8eb013d0) SHA1(9e39c295d479dea25f20d7d9ce28edfc22197705) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h17.p1",   0x000000, 0x100000, CRC(6bbb97f8) SHA1(bc80fe4af82c008034e456d5d890916e543c8950) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h18.p1",   0x000000, 0x100000, CRC(70e755ba) SHA1(3d08f065702799f29000b6c994ee134ee6a9704d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h19.p1",   0x000000, 0x100000, CRC(3a80d207) SHA1(e1ac055d2316ba754678d119890742643a29bc40) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h20.p1",   0x000000, 0x100000, CRC(2b8d7718) SHA1(337d93e37b2c1962e8401d9e358edfe96aaea5af) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h21 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h21.p1",   0x000000, 0x100000, CRC(4647bc42) SHA1(9638fa29a628f295147c0662ca82e84a304b7668) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h22 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h22.p1",   0x000000, 0x100000, CRC(0f34ce2e) SHA1(c0089c9204094a95e3ee934eb8d4547894c1bfb7) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h23 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h23.p1",   0x000000, 0x100000, CRC(62fe0574) SHA1(d76ddf9f0c7b7477b4d45041639365080546384f) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h24 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h24.p1",   0x000000, 0x100000, CRC(636ee507) SHA1(9ced2f5c2242d4da26df5a97deb3d134405d9a05) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h25 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h25.p1",   0x000000, 0x100000, CRC(b96b93c0) SHA1(49ad6e51d6a070a6b1b805b562158623c12de931) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h26 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h26.p1",   0x000000, 0x100000, CRC(f018e1ac) SHA1(ae44f629d3e704c8a335f541ad269d8435bd50fd) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h27 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h27.p1",   0x000000, 0x100000, CRC(0ea42e5d) SHA1(a3058b385f8550cc85347988ce987f3d257e49ea) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h28 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h28.p1",   0x000000, 0x100000, CRC(d4a1589a) SHA1(f9e8968d2e4de5e80a2b79542f153681b2fe4df7) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h29 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h29.p1",   0x000000, 0x100000, CRC(47d75c31) SHA1(db794a83b4325ed1810c987a9ad9f2abd3eedb43) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h30 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h30.p1",   0x000000, 0x100000, CRC(ba4a5326) SHA1(4cd69c37f0004a4bf806705ccb29fb558150ddbf) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h31 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h31.p1",   0x000000, 0x100000, CRC(9dd22af6) SHA1(c3ee171a92b82e81a775fe6cdd99c7e14a03b977) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h32 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h32.p1",   0x000000, 0x100000, CRC(b8fb73b3) SHA1(ff058b1afa17fd90ebf1e338ca4e45fc7bd1fdae) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h33 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h33.p1",   0x000000, 0x100000, CRC(2a1d976b) SHA1(6ce9a8ae644c22b25e746b33fc283cc21f3ed923) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h34 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h34.p1",   0x000000, 0x100000, CRC(d531b8e9) SHA1(9c972a0bcc75431dee7dc0870b58f2412603a5c7) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h35 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h35.p1",   0x000000, 0x100000, CRC(9ef3ea10) SHA1(0127bdad946a2fd64a59999ae21ee23d81b622db) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h36 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h36.p1",  0x000000, 0x100000, CRC(f18801df) SHA1(d377005af9e6fb0f7ddb3f478c446f90ddf54638) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h37 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h37.p1",  0x000000, 0x100000, CRC(d51f90d7) SHA1(574193d8195b97bc5482ea638caf7709cc29ede9) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h38 ) //mslug3maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h38.p1",   0x000000, 0x100000, CRC(626cc39b) SHA1(3acf1757d3b6897b6dfcf77aded3b11cb49af951) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h39 ) //mslug3c+eb
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h06.p1",  0x000000, 0x100000, CRC(18c5c6f0) SHA1(4ac2bd2aa9183aaf95991fa9a2a7b2245ff4c9ce) )
	ROM_LOAD16_WORD_SWAP( "256h39.p2", 0x100000, 0x400000, CRC(b0ee01c9) SHA1(1e6530c9cf411c6623e143d1338bf592fb6de2ff) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h41 ) //mslug3sd
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h41.p1",  0x000000, 0x100000, CRC(e1e21cc4) SHA1(c70ef18dfe8edbadadff6004508e838b246b88a5) )
	ROM_LOAD16_WORD_SWAP( "256h41.p2", 0x100000, 0x400000, CRC(7343335b) SHA1(2d694af0c876eb8b4844e918cb707ce011c61c5d) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h42 ) //mslug3zhzj, mslug3zh
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h42.p1",  0x000000, 0x100000, CRC(257fa6b9) SHA1(c9ccc0a42a5a34a08316a76dc977ccee74d91245) )
	ROM_LOAD16_WORD_SWAP( "256h42.p2", 0x100000, 0x400000, CRC(badc753c) SHA1(60eae0e02c05448c33cde2666a8b565ee6835216) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h43 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h43.p1",  0x000000, 0x100000, CRC(ac2fd576) SHA1(f605e6f900aadac0c8637c1b4890f9e0da04309c) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256fro.c1", 0x0000000, 0x800000, CRC(d799f41c) SHA1(d87cda305d054c56197112ba515299883d419bb4) )
	ROM_LOAD16_BYTE( "256fr.c2", 0x0000001, 0x800000, CRC(C9725CD0) SHA1(59A0A2778AE35DDCAC17FBA05A81F3DA5EACA1F1) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h43.c7",  0x3000000, 0x800000, CRC(82097fdb) SHA1(04ff6755087df0995c196e8817827fda3b9f9d08) )
	ROM_LOAD16_BYTE( "256h43.c8",  0x3000001, 0x800000, CRC(aa7ca14d) SHA1(876ed262200535b82f74e56b64128df23140338b) )
ROM_END

ROM_START( mslug3h44 ) //mslug3maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h44.p1",   0x000000, 0x100000, CRC(45f3aea9) SHA1(44afbe9c1b401f68a1e1f6c8c5991ae6a94c78d0) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h45 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h45.p1",   0x000000, 0x100000, CRC(94aa4dfe) SHA1(be37e4ebe0a93a35c75b5bfe9847ad72920fe5bc) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h46 ) //mslug3ngw
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h46.p1",   0x000000, 0x100000, CRC(fafde0b4) SHA1(3eee501ddebda761d93c49cdea135fdf0aa0dc9c) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3h47 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h47.p1",   0x000000, 0x100000, CRC(bb448975) SHA1(3b9565ad6f2468ee95b953161d1701c88c9568e5) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h48 )  // mslug3dbcz
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256nd.p1",  0x000000, 0x100000, CRC(9c42ca85) SHA1(7a8f77a89867b889295ae9b9dfd4ba28f02d234d) )
	ROM_LOAD16_WORD_SWAP( "256h48.p2", 0x100000, 0x400000, CRC(9e2064e6) SHA1(d807eb56aebd7f5e8b43b67291856ebb07130c1b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h49 ) //mslug3nzj
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h49.p1",     0x000000, 0x100000, CRC(c85c345f) SHA1(f73a2981a56834dcd171c519c29c94e26345085d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MSLUG( "256v.s1", CRC(6f8b9635) SHA1(86b0c8c0ccac913c6192ed6a96c35d4e1a5e8061) )

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h51 )  // mslug3c, mslug3hr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256nd.p1",  0x000000, 0x100000, CRC(9c42ca85) SHA1(7a8f77a89867b889295ae9b9dfd4ba28f02d234d) )
	ROM_LOAD16_WORD_SWAP( "256h51.p2", 0x100000, 0x400000, CRC(64ae37fc) SHA1(9a82b407f29986138a109d4620fc0a113049047a) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h52 )  // mslug3g
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h52.p1", 0x000000, 0x100000, CRC(b23bd9b7) SHA1(4a5e877bc0d4853dc9c5a2c179049fbdd5285239) )
	ROM_LOAD16_WORD_SWAP( "256h52.p2", 0x100000, 0x400000, CRC(8053a3fb) SHA1(baf40ca915d30f3dbf6cc440131e824e889940e7) )
	ROM_DEFAULT_BIOS("euro") // doesn't work with unibios

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h53 )  // mslug3c, mslug3hr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256nd.p1",  0x000000, 0x100000, CRC(9c42ca85) SHA1(7a8f77a89867b889295ae9b9dfd4ba28f02d234d) )
	ROM_LOAD16_WORD_SWAP( "256h53.p2", 0x100000, 0x400000, CRC(70129d90) SHA1(95a2cc2d314d92431223d3b66e63f8bd27d0c1da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h54 ) //mslug3ntk
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smanm57.sma",    0x0c0000, 0x040000, CRC(51f1f87c) SHA1(938dd271555d4b169ffaf101257c4f255325439b) )
	ROM_LOAD16_WORD_SWAP( "256h54.p1", 0x000000, 0x100000, CRC(46f4eb83) SHA1(00079fdcfd41e47a3097cbc58edabe8fc805329d) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h55 ) //mslug3eb
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smanm58.sma", 0x0c0000, 0x040000, CRC(c2dc0b28) SHA1(3aff37ec62def5a8f23523cb7c1988934e27ea30) )
	ROM_LOAD16_WORD_SWAP( "256eb.p1",     0x100000, 0x400000, CRC(6ec2e58d) SHA1(d83dd522a5c8a8b4bd32722967e3d934d2e73e08) )
	ROM_LOAD16_WORD_SWAP( "256h55.p2",     0x500000, 0x400000, CRC(faaf8cd8) SHA1(264018877eab84582ba553cb42d75f15c0c08f65) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h56 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h56.p1",   0x000000, 0x100000, CRC(a8c1c507) SHA1(4efb28648a59dc115497160c5586ba73bee60915) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h57 )  // mslug3g
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h57.p1", 0x000000, 0x100000, CRC(db900d4c) SHA1(3fa1b24f509df71bf16526bcb7cd647cedee7cd7) )
	ROM_LOAD16_WORD_SWAP( "256h57.p2", 0x100000, 0x400000, CRC(79ff4ac6) SHA1(70003b29d69d4fdfff33b8c0d999fbb58f3caf13) )
	ROM_DEFAULT_BIOS("euro") // doesn't work with unibios

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h58 )  // mslug3c
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h58.p1",  0x000000, 0x100000, CRC(05c99714) SHA1(da2e5b959d9327bce7b244629abaa8784af767a6) )
	ROM_LOAD16_WORD_SWAP( "256h58.p2", 0x100000, 0x400000, CRC(15bb1f0d) SHA1(bf0a6bf38a4addcf9a7a08b04943594666347d6a) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h59 ) //mslug31v2
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma_h68",    0x0c0000, 0x040000, CRC(1c090500) SHA1(d4ca78c9848418ff89a3d756051051a6c1125b52) )
	ROM_LOAD16_WORD_SWAP( "256.p1", 0x100000, 0x400000, CRC(b07edfd5) SHA1(dcbd9e500bfae98d754e55cdbbbbf9401013f8ee) )
	ROM_LOAD16_WORD_SWAP( "256h59.p2", 0x500000, 0x400000, CRC(45db3f1d) SHA1(3d07c5f0eb3914acb443e151048318e498be2186) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h60 )  // mslug3c, mslug3dbcz
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h58.p1",  0x000000, 0x100000, CRC(05c99714) SHA1(da2e5b959d9327bce7b244629abaa8784af767a6) )
	ROM_LOAD16_WORD_SWAP( "256h60.p2", 0x100000, 0x400000, CRC(b948a472) SHA1(e0135911f7d7e21285e6965cc6b4446277eea405) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h61 ) //mslug3se, mslug3nse
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h61.p1",   0x000000, 0x100000, CRC(4e6753ee) SHA1(2df01bda8ed450761c5ed24a9ef1a4dfe324ab08) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h62 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h62.p1",   0x000000, 0x100000, CRC(61f2a873) SHA1(9e9804ffc94fe3262bb4e8efe1ba7e313d4ab37e) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h63 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h63.p1",   0x000000, 0x100000, CRC(9aa71333) SHA1(6c62fcee7c280b3612f0453f7b720f1e84ddeaaa) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h64 ) //mslug3es
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h64.p1",   0x000000, 0x100000, CRC(caac7e33) SHA1(098505f23e3a56e2e0cc0ae855e2457061138c9e) )
	ROM_LOAD16_WORD_SWAP( "256h64.p2", 0x100000, 0x400000, CRC(62e699b3) SHA1(eac088b21d2243198034a9796aa0815d686ccfac) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3h65 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern12.p1",   0x000000, 0x100000, CRC(0e7218a5) SHA1(7083506abb532b620a0462b24d9561eb3866ef77) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h66 ) //mslug3fkjs
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h66.p1",   0x000000, 0x100000, CRC(ac9fda79) SHA1(e09b073c6e094db6a06f8936f6493f9f3345fb6f) )
	ROM_LOAD16_WORD_SWAP( "256h66.p2", 0x100000, 0x400000, CRC(dcee52bf) SHA1(a96c5999d23cdef8c3372bc30d0f43073cf5e626) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h67 ) //mslug3fkmny
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h67.p1",   0x000000, 0x100000, CRC(18076a5f) SHA1(ccf8d87b86d407ffef7c30cef0ea515df4e3a6e1) )
	ROM_LOAD16_WORD_SWAP( "256h67.p2", 0x100000, 0x400000, CRC(dfc2b3a6) SHA1(d0cfc0f61300bb97adec04eca9d20e9d9663c5c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h68 ) //mslug3lw
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h68.p1",   0x000000, 0x100000, CRC(05ab3e43) SHA1(c90ce61382817283cc496284be94c490fc9a35fc) )
	ROM_LOAD16_WORD_SWAP( "256h68.p2", 0x100000, 0x400000, CRC(7eed7c81) SHA1(1d9a18178b14226be60af683c9c4a7cfada7f0bb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3h69 ) //mslug3hr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h69.p1",   0x000000, 0x100000, CRC(920a3352) SHA1(cc4036f4ecea65d87b8b4f4530a6ac101b89d4a7) )
	ROM_LOAD16_WORD_SWAP( "256h64.p2", 0x100000, 0x400000, CRC(62e699b3) SHA1(eac088b21d2243198034a9796aa0815d686ccfac) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256d.c7",  0x3000000, 0x800000, CRC(9395b809) SHA1(ca9ac9832017094eee3623f0b6c4c4b7b4f1374d) )
	ROM_LOAD16_BYTE( "256d.c8",  0x3000001, 0x800000, CRC(a369f9d4) SHA1(f8146ea80a1a23da7e7e04c88f778ee9abdfeb5c) )
ROM_END

ROM_START( mslug3h70 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h70.p1",   0x000000, 0x100000, CRC(c95154fc) SHA1(3386666a7df034ae7cf4ea0980cea89f9d76aef7) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3h71 ) //mslug3maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h71.p1",   0x000000, 0x100000, CRC(72b61239) SHA1(0204df4cb5a76859b97a5157c55b3a3046b412cf) )
	ROM_LOAD16_WORD_SWAP( "256h.p2", 0x100000, 0x400000, CRC(1f3d8ce8) SHA1(08b05a8abfb86ec09a5e758d6273acf1489961f9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1",   0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2",   0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3",   0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4",   0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5",   0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6",   0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7",   0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8",   0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END

ROM_START( mslug3ern01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h52.p1", 0x000000, 0x100000, CRC(b23bd9b7) SHA1(4a5e877bc0d4853dc9c5a2c179049fbdd5285239) )
	ROM_LOAD16_WORD_SWAP( "256ern01.p2", 0x100000, 0x400000, CRC(65d63064) SHA1(3da7fd5e0f87073d879c16966475bd7cdbf30a64) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern02.p1",   0x000000, 0x100000, CRC(fb23d70d) SHA1(b3589a37aa92dd73babe69a4292f6ba3449c619b) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern03.p1", 0x000000, 0x100000, CRC(aa35973b) SHA1(cd1fedbdc7ec638987085a55f098c15a3b89bc6b) )
	ROM_LOAD16_WORD_SWAP( "256ern03.p2", 0x100000, 0x400000, CRC(fc88fdd4) SHA1(c23c752bd5f2eafbf9aa3ca2c5632de4559c9f07) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern04.p1",  0x000000, 0x100000, CRC(e16a7839) SHA1(1da694d8bf3dbb51d98fe6e9e32f1497ca44e0d4) )
	ROM_LOAD16_WORD_SWAP( "256ern04.p2", 0x100000, 0x400000, CRC(4ba2d098) SHA1(a6055677a7e4fab0565be6c6616411f3f1d62f20) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern05.p1",   0x000000, 0x100000, CRC(0e04aae3) SHA1(fcc8b7425cee8f80db1636977c90a334989e864c) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern06.p1",   0x000000, 0x100000, CRC(d7646a82) SHA1(e3d9b4605ab0e7a8579cb6d2ccb1b007d4fa0974) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern07.p1",   0x000000, 0x100000, CRC(df9038ef) SHA1(dee4794dba2fea08c25e25739b74536478c565e0) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern08.p1",   0x000000, 0x100000, CRC(ba095e8c) SHA1(dba6608b2058d4da54f4c21f19d7ddb3ed534511) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern09.p1",   0x000000, 0x100000, CRC(0e91eeaa) SHA1(742fa493bdddf3c54b5762044cc9b95372ddda8b) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern10.p1",   0x000000, 0x100000, CRC(a4c18762) SHA1(6af9264229280ac2e8359d4155d0e120e6c29465) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern11.p1",   0x000000, 0x100000, CRC(79c73bb5) SHA1(f50e69e308c89badd2e12518d0c5437e50a185d2) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3ern12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern12.p1",   0x000000, 0x100000, CRC(0e7218a5) SHA1(7083506abb532b620a0462b24d9561eb3866ef77) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h52.p1", 0x000000, 0x100000, CRC(b23bd9b7) SHA1(4a5e877bc0d4853dc9c5a2c179049fbdd5285239) )
	ROM_LOAD16_WORD_SWAP( "256esra01.p2", 0x100000, 0x400000, CRC(57ee86b6) SHA1(5f86bb48dd9e2e4cc46c988b4aa24511a67e649f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern02.p1",   0x000000, 0x100000, CRC(fb23d70d) SHA1(b3589a37aa92dd73babe69a4292f6ba3449c619b) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern03.p1", 0x000000, 0x100000, CRC(aa35973b) SHA1(cd1fedbdc7ec638987085a55f098c15a3b89bc6b) )
	ROM_LOAD16_WORD_SWAP( "256esra03.p2", 0x100000, 0x400000, CRC(d0489d69) SHA1(4dc85c3431a8d8af926bc13c35fc75f79002e70f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern04.p1",  0x000000, 0x100000, CRC(e16a7839) SHA1(1da694d8bf3dbb51d98fe6e9e32f1497ca44e0d4) )
	ROM_LOAD16_WORD_SWAP( "256esra04.p2", 0x100000, 0x400000, CRC(cdef8d8a) SHA1(b7e767cc7973ce3d06de7f71b5f80a8c6854905f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern05.p1",   0x000000, 0x100000, CRC(0e04aae3) SHA1(fcc8b7425cee8f80db1636977c90a334989e864c) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern06.p1",   0x000000, 0x100000, CRC(d7646a82) SHA1(e3d9b4605ab0e7a8579cb6d2ccb1b007d4fa0974) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern07.p1",   0x000000, 0x100000, CRC(df9038ef) SHA1(dee4794dba2fea08c25e25739b74536478c565e0) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern08.p1",   0x000000, 0x100000, CRC(ba095e8c) SHA1(dba6608b2058d4da54f4c21f19d7ddb3ed534511) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern09.p1",   0x000000, 0x100000, CRC(0e91eeaa) SHA1(742fa493bdddf3c54b5762044cc9b95372ddda8b) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern10.p1",   0x000000, 0x100000, CRC(a4c18762) SHA1(6af9264229280ac2e8359d4155d0e120e6c29465) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern11.p1",   0x000000, 0x100000, CRC(79c73bb5) SHA1(f50e69e308c89badd2e12518d0c5437e50a185d2) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esra12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern12.p1",   0x000000, 0x100000, CRC(0e7218a5) SHA1(7083506abb532b620a0462b24d9561eb3866ef77) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h52.p1", 0x000000, 0x100000, CRC(b23bd9b7) SHA1(4a5e877bc0d4853dc9c5a2c179049fbdd5285239) )
	ROM_LOAD16_WORD_SWAP( "256esrb01.p2", 0x100000, 0x400000, CRC(9cdcdd0f) SHA1(f0e7d4442df5296e93cce3da3ae70e22dae648d7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern02.p1",   0x000000, 0x100000, CRC(fb23d70d) SHA1(b3589a37aa92dd73babe69a4292f6ba3449c619b) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern03.p1", 0x000000, 0x100000, CRC(aa35973b) SHA1(cd1fedbdc7ec638987085a55f098c15a3b89bc6b) )
	ROM_LOAD16_WORD_SWAP( "256esrb03.p2", 0x100000, 0x400000, CRC(bf1e70ac) SHA1(5c8aa55f5590ae1d78866d6443938829340147e6) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern04.p1",  0x000000, 0x100000, CRC(e16a7839) SHA1(1da694d8bf3dbb51d98fe6e9e32f1497ca44e0d4) )
	ROM_LOAD16_WORD_SWAP( "256esrb04.p2", 0x100000, 0x400000, CRC(1762b2ea) SHA1(4e504e397856cd1a24432e4e2c5a8b8594981fa9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern05.p1",   0x000000, 0x100000, CRC(0e04aae3) SHA1(fcc8b7425cee8f80db1636977c90a334989e864c) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern06.p1",   0x000000, 0x100000, CRC(d7646a82) SHA1(e3d9b4605ab0e7a8579cb6d2ccb1b007d4fa0974) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern07.p1",   0x000000, 0x100000, CRC(df9038ef) SHA1(dee4794dba2fea08c25e25739b74536478c565e0) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern08.p1",   0x000000, 0x100000, CRC(ba095e8c) SHA1(dba6608b2058d4da54f4c21f19d7ddb3ed534511) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern09.p1",   0x000000, 0x100000, CRC(0e91eeaa) SHA1(742fa493bdddf3c54b5762044cc9b95372ddda8b) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern10.p1",   0x000000, 0x100000, CRC(a4c18762) SHA1(6af9264229280ac2e8359d4155d0e120e6c29465) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern11.p1",   0x000000, 0x100000, CRC(79c73bb5) SHA1(f50e69e308c89badd2e12518d0c5437e50a185d2) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrb12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern12.p1",   0x000000, 0x100000, CRC(0e7218a5) SHA1(7083506abb532b620a0462b24d9561eb3866ef77) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h52.p1", 0x000000, 0x100000, CRC(b23bd9b7) SHA1(4a5e877bc0d4853dc9c5a2c179049fbdd5285239) )
	ROM_LOAD16_WORD_SWAP( "256esrc01.p2", 0x100000, 0x400000, CRC(131ac241) SHA1(ba47bd4a46d4dd233f7cb0bf32fcb92f98e8a48d) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern02.p1",   0x000000, 0x100000, CRC(fb23d70d) SHA1(b3589a37aa92dd73babe69a4292f6ba3449c619b) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern03.p1", 0x000000, 0x100000, CRC(aa35973b) SHA1(cd1fedbdc7ec638987085a55f098c15a3b89bc6b) )
	ROM_LOAD16_WORD_SWAP( "256esrc03.p2", 0x100000, 0x400000, CRC(e4ee05f9) SHA1(bd8ed555e751de8dfd88ea114c49b78663a3ad99) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern04.p1",  0x000000, 0x100000, CRC(e16a7839) SHA1(1da694d8bf3dbb51d98fe6e9e32f1497ca44e0d4) )
	ROM_LOAD16_WORD_SWAP( "256esrc04.p2", 0x100000, 0x400000, CRC(fb60a555) SHA1(9ece6e68ccc28a29def3288d20ac5e576e76d230) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern05.p1",   0x000000, 0x100000, CRC(0e04aae3) SHA1(fcc8b7425cee8f80db1636977c90a334989e864c) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern06.p1",   0x000000, 0x100000, CRC(d7646a82) SHA1(e3d9b4605ab0e7a8579cb6d2ccb1b007d4fa0974) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern07.p1",   0x000000, 0x100000, CRC(df9038ef) SHA1(dee4794dba2fea08c25e25739b74536478c565e0) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern08.p1",   0x000000, 0x100000, CRC(ba095e8c) SHA1(dba6608b2058d4da54f4c21f19d7ddb3ed534511) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern09.p1",   0x000000, 0x100000, CRC(0e91eeaa) SHA1(742fa493bdddf3c54b5762044cc9b95372ddda8b) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern10.p1",   0x000000, 0x100000, CRC(a4c18762) SHA1(6af9264229280ac2e8359d4155d0e120e6c29465) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern11.p1",   0x000000, 0x100000, CRC(79c73bb5) SHA1(f50e69e308c89badd2e12518d0c5437e50a185d2) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrc12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern12.p1",   0x000000, 0x100000, CRC(0e7218a5) SHA1(7083506abb532b620a0462b24d9561eb3866ef77) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256h52.p1", 0x000000, 0x100000, CRC(b23bd9b7) SHA1(4a5e877bc0d4853dc9c5a2c179049fbdd5285239) )
	ROM_LOAD16_WORD_SWAP( "256esrd01.p2", 0x100000, 0x400000, CRC(26310634) SHA1(4af6d8d63478703a6a92045161db8478003125a4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern02.p1",   0x000000, 0x100000, CRC(fb23d70d) SHA1(b3589a37aa92dd73babe69a4292f6ba3449c619b) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_128K( "256h50.s1", CRC(8458fff9) SHA1(b120d096deae8abf0ad98362ce230b66e7315a14) )

	NEO_BIOS_AUDIO_512K( "256h46.m1", CRC(c84d22f2) SHA1(069d5eafa859acbebc35394344df78ea84055cf7) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256h46.v4", 0xc00000, 0x400000, CRC(b45d9a3b) SHA1(eee342e11865facbbfcaf82b8e16b9e64b8c309c) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern03.p1", 0x000000, 0x100000, CRC(aa35973b) SHA1(cd1fedbdc7ec638987085a55f098c15a3b89bc6b) )
	ROM_LOAD16_WORD_SWAP( "256esrd03.p2", 0x100000, 0x400000, CRC(bf6fcb84) SHA1(0ec1a9adc557d4c8189997d5564d6b53c60c3289) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern04.p1",  0x000000, 0x100000, CRC(e16a7839) SHA1(1da694d8bf3dbb51d98fe6e9e32f1497ca44e0d4) )
	ROM_LOAD16_WORD_SWAP( "256esrd04.p2", 0x100000, 0x400000, CRC(29eac9ad) SHA1(80a24787fb7fc13d2704cd5255258117d6c6fe08) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern05.p1",   0x000000, 0x100000, CRC(0e04aae3) SHA1(fcc8b7425cee8f80db1636977c90a334989e864c) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern06.p1",   0x000000, 0x100000, CRC(d7646a82) SHA1(e3d9b4605ab0e7a8579cb6d2ccb1b007d4fa0974) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern07.p1",   0x000000, 0x100000, CRC(df9038ef) SHA1(dee4794dba2fea08c25e25739b74536478c565e0) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern08.p1",   0x000000, 0x100000, CRC(ba095e8c) SHA1(dba6608b2058d4da54f4c21f19d7ddb3ed534511) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern09.p1",   0x000000, 0x100000, CRC(0e91eeaa) SHA1(742fa493bdddf3c54b5762044cc9b95372ddda8b) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern10.p1",   0x000000, 0x100000, CRC(a4c18762) SHA1(6af9264229280ac2e8359d4155d0e120e6c29465) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern11.p1",   0x000000, 0x100000, CRC(79c73bb5) SHA1(f50e69e308c89badd2e12518d0c5437e50a185d2) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3esrd12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256ern12.p1",   0x000000, 0x100000, CRC(0e7218a5) SHA1(7083506abb532b620a0462b24d9561eb3866ef77) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3la01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256la01.p2", 0x100000, 0x400000, CRC(27dc6f2b) SHA1(2d81eb5043e4f357a31e1470787fec0c1cd22fa3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3la02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256la02.p2", 0x100000, 0x400000, CRC(a1913239) SHA1(1296297b4120c65a2c5e921bf7b7fb0c4cfea8c7) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3la03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256la03.p2", 0x100000, 0x400000, CRC(b9321fe5) SHA1(48cf0410f1e5997eac4ecec75996ab2e78ed1a43) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3la04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256la04.p2", 0x100000, 0x400000, CRC(2d2d610a) SHA1(0269d9219f57e37e4d54afc84e633ff2e4b317f2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3la05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256la05.p2", 0x100000, 0x400000, CRC(4594761e) SHA1(04d05d0fc8603ac52ef2bf3574009311cf4d7f48) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lb01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lb01.p2", 0x100000, 0x400000, CRC(d5f73f0a) SHA1(9f4ae5a8c498b104c8b5dec73dfc9ecaf2c49388) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lb02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lb02.p2", 0x100000, 0x400000, CRC(53ba6218) SHA1(1a9f0ba90e9130d691ed5b6db0890664b2369b75) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lb03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lb03.p2", 0x100000, 0x400000, CRC(4b194fc4) SHA1(53a988188f9628994454dee514d11e57967f1929) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lb04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lb04.p2", 0x100000, 0x400000, CRC(df06312b) SHA1(18445de41ec1fbbdac1c274aebe070f85216adcc) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lb05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lb05.p2", 0x100000, 0x400000, CRC(b7bf263f) SHA1(965815a9502385f3bd68a68a86eca176b1c7a1d2) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lc01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lc01.p2", 0x100000, 0x400000, CRC(093996c4) SHA1(a567f1476987ca3533815063c416eb3109751e56) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lc02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lc02.p2", 0x100000, 0x400000, CRC(8f74cbd6) SHA1(2ce942568ba777fc2e8b9ced5f265303986e3b4b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lc03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lc03.p2", 0x100000, 0x400000, CRC(15dd3af7) SHA1(f60c7fab2d64024e3fc72667661e1fc4c75af996) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3lc04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256la01.p1",   0x000000, 0x100000, CRC(8a83a696) SHA1(23ddfc7f3748934e40b489403f7672a8016df940) )
	ROM_LOAD16_WORD_SWAP( "256lc04.p2", 0x100000, 0x400000, CRC(198bd398) SHA1(fbc578ad48483f49148af86b691d0f10e0154251) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256d.c1",  0x0000000, 0x800000, CRC(3540398c) SHA1(0a96f2360eb26c66bf02bbc6f52230b55cc95e4e) )
	ROM_LOAD16_BYTE( "256d.c2",  0x0000001, 0x800000, CRC(bdd220f0) SHA1(f52851023f3bc120b05f622af0e0ab1bedc41604) )
	ROM_LOAD16_BYTE( "256d.c3",  0x1000000, 0x800000, CRC(bfaade82) SHA1(66b07e592c9a9b35567fe463496f8f75c32a7db9) )
	ROM_LOAD16_BYTE( "256d.c4",  0x1000001, 0x800000, CRC(1463add6) SHA1(4db91b46d6430da272d27d00a6dc0eb25949bea1) )
	ROM_LOAD16_BYTE( "256d.c5",  0x2000000, 0x800000, CRC(48ca7f28) SHA1(e903876be5fb4fa582c988d74c6bef1c3b9c7083) )
	ROM_LOAD16_BYTE( "256d.c6",  0x2000001, 0x800000, CRC(806eb36f) SHA1(a412a9cab80c326733dde7652d1db2a46afb3ebb) )
	ROM_LOAD16_BYTE( "256h54.c7", 0x3000000, 0x800000, CRC(ed559fac) SHA1(e2e73b068785226cd97abbb8c2bd2b5800e9bf19) )
	ROM_LOAD16_BYTE( "256h54.c8", 0x3000001, 0x800000, CRC(1c52378b) SHA1(05cd499f5444eae6360c96bfd3d3db8870d9656a) )
ROM_END

ROM_START( mslug3rma01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma01.p1",  0x000000, 0x100000, CRC(8a1c667c) SHA1(7261204a49b042c325eb679b88092880238acafb) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma02.p1",  0x000000, 0x100000, CRC(763c727c) SHA1(e997b10c2b001ff33006346c5ee3467fddd27f43) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma03.p1",  0x000000, 0x100000, CRC(e7d6ad26) SHA1(7b714437bd54035d75c11002caada670f1c80a37) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma04.p1",  0x000000, 0x100000, CRC(1bf6b926) SHA1(b61eaf0ffd0abac07dfd09818799ff67d9c619ec) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma05.p1",  0x000000, 0x100000, CRC(c36f1410) SHA1(9b8a9aa252368c9da51aee557f0a03bf9dcf8254) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma06.p1",  0x000000, 0x100000, CRC(3f4f0010) SHA1(1ed2cd2b36f4fc843a32d0f1ba7063b525f63ffc) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma07.p1",  0x000000, 0x100000, CRC(aea5df4a) SHA1(5cd10aa871339611c72872292a7ad32b164ea99e) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma08.p1",  0x000000, 0x100000, CRC(5285cb4a) SHA1(48d7e7eea54e08862b1d501d222a97691b53e039) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma09.p1",  0x000000, 0x100000, CRC(af353f39) SHA1(177df5ea8ddba5d1467130e50a545c585189b37f) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma10.p1",  0x000000, 0x100000, CRC(53152b39) SHA1(2fba0e01eaa26d6f20aa891c78c60eee5367d596) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma11.p1",  0x000000, 0x100000, CRC(74a0a98d) SHA1(86813af5dfe52d732dee668d107fc822ad436d74) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma12.p1",  0x000000, 0x100000, CRC(8880bd8d) SHA1(781b3b5a8404faa0e83940ab01074ecc6035f656) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma13.p1",  0x000000, 0x100000, CRC(3c433b92) SHA1(39758b6520c436cec88f1379235376a224a546a2) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma14.p1",  0x000000, 0x100000, CRC(c0632f92) SHA1(c855cb695dd8a5fa5b3465ed18d02ece03c866ca) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma15.p1",  0x000000, 0x100000, CRC(76118918) SHA1(ea5651eee182f682406dafa721c297ee33968743) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma16.p1",  0x000000, 0x100000, CRC(8a319d18) SHA1(1297a99e7b4083b6b81e6f6b1c41821618ae561a) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma17.p1",  0x000000, 0x100000, CRC(5189f0c8) SHA1(9c72c99e988b5adaa3b9d2e9fa499374b3cc5e9d) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma18.p1",  0x000000, 0x100000, CRC(ada9e4c8) SHA1(78741b333724a662ca342b64deacc2d3147fff7b) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma19.p1",  0x000000, 0x100000, CRC(52a8302e) SHA1(9673fc05d60cd071780a628c37025eba623cb256) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rma20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma20.p1",  0x000000, 0x100000, CRC(ae88242e) SHA1(553e13e0d21ea439c150462991b12994204b0235) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma01.p1",  0x000000, 0x100000, CRC(8a1c667c) SHA1(7261204a49b042c325eb679b88092880238acafb) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma02.p1",  0x000000, 0x100000, CRC(763c727c) SHA1(e997b10c2b001ff33006346c5ee3467fddd27f43) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma03.p1",  0x000000, 0x100000, CRC(e7d6ad26) SHA1(7b714437bd54035d75c11002caada670f1c80a37) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma04.p1",  0x000000, 0x100000, CRC(1bf6b926) SHA1(b61eaf0ffd0abac07dfd09818799ff67d9c619ec) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma05.p1",  0x000000, 0x100000, CRC(c36f1410) SHA1(9b8a9aa252368c9da51aee557f0a03bf9dcf8254) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma06.p1",  0x000000, 0x100000, CRC(3f4f0010) SHA1(1ed2cd2b36f4fc843a32d0f1ba7063b525f63ffc) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma07.p1",  0x000000, 0x100000, CRC(aea5df4a) SHA1(5cd10aa871339611c72872292a7ad32b164ea99e) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma08.p1",  0x000000, 0x100000, CRC(5285cb4a) SHA1(48d7e7eea54e08862b1d501d222a97691b53e039) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma09.p1",  0x000000, 0x100000, CRC(af353f39) SHA1(177df5ea8ddba5d1467130e50a545c585189b37f) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma10.p1",  0x000000, 0x100000, CRC(53152b39) SHA1(2fba0e01eaa26d6f20aa891c78c60eee5367d596) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma11.p1",  0x000000, 0x100000, CRC(74a0a98d) SHA1(86813af5dfe52d732dee668d107fc822ad436d74) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma12.p1",  0x000000, 0x100000, CRC(8880bd8d) SHA1(781b3b5a8404faa0e83940ab01074ecc6035f656) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma13.p1",  0x000000, 0x100000, CRC(3c433b92) SHA1(39758b6520c436cec88f1379235376a224a546a2) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma14.p1",  0x000000, 0x100000, CRC(c0632f92) SHA1(c855cb695dd8a5fa5b3465ed18d02ece03c866ca) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma15.p1",  0x000000, 0x100000, CRC(76118918) SHA1(ea5651eee182f682406dafa721c297ee33968743) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma16.p1",  0x000000, 0x100000, CRC(8a319d18) SHA1(1297a99e7b4083b6b81e6f6b1c41821618ae561a) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma17.p1",  0x000000, 0x100000, CRC(5189f0c8) SHA1(9c72c99e988b5adaa3b9d2e9fa499374b3cc5e9d) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma18.p1",  0x000000, 0x100000, CRC(ada9e4c8) SHA1(78741b333724a662ca342b64deacc2d3147fff7b) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma19.p1",  0x000000, 0x100000, CRC(52a8302e) SHA1(9673fc05d60cd071780a628c37025eba623cb256) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmb20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma20.p1",  0x000000, 0x100000, CRC(ae88242e) SHA1(553e13e0d21ea439c150462991b12994204b0235) )
	ROM_LOAD16_WORD_SWAP( "256rmx01.p2", 0x100000, 0x400000, CRC(3938ca72) SHA1(857746547d2b00be8d2f7b00aa45c9d0f787fec4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma01.p1",  0x000000, 0x100000, CRC(8a1c667c) SHA1(7261204a49b042c325eb679b88092880238acafb) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma02.p1",  0x000000, 0x100000, CRC(763c727c) SHA1(e997b10c2b001ff33006346c5ee3467fddd27f43) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma03.p1",  0x000000, 0x100000, CRC(e7d6ad26) SHA1(7b714437bd54035d75c11002caada670f1c80a37) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma04.p1",  0x000000, 0x100000, CRC(1bf6b926) SHA1(b61eaf0ffd0abac07dfd09818799ff67d9c619ec) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma05.p1",  0x000000, 0x100000, CRC(c36f1410) SHA1(9b8a9aa252368c9da51aee557f0a03bf9dcf8254) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma06.p1",  0x000000, 0x100000, CRC(3f4f0010) SHA1(1ed2cd2b36f4fc843a32d0f1ba7063b525f63ffc) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma07.p1",  0x000000, 0x100000, CRC(aea5df4a) SHA1(5cd10aa871339611c72872292a7ad32b164ea99e) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma08.p1",  0x000000, 0x100000, CRC(5285cb4a) SHA1(48d7e7eea54e08862b1d501d222a97691b53e039) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma09.p1",  0x000000, 0x100000, CRC(af353f39) SHA1(177df5ea8ddba5d1467130e50a545c585189b37f) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma10.p1",  0x000000, 0x100000, CRC(53152b39) SHA1(2fba0e01eaa26d6f20aa891c78c60eee5367d596) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma11.p1",  0x000000, 0x100000, CRC(74a0a98d) SHA1(86813af5dfe52d732dee668d107fc822ad436d74) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma12.p1",  0x000000, 0x100000, CRC(8880bd8d) SHA1(781b3b5a8404faa0e83940ab01074ecc6035f656) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma13.p1",  0x000000, 0x100000, CRC(3c433b92) SHA1(39758b6520c436cec88f1379235376a224a546a2) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma14.p1",  0x000000, 0x100000, CRC(c0632f92) SHA1(c855cb695dd8a5fa5b3465ed18d02ece03c866ca) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma15.p1",  0x000000, 0x100000, CRC(76118918) SHA1(ea5651eee182f682406dafa721c297ee33968743) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma16.p1",  0x000000, 0x100000, CRC(8a319d18) SHA1(1297a99e7b4083b6b81e6f6b1c41821618ae561a) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma17.p1",  0x000000, 0x100000, CRC(5189f0c8) SHA1(9c72c99e988b5adaa3b9d2e9fa499374b3cc5e9d) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma18.p1",  0x000000, 0x100000, CRC(ada9e4c8) SHA1(78741b333724a662ca342b64deacc2d3147fff7b) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma19.p1",  0x000000, 0x100000, CRC(52a8302e) SHA1(9673fc05d60cd071780a628c37025eba623cb256) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmc20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma20.p1",  0x000000, 0x100000, CRC(ae88242e) SHA1(553e13e0d21ea439c150462991b12994204b0235) )
	ROM_LOAD16_WORD_SWAP( "256rmx02.p2", 0x100000, 0x400000, CRC(d9fc1644) SHA1(e6ebd51272c9cf55295ada983f41b96803fbe036) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma01.p1",  0x000000, 0x100000, CRC(8a1c667c) SHA1(7261204a49b042c325eb679b88092880238acafb) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma02.p1",  0x000000, 0x100000, CRC(763c727c) SHA1(e997b10c2b001ff33006346c5ee3467fddd27f43) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma03.p1",  0x000000, 0x100000, CRC(e7d6ad26) SHA1(7b714437bd54035d75c11002caada670f1c80a37) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma04.p1",  0x000000, 0x100000, CRC(1bf6b926) SHA1(b61eaf0ffd0abac07dfd09818799ff67d9c619ec) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma05.p1",  0x000000, 0x100000, CRC(c36f1410) SHA1(9b8a9aa252368c9da51aee557f0a03bf9dcf8254) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma06.p1",  0x000000, 0x100000, CRC(3f4f0010) SHA1(1ed2cd2b36f4fc843a32d0f1ba7063b525f63ffc) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma07.p1",  0x000000, 0x100000, CRC(aea5df4a) SHA1(5cd10aa871339611c72872292a7ad32b164ea99e) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma08.p1",  0x000000, 0x100000, CRC(5285cb4a) SHA1(48d7e7eea54e08862b1d501d222a97691b53e039) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma09.p1",  0x000000, 0x100000, CRC(af353f39) SHA1(177df5ea8ddba5d1467130e50a545c585189b37f) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma10.p1",  0x000000, 0x100000, CRC(53152b39) SHA1(2fba0e01eaa26d6f20aa891c78c60eee5367d596) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma11.p1",  0x000000, 0x100000, CRC(74a0a98d) SHA1(86813af5dfe52d732dee668d107fc822ad436d74) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma12.p1",  0x000000, 0x100000, CRC(8880bd8d) SHA1(781b3b5a8404faa0e83940ab01074ecc6035f656) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma13.p1",  0x000000, 0x100000, CRC(3c433b92) SHA1(39758b6520c436cec88f1379235376a224a546a2) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma14.p1",  0x000000, 0x100000, CRC(c0632f92) SHA1(c855cb695dd8a5fa5b3465ed18d02ece03c866ca) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma15.p1",  0x000000, 0x100000, CRC(76118918) SHA1(ea5651eee182f682406dafa721c297ee33968743) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma16.p1",  0x000000, 0x100000, CRC(8a319d18) SHA1(1297a99e7b4083b6b81e6f6b1c41821618ae561a) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma17.p1",  0x000000, 0x100000, CRC(5189f0c8) SHA1(9c72c99e988b5adaa3b9d2e9fa499374b3cc5e9d) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma18.p1",  0x000000, 0x100000, CRC(ada9e4c8) SHA1(78741b333724a662ca342b64deacc2d3147fff7b) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma19.p1",  0x000000, 0x100000, CRC(52a8302e) SHA1(9673fc05d60cd071780a628c37025eba623cb256) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmd20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma20.p1",  0x000000, 0x100000, CRC(ae88242e) SHA1(553e13e0d21ea439c150462991b12994204b0235) )
	ROM_LOAD16_WORD_SWAP( "256rmx03.p2", 0x100000, 0x400000, CRC(5d8ee1ff) SHA1(6cbcfed6fac20674c7919d5dc6e40ae14ade22da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma01.p1",  0x000000, 0x100000, CRC(8a1c667c) SHA1(7261204a49b042c325eb679b88092880238acafb) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma02.p1",  0x000000, 0x100000, CRC(763c727c) SHA1(e997b10c2b001ff33006346c5ee3467fddd27f43) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma03.p1",  0x000000, 0x100000, CRC(e7d6ad26) SHA1(7b714437bd54035d75c11002caada670f1c80a37) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma04.p1",  0x000000, 0x100000, CRC(1bf6b926) SHA1(b61eaf0ffd0abac07dfd09818799ff67d9c619ec) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma05.p1",  0x000000, 0x100000, CRC(c36f1410) SHA1(9b8a9aa252368c9da51aee557f0a03bf9dcf8254) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme06 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma06.p1",  0x000000, 0x100000, CRC(3f4f0010) SHA1(1ed2cd2b36f4fc843a32d0f1ba7063b525f63ffc) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme07 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma07.p1",  0x000000, 0x100000, CRC(aea5df4a) SHA1(5cd10aa871339611c72872292a7ad32b164ea99e) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme08 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma08.p1",  0x000000, 0x100000, CRC(5285cb4a) SHA1(48d7e7eea54e08862b1d501d222a97691b53e039) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme09 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma09.p1",  0x000000, 0x100000, CRC(af353f39) SHA1(177df5ea8ddba5d1467130e50a545c585189b37f) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme10 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma10.p1",  0x000000, 0x100000, CRC(53152b39) SHA1(2fba0e01eaa26d6f20aa891c78c60eee5367d596) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme11 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma11.p1",  0x000000, 0x100000, CRC(74a0a98d) SHA1(86813af5dfe52d732dee668d107fc822ad436d74) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme12 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma12.p1",  0x000000, 0x100000, CRC(8880bd8d) SHA1(781b3b5a8404faa0e83940ab01074ecc6035f656) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme13 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma13.p1",  0x000000, 0x100000, CRC(3c433b92) SHA1(39758b6520c436cec88f1379235376a224a546a2) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme14 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma14.p1",  0x000000, 0x100000, CRC(c0632f92) SHA1(c855cb695dd8a5fa5b3465ed18d02ece03c866ca) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme15 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma15.p1",  0x000000, 0x100000, CRC(76118918) SHA1(ea5651eee182f682406dafa721c297ee33968743) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme16 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma16.p1",  0x000000, 0x100000, CRC(8a319d18) SHA1(1297a99e7b4083b6b81e6f6b1c41821618ae561a) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme17 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma17.p1",  0x000000, 0x100000, CRC(5189f0c8) SHA1(9c72c99e988b5adaa3b9d2e9fa499374b3cc5e9d) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme18 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma18.p1",  0x000000, 0x100000, CRC(ada9e4c8) SHA1(78741b333724a662ca342b64deacc2d3147fff7b) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme19 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma19.p1",  0x000000, 0x100000, CRC(52a8302e) SHA1(9673fc05d60cd071780a628c37025eba623cb256) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rme20 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma20.p1",  0x000000, 0x100000, CRC(ae88242e) SHA1(553e13e0d21ea439c150462991b12994204b0235) )
	ROM_LOAD16_WORD_SWAP( "256rmx04.p2", 0x100000, 0x400000, CRC(22bbbee1) SHA1(e55b221b2b07f7d22693a22c189de4ded39f9e32) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmf01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rmf01.p1",  0x000000, 0x100000, CRC(4b348959) SHA1(5bafc07e9d04966e9285fe3b00f4f4e2aaba91e7) )
	ROM_LOAD16_WORD_SWAP( "256lb01.p2", 0x100000, 0x400000, CRC(d5f73f0a) SHA1(9f4ae5a8c498b104c8b5dec73dfc9ecaf2c49388) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmf02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rmf01.p1",  0x000000, 0x100000, CRC(4b348959) SHA1(5bafc07e9d04966e9285fe3b00f4f4e2aaba91e7) )
	ROM_LOAD16_WORD_SWAP( "256lb04.p2", 0x100000, 0x400000, CRC(df06312b) SHA1(18445de41ec1fbbdac1c274aebe070f85216adcc) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmf03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rmf01.p1",  0x000000, 0x100000, CRC(4b348959) SHA1(5bafc07e9d04966e9285fe3b00f4f4e2aaba91e7) )
	ROM_LOAD16_WORD_SWAP( "256lb03.p2", 0x100000, 0x400000, CRC(4b194fc4) SHA1(53a988188f9628994454dee514d11e57967f1929) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmf04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rmf01.p1",  0x000000, 0x100000, CRC(4b348959) SHA1(5bafc07e9d04966e9285fe3b00f4f4e2aaba91e7) )
	ROM_LOAD16_WORD_SWAP( "256lb02.p2", 0x100000, 0x400000, CRC(53ba6218) SHA1(1a9f0ba90e9130d691ed5b6db0890664b2369b75) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmf05 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rmf01.p1",  0x000000, 0x100000, CRC(4b348959) SHA1(5bafc07e9d04966e9285fe3b00f4f4e2aaba91e7) )
	ROM_LOAD16_WORD_SWAP( "256lb00.p2", 0x100000, 0x400000, CRC(a3fecb0f) SHA1(083f649727d59b4724c405d5a428e0b11bb9e41b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmg01 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma03.p1",  0x000000, 0x100000, CRC(e7d6ad26) SHA1(7b714437bd54035d75c11002caada670f1c80a37) )
	ROM_LOAD16_WORD_SWAP( "256rmx05.p2", 0x100000, 0x400000, CRC(8692551e) SHA1(d535b436bc57b41af83a5836190f6decba178358) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmg02 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma04.p1",  0x000000, 0x100000, CRC(1bf6b926) SHA1(b61eaf0ffd0abac07dfd09818799ff67d9c619ec) )
	ROM_LOAD16_WORD_SWAP( "256rmx05.p2", 0x100000, 0x400000, CRC(8692551e) SHA1(d535b436bc57b41af83a5836190f6decba178358) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmg03 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma15.p1",  0x000000, 0x100000, CRC(76118918) SHA1(ea5651eee182f682406dafa721c297ee33968743) )
	ROM_LOAD16_WORD_SWAP( "256rmx05.p2", 0x100000, 0x400000, CRC(8692551e) SHA1(d535b436bc57b41af83a5836190f6decba178358) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3rmg04 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "256rma16.p1",  0x000000, 0x100000, CRC(8a319d18) SHA1(1297a99e7b4083b6b81e6f6b1c41821618ae561a) )
	ROM_LOAD16_WORD_SWAP( "256rmx05.p2", 0x100000, 0x400000, CRC(8692551e) SHA1(d535b436bc57b41af83a5836190f6decba178358) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256h07.c1",   0x0000000, 0x800000, CRC(d93a9a86) SHA1(4ff06026449c80ef8effc14f241590fef83006c9) )
	ROM_LOAD16_BYTE( "256h07.c2",   0x0000001, 0x800000, CRC(5773183c) SHA1(a09783bcaa2c071d4358e00148551e5c60e48753) )
	ROM_LOAD16_BYTE( "256h07.c3",   0x1000000, 0x800000, CRC(9bbc4d38) SHA1(65f34c09e58cfb59c45df2d14e74408d7d571b3d) )
	ROM_LOAD16_BYTE( "256h07.c4",   0x1000001, 0x800000, CRC(871eb92f) SHA1(5146975de14eb31f4df959c71659ab4cf2dbd193) )
	ROM_LOAD16_BYTE( "256h07.c5",   0x2000000, 0x800000, CRC(35f9d8d6) SHA1(da046812d9b4047e0ce84bda5e77c19cde5fce56) )
	ROM_LOAD16_BYTE( "256h07.c6",   0x2000001, 0x800000, CRC(7deeb565) SHA1(79c83d2b1887ec776fc0c24527405d386607342d) )
	ROM_LOAD16_BYTE( "256h07.c7",   0x3000000, 0x800000, CRC(a6785325) SHA1(e3377727c057dfd3e3bf91ad7a02217244335bb5) )
	ROM_LOAD16_BYTE( "256h07.c8",   0x3000001, 0x800000, CRC(b1a3a35d) SHA1(d7c41734e745445efcb33465eb7b26a88ce5a341) )
ROM_END

ROM_START( mslug3unity )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "green.neo-sma",    0x0c0000, 0x040000, CRC(3c6c536b) SHA1(e841b56e5151cf3118b7ac7f5e1495ed51378031) )
	ROM_LOAD16_WORD_SWAP( "256.p1", 0x100000, 0x400000, CRC(b07edfd5) SHA1(dcbd9e500bfae98d754e55cdbbbbf9401013f8ee) )
	ROM_LOAD16_WORD_SWAP( "256unity.p2", 0x500000, 0x400000, CRC(ea0c22b6) SHA1(564bd4609eb273a5eb7e6269ca3650fc0e1f1446) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "256.m1", CRC(eaeec116) SHA1(54419dbb21edc8c4b37eaac2e7ad9496d2de037a) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "256.v1", 0x000000, 0x400000, CRC(f2690241) SHA1(fd56babc1934d10e0d27c32f032f9edda7ca8ce9) )
	ROM_LOAD( "256.v2", 0x400000, 0x400000, CRC(7e2a10bd) SHA1(0d587fb9f64cba0315ce2d8a03e2b8fe34936dff) )
	ROM_LOAD( "256.v3", 0x800000, 0x400000, CRC(0eaec17c) SHA1(c3ed613cc6993edd6fc0d62a90bcd85de8e21915) )
	ROM_LOAD( "256.v4", 0xc00000, 0x400000, CRC(9b4b22d4) SHA1(9764fbf8453e52f80aa97a46fb9cf5937ef15a31) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "256.c1", 0x0000000, 0x800000, CRC(5a79c34e) SHA1(b8aa51fa50935cae62ab3d125b723ab888691e60) )
	ROM_LOAD16_BYTE( "256.c2", 0x0000001, 0x800000, CRC(944c362c) SHA1(3843ab300f956280475469caee70135658f67089) )
	ROM_LOAD16_BYTE( "256.c3", 0x1000000, 0x800000, CRC(6e69d36f) SHA1(94e8cf42e999114b4bd8b30e0aa2f365578c4c9a) )
	ROM_LOAD16_BYTE( "256.c4", 0x1000001, 0x800000, CRC(b755b4eb) SHA1(804700a0966a48f130c434ede3f970792ea74fa5) )
	ROM_LOAD16_BYTE( "256.c5", 0x2000000, 0x800000, CRC(7aacab47) SHA1(312c1c9846175fe1a3cad51d5ae230cf674fc93d) )
	ROM_LOAD16_BYTE( "256.c6", 0x2000001, 0x800000, CRC(c698fd5d) SHA1(16818883b06849ba2f8d61bdd5e21aaf99bd8408) )
	ROM_LOAD16_BYTE( "256.c7", 0x3000000, 0x800000, CRC(cfceddd2) SHA1(7def666adf8bd1703f40c61f182fc040b6362dc9) )
	ROM_LOAD16_BYTE( "256.c8", 0x3000001, 0x800000, CRC(4d9be34c) SHA1(a737bdfa2b815aea7067e7af2636e83a9409c414) )
ROM_END


/*    YEAR  NAME            PARENT    MACHINE        INPUT       INIT             MONITOR COMPANY                 FULLNAME FLAGS */
GAME( 2000, mslug3e02,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 02)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e03,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 03)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e04,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 04)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e05,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 05)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e06,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 06)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e07,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 07)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e08,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 08)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e09,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 09)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e10,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 10)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e11,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 11)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e12,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 12)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e13,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 13)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e14,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 14)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e15,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 15)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e16,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 16)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e17,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 17)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e18,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 18)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e19,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 19)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e20,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 20)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e21,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 21)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3e22,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 22)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslg3eha,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "HappyAsr", "Metal Slug 3 (Super D version)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslg3ehs,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix set 01)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslg3kho,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Ydmis", "Metal Slug 3 (Style remix, 2003-07-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3kh,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "Fighters Kim and Ydmis", "Metal Slug 3 (Style remix, 2003-08-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3xg,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "hack", "Metal Slug 3 (PPX Team Hack, Remixed by ZKW)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3d,     mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3d,  ROT0, "SNK", "Metal Slug 3 (Decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 2013, mslug3eb,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3,   ROT0, "PlayerX China",  "Metal Slug 3 (Green Edition, 2013-02-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, mslug3fr,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3fr, ROT0, "Arkatrad", "Metal Slug 3 (Traduction French)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, mslug3fro,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3fr, ROT0, "Arkatrad", "Metal Slug 3 (Traduction French)(Old)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, mslug3hev,   mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug3n,  ROT0, "hack", "Metal Slug 3 (Enhanced Version, 2015-05-07)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3nd,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_cmc42sfix,ROT0, "SNK", "Metal Slug 3 (Fully Decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, mslug3rb,    mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_neogeo,  ROT0, "hack", "Metal Slug 3 (Last Warhead)", MACHINE_SUPPORTS_SAVE )
GAME( 2012, mslug3v,     mslug3,   neogeo_noslot,   neogeo, neogeo_state, init_mslug6,  ROT0, "Eezezy", "Metal Slug 3 (Violence Edition, 2012-03-01)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h01,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Robert/Gaston90",    "Metal Slug 3 (Zombie Players Mode Edition, 2020-09-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h02,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",      "Metal Slug 3 (Big Fat Mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h03,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (Jump In Mid Air)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h04,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Bootleg ( ms6boot )",    "Metal Slug 3 (Change Gun version)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, mslug3h05,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "LB70",    "Metal Slug 3 (Crazy Fire Version V1.1, 2014-10-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h06,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "PlayerX China",    "Metal Slug 3 (Green Blue)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h07,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Burst Enhanced Edition, 2020-03-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, mslug3h08,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Shyma.X",    "Metal Slug 3 (Neo Arc French Traduction Rev.1)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h09,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Robert/Gaston90",    "Metal Slug 3 (Mummy Players Mode Edition, 2020-09-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h10,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Fire Bomb)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h11,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Stone Bomb)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h12,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (Change Character)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h13,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (Change Weapon)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h14,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (Change Zombie)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h15,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Prisoner Never Lost)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h16,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (Quick Go Next Mission)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h17,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Eddids[FGCH]",    "Metal Slug 3 (Unlimited Credits In Console Mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h18,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (War Chariot Rev.1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h19,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "DDJ",    "Metal Slug 3 (War Chariot Rev.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h20,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Big Heavy Machine Gun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h21,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Big Flame Shot With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h22,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Big Laser With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h23,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Big Rocket Launcher With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h24,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Big ShotGun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h25,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Drop Shot With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h26,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Enemy Chaser With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h27,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Flame Shot With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h28,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Iron Lizard With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h29,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Laser With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h30,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Satellite With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h31,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Super Grenade With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h32,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons EmmaCannon With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h33,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Heavy Machine Gun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h34,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons ShotGun With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h35,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Thunder Cloud With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h36,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis",    "Metal Slug 3 (Weapons Rocket Launcher With Infinite Ammo)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, mslug3h37,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "PlayerX China",    "Metal Slug 3 (Out Of Blue)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h38,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Burst Enhanced Edition, 2020-03-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug3h39,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Enemy Soldier Reset Alpha, 2014-01-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug3h41,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Store Version, 2017-12-16)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug3h42,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Summon Mount Edition, 2017-04-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, mslug3h43,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3fr,  ROT0, "Shyma.X",    "Metal Slug 3 (Neo Arc French Traduction Rev.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h44,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Burst Enhanced Edition, 2020-04-28)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h45,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Ydmis/Gaston90",    "Metal Slug 3 (248 grenades, 2020-05-31)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug3h46,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "hack",  "Metal Slug 3 (Ghost Wu Zuoma, 2018-05-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, mslug3h47,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Summon Mount Prototype Rev.1, 2017-10-09)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h48,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 3 (Enemies Resetting Version, 2019-04-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug3h49,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Enhanced Edition, 2018-05-09)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h51,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "hack",    "Metal Slug 3 (Enemy Soldiers Reset, 2019-01-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h52,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "CiBaoXianQuan",    "Metal Slug 3 (Multi-Function Version, 2019-01-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h53,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 3 (Enemies Resetting Version, 2019-02-12)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, mslug3h54,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3n,   ROT0, "hack",    "Metal Slug 3 (Summon Mount Prototype Rev.2, 2017-08-13)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, mslug3h55,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3,    ROT0, "hack",  "Metal Slug 3 (Green Edition, 2014-10-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h56,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "I love Nimes",     "Metal Slug 3 (Burst Enhanced Edition, 2020-03-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h57,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "CiBaoXianQuan",    "Metal Slug 3 (Multi-Function Version, 2019-02-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h58,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 3 (Enemies Resetting Version, 2019-04-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h59,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3,    ROT0, "hack",  "Metal Slug 3 (Generation 1V2, 2019-05-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h60,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "XiaShuiDaoMeiRenYu",    "Metal Slug 3 (Enemies Resetting Version, 2019-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h61,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (SE Special Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, mslug3h62,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Shotgun Flash Off)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, mslug3h63,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Mount Enhanced, 2019-04-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h64,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "hack",    "Metal Slug 3 (Ultimate Simplified Edition, 2020-08-25)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h65,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Hybrid Bullets Version, 2020-09-12)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h66,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "hack",    "Metal Slug 3 (Crazy Zombie, 2020-09-12)", MACHINE_SUPPORTS_SAVE ) //It is unstable and can crash suddenly at any level, the problem is generated by the file .p1.
GAME( 2020, mslug3h67,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "hack",    "Metal Slug 3 (Crazy Mummy, 2020-09-05)", MACHINE_SUPPORTS_SAVE ) //It is unstable and can crash suddenly at any level, the problem is generated by the file .p1.
GAME( 2020, mslug3h68,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "hack",    "Metal Slug 3 (The Last Warhead, 2020-09-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h69,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "hack",    "Metal Slug 3 (Crazy Fire Edition, 2020-09-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h70,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "I love Nimes",     "Metal Slug 3 (Burst Enhanced Edition, 2020-09-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3h71,      mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "hack",    "Metal Slug 3 (Burst Enhanced Edition, 2020-09-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3ern01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-07-20)[Edition 1](Multi-Function Version)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Ghost Wu Zuoma Version)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Summon Mount Edition)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Store Version)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu/PlayerX China",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Green Blue Version)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern06,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](SE Special Edition)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern07,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Burst Enhanced Edition)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern08,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Zombie Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern09,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Mummy Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern10,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Crazy Fire Version V1.1)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern11,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Super D version)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3ern12,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",  "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1](Hybrid Bullets Version)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3esra01,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Multi-Function Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra02,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Ghost Wu Zuoma Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra03,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Summon Mount Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra04,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Store Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra05,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/PlayerX China",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Green Blue Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra06,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](SE Special Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra07,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Burst Enhanced Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra08,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Zombie Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra09,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Mummy Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra10,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Crazy Fire Version V1.1)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra11,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/HappyAsr",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Super D version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esra12,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1](Hybrid Bullets Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3esrb01,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Multi-Function Version)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb02,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Ghost Wu Zuoma Version)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb03,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Summon Mount Edition)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb04,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Store Version)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb05,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/PlayerX China",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Green Blue Version)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb06,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](SE Special Edition)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb07,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Burst Enhanced Edition)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb08,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Zombie Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb09,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Mummy Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb10,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Crazy Fire Version V1.1)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb11,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/HappyAsr",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Super D version)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrb12,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Future, 2020-09-29)[Edition 1](Hybrid Bullets Version)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3esrc01,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Multi-Function Version)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc02,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Ghost Wu Zuoma Version)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc03,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Summon Mount Edition)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc04,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Store Version)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc05,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/PlayerX China",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Green Blue Version)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc06,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](SE Special Edition)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc07,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Burst Enhanced Edition)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc08,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Zombie Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc09,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Mummy Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc10,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Crazy Fire Version V1.1)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc11,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/HappyAsr",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Super D version)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrc12,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1](Hybrid Bullets Version)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3esrd01,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Multi-Function Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd02,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,    ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Ghost Wu Zuoma Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd03,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Summon Mount Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd04,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Store Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd05,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/PlayerX China",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Green Blue Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd06,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](SE Special Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd07,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Burst Enhanced Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd08,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Zombie Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd09,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/Robert",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Mummy Players Mode Edition)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd10,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Crazy Fire Version V1.1)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd11,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/HappyAsr",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Super D version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3esrd12,   mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",  "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1](Hybrid Bullets Version)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3la01,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",   "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 1]", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3la02,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 1]", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3la03,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (The Future, 2020-09-29)[Edition 1]", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3la04,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 1]", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3la05,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 1]", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3lb01,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",   "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2]", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3lb02,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2]", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3lb03,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (The Future, 2020-09-29)[Edition 2]", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3lb04,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2]", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3lb05,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 2]", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3lc01,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90/XiaShuiDaoMeiRenYu",   "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 3]", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3lc02,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 3]", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-05
GAME( 2020, mslug3lc03,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 3]", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3lc04,     mslug3,   neogeo_noslot, neogeo, neogeo_state, init_cmc42sfix, ROT0, "Gaston90",   "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)[Edition 3]", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #3 2019-01-02
GAME( 2020, mslug3rma01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Flame Shot Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Flame Shot Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Laser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma06,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Laser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma07,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma08,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma09,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Shotgun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma10,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Big Shotgun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma11,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Cannon Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma12,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Cannon Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma13,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Enemy Chaser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma14,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Enemy Chaser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma15,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Satellite Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma16,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Satellite Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma17,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Super Grenade Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma18,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Super Grenade Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma19,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Thunder Cloud Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rma20,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Version Thunder Cloud Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rmb01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb06,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb07,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb08,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb09,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb10,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb11,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb12,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb13,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb14,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb15,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb16,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb17,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb18,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb19,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmb20,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmc01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc06,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc07,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc08,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc09,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc10,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc11,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc12,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc13,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc14,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc15,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc16,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc17,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc18,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc19,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmc20,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmd01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd06,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd07,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd08,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd09,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd10,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd11,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd12,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd13,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd14,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd15,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd16,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd17,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd18,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd19,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmd20,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rme01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Flame Shot Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme06,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Laser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme07,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme08,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Rocket Launcher Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme09,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme10,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Big Shotgun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme11,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme12,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Cannon Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme13,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme14,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Enemy Chaser Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme15,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme16,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Satellite Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme17,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme18,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Super Grenade Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme19,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rme20,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Version Thunder Cloud Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rmf01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemies Resetting Version, 2019-09-29)[Edition 2])(Revised Hybrid Bullets Version Extreme Remix, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemies Resetting Version 2019-07-20
GAME( 2020, mslug3rmf02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Last Warhead, 2020-09-29)[Edition 2])(Revised Hybrid Bullets Version Extreme Remix, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Last Warhead 2020-09-05
GAME( 2020, mslug3rmf03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (The Future, 2020-09-29)[Edition 2])(Revised Hybrid Bullets Version Extreme Remix, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //The Future 2020-09-29
GAME( 2020, mslug3rmf04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #1, 2020-09-29)[Edition 2])(Revised Hybrid Bullets Version Extreme Remix, 2020-09-29)", MACHINE_SUPPORTS_SAVE ) //Enemy Soldier Reset #1 2020-09-04
GAME( 2020, mslug3rmf05,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Revised Hybrid Bullets Version Extreme Remix, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rmg01,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)(Revised Version Big Heavy Machine Gun Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rmg02,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)(Revised Version Big Heavy Machine Gun Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rmg03,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)(Revised Version Satellite Extreme Remix 1.0, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, mslug3rmg04,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3h,   ROT0, "Team Remix(Gaston90,Shyma.X,Ydmis,DDJ,I love Nimes)",    "Metal Slug 3 (Enemy Soldier Reset Version #3, 2020-09-29)(Revised Version Satellite Extreme Remix 1.1, 2020-09-29)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, mslug3unity,    mslug3,   neogeo_noslot, neogeo, neogeo_state, init_mslug3,    ROT0, "hack", "Metal Slug 3 Unity", MACHINE_SUPPORTS_SAVE )

