// For licensing and usage information, read docs/release/winui_license.txt
// MASTER
//****************************************************************************

#ifndef WINUI_UIOPTS_H
#define WINUI_UIOPTS_H

#define MUIOPTION_OVERRIDE_REDX                  "override_redx"
#define MUIOPTION_LIST_MODE                      "list_mode"
#define MUIOPTION_VIEW_INDENT                    "indent_mode"
#define MUIOPTION_CHECK_GAME                     "check_game"
#define MUIOPTION_JOYSTICK_IN_INTERFACE          "joystick_in_interface"
#define MUIOPTION_KEYBOARD_IN_INTERFACE          "keyboard_in_interface"
#define MUIOPTION_CYCLE_SCREENSHOT               "cycle_screenshot"
#define MUIOPTION_STRETCH_SCREENSHOT_LARGER      "stretch_screenshot_larger"
#define MUIOPTION_SCREENSHOT_BORDER_SIZE         "screenshot_bordersize"
#define MUIOPTION_SCREENSHOT_BORDER_COLOR        "screenshot_bordercolor"
#define MUIOPTION_INHERIT_FILTER                 "inherit_filter"
#define MUIOPTION_OFFSET_CLONES                  "offset_clones"
#define MUIOPTION_DEFAULT_FOLDER_ID              "default_folder_id"
#define MUIOPTION_HIDE_FOLDERS                   "hide_folders"
#define MUIOPTION_SHOW_STATUS_BAR                "show_status_bar"
#define MUIOPTION_SHOW_TABS                      "show_tabs"
#define MUIOPTION_SHOW_TOOLBAR                   "show_tool_bar"
#define MUIOPTION_CURRENT_TAB                    "current_tab"
#define MUIOPTION_WINDOW_X                       "window_x"
#define MUIOPTION_WINDOW_Y                       "window_y"
#define MUIOPTION_WINDOW_WIDTH                   "window_width"
#define MUIOPTION_WINDOW_HEIGHT                  "window_height"
#define MUIOPTION_WINDOW_STATE                   "window_state"
#define MUIOPTION_WINDOW_PANES                   "window_panes"
#define MUIOPTION_CUSTOM_COLOR                   "custom_color"
#define MUIOPTION_LIST_FONT                      "list_font"
#define MUIOPTION_TEXT_COLOR                     "text_color"
#define MUIOPTION_CLONE_COLOR                    "clone_color"
#define MUIOPTION_HIDE_TABS                      "hide_tabs"
#define MUIOPTION_HISTORY_TAB                    "history_tab"
#define MUIOPTION_COLUMN_WIDTHS                  "column_widths"
#define MUIOPTION_COLUMN_ORDER                   "column_order"
#define MUIOPTION_COLUMN_SHOWN                   "column_shown"
#define MUIOPTION_SPLITTERS                      "splitters"
#define MUIOPTION_SORT_COLUMN                    "sort_column"
#define MUIOPTION_SORT_REVERSED                  "sort_reversed"
#define MUIOPTION_BACKGROUND_DIRECTORY           "background_directory"
#define MUIOPTION_DATS_DIRECTORY                 "dats_directory"
#define MUIOPTION_VIDEO_DIRECTORY                "video_directory"
#define MUIOPTION_MANUALS_DIRECTORY              "manuals_directory"
#define MUIOPTION_UI_KEY_UP                      "ui_key_up"
#define MUIOPTION_UI_KEY_DOWN                    "ui_key_down"
#define MUIOPTION_UI_KEY_LEFT                    "ui_key_left"
#define MUIOPTION_UI_KEY_RIGHT                   "ui_key_right"
#define MUIOPTION_UI_KEY_START                   "ui_key_start"
#define MUIOPTION_UI_KEY_PGUP                    "ui_key_pgup"
#define MUIOPTION_UI_KEY_PGDWN                   "ui_key_pgdwn"
#define MUIOPTION_UI_KEY_HOME                    "ui_key_home"
#define MUIOPTION_UI_KEY_END                     "ui_key_end"
#define MUIOPTION_UI_KEY_SS_CHANGE               "ui_key_ss_change"
#define MUIOPTION_UI_KEY_HISTORY_UP              "ui_key_history_up"
#define MUIOPTION_UI_KEY_HISTORY_DOWN            "ui_key_history_down"
#define MUIOPTION_UI_KEY_CONTEXT_FILTERS         "ui_key_context_filters"
#define MUIOPTION_UI_KEY_SELECT_RANDOM           "ui_key_select_random"
#define MUIOPTION_UI_KEY_GAME_AUDIT              "ui_key_game_audit"
#define MUIOPTION_UI_KEY_GAME_PROPERTIES         "ui_key_game_properties"
#define MUIOPTION_UI_KEY_HELP_CONTENTS           "ui_key_help_contents"
#define MUIOPTION_UI_KEY_UPDATE_GAMELIST         "ui_key_update_gamelist"
#define MUIOPTION_UI_KEY_VIEW_FOLDERS            "ui_key_view_folders"
#define MUIOPTION_UI_KEY_VIEW_FULLSCREEN         "ui_key_view_fullscreen"
#define MUIOPTION_UI_KEY_VIEW_PAGETAB            "ui_key_view_pagetab"
#define MUIOPTION_UI_KEY_VIEW_PICTURE_AREA       "ui_key_view_picture_area"
#define MUIOPTION_UI_KEY_VIEW_STATUS             "ui_key_view_status"
#define MUIOPTION_UI_KEY_VIEW_TOOLBARS           "ui_key_view_toolbars"
#define MUIOPTION_UI_KEY_VIEW_TAB_CABINET        "ui_key_view_tab_cabinet"
#define MUIOPTION_UI_KEY_VIEW_TAB_CPANEL         "ui_key_view_tab_cpanel"
#define MUIOPTION_UI_KEY_VIEW_TAB_FLYER          "ui_key_view_tab_flyer"
#define MUIOPTION_UI_KEY_VIEW_TAB_HISTORY        "ui_key_view_tab_history"
#define MUIOPTION_UI_KEY_VIEW_TAB_MARQUEE        "ui_key_view_tab_marquee"
#define MUIOPTION_UI_KEY_VIEW_TAB_SCREENSHOT     "ui_key_view_tab_screenshot"
#define MUIOPTION_UI_KEY_VIEW_TAB_TITLE          "ui_key_view_tab_title"
#define MUIOPTION_UI_KEY_VIEW_TAB_PCB            "ui_key_view_tab_pcb"
#define MUIOPTION_UI_KEY_QUIT                    "ui_key_quit"
#define MUIOPTION_UI_JOY_UP                      "ui_joy_up"
#define MUIOPTION_UI_JOY_DOWN                    "ui_joy_down"
#define MUIOPTION_UI_JOY_LEFT                    "ui_joy_left"
#define MUIOPTION_UI_JOY_RIGHT                   "ui_joy_right"
#define MUIOPTION_UI_JOY_START                   "ui_joy_start"
#define MUIOPTION_UI_JOY_PGUP                    "ui_joy_pgup"
#define MUIOPTION_UI_JOY_PGDWN                   "ui_joy_pgdwn"
#define MUIOPTION_UI_JOY_HOME                    "ui_joy_home"
#define MUIOPTION_UI_JOY_END                     "ui_joy_end"
#define MUIOPTION_UI_JOY_SS_CHANGE               "ui_joy_ss_change"
#define MUIOPTION_UI_JOY_HISTORY_UP              "ui_joy_history_up"
#define MUIOPTION_UI_JOY_HISTORY_DOWN            "ui_joy_history_down"
#define MUIOPTION_UI_JOY_EXEC                    "ui_joy_exec"
#define MUIOPTION_EXEC_COMMAND                   "exec_command"
#define MUIOPTION_EXEC_WAIT                      "exec_wait"
#define MUIOPTION_HIDE_MOUSE                     "hide_mouse"
#define MUIOPTION_FULL_SCREEN                    "full_screen"
#define MUIOPTION_UI_KEY_VIEW_SOFTWARE_AREA      "ui_key_view_software_area"

#ifdef MESS
#define MUIOPTION_DEFAULT_GAME                   "default_system"
#define MUIDEFAULT_SELECTION                     "0"
#define MUIDEFAULT_SPLITTERS                     "133,1125,1706"
#else
#define MUIOPTION_DEFAULT_GAME                   "default_machine"
#define MUIDEFAULT_SELECTION                     "0"
#define MUIDEFAULT_SPLITTERS                     "164,1700"
#endif

#define MESSUI_SL_COLUMN_SHOWN        "sl_column_shown"
#define MESSUI_SL_COLUMN_WIDTHS       "sl_column_widths"
#define MESSUI_SL_COLUMN_ORDER        "sl_column_order"
#define MESSUI_SL_SORT_REVERSED       "sl_sort_reversed"
#define MESSUI_SL_SORT_COLUMN         "sl_sort_column"
#define MESSUI_SW_COLUMN_SHOWN        "sw_column_shown"
#define MESSUI_SW_COLUMN_WIDTHS       "sw_column_widths"
#define MESSUI_SW_COLUMN_ORDER        "sw_column_order"
#define MESSUI_SW_SORT_REVERSED       "sw_sort_reversed"
#define MESSUI_SW_SORT_COLUMN         "sw_sort_column"
#define MESSUI_SOFTWARE_TAB           "current_software_tab"

typedef struct
{
	std::string                      name;      // name of the option
	std::string                      value;     // initial value if ini file not found
	const core_options::option_type  unused1;   // option type (unused)
	char*                            unused2;   // help text (unused)
}
WINUIOPTS;
// UI options in MAMEui.ini
const WINUIOPTS option_entries[] =
{
	{ MUIOPTION_OVERRIDE_REDX,                "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_DEFAULT_GAME,                 MUIDEFAULT_SELECTION, core_options::option_type::INTEGER,       NULL },
	{ MUIOPTION_DEFAULT_FOLDER_ID,            "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_FULL_SCREEN,                  "0",        core_options::option_type::BOOLEAN,                 NULL },
	{ MUIOPTION_CURRENT_TAB,                  "0",        core_options::option_type::STRING,                  NULL },
	{ MESSUI_SOFTWARE_TAB,                    "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_SHOW_TOOLBAR,                 "1",        core_options::option_type::BOOLEAN,                 NULL },
	{ MUIOPTION_SHOW_STATUS_BAR,              "1",        core_options::option_type::BOOLEAN,                 NULL },
	{ MUIOPTION_HIDE_FOLDERS,                 "",         core_options::option_type::STRING,                  NULL },
	{ MUIOPTION_SHOW_TABS,                    "1",        core_options::option_type::BOOLEAN,                 NULL },
	{ MUIOPTION_HIDE_TABS,                    "artpreview,boss,cpanel,cover,end,flyer,gameover,howto,logo,marquee,pcb,scores,select,title,versus",  core_options::option_type::STRING, NULL },
	{ MUIOPTION_HISTORY_TAB,                  "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_SORT_COLUMN,                  "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_SORT_REVERSED,                "0",        core_options::option_type::BOOLEAN,                 NULL },
	{ MUIOPTION_WINDOW_X,                     "0",        core_options::option_type::INTEGER,                 NULL },  // main window position, left
	{ MUIOPTION_WINDOW_Y,                     "0",        core_options::option_type::INTEGER,                 NULL },  // main window position, top
	{ MUIOPTION_WINDOW_WIDTH,                 "2000",     core_options::option_type::INTEGER,                 NULL },  // main window width
	{ MUIOPTION_WINDOW_HEIGHT,                "1000",     core_options::option_type::INTEGER,                 NULL },  // main window height
	{ MUIOPTION_WINDOW_STATE,                 "1",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_WINDOW_PANES,                 "15",       core_options::option_type::INTEGER,                 NULL },  // which windows are visible: bit 0 = tree, bit 1 = list, bit 2 = sw, bit 3 = images
	{ MUIOPTION_TEXT_COLOR,                   "-1",       core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_CLONE_COLOR,                  "-1",       core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_CUSTOM_COLOR,                 "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0", core_options::option_type::STRING, NULL }, // colour codes of the 16 custom colours (set in clone font dialog)
	/* ListMode needs to be before ColumnWidths settings */
	{ MUIOPTION_LIST_MODE,                    "1",        core_options::option_type::BOOLEAN,                 NULL },
	{ MUIOPTION_SPLITTERS,                    MUIDEFAULT_SPLITTERS, core_options::option_type::STRING,       NULL },
	{ MUIOPTION_LIST_FONT,                    "-11,0,0,0,400,0,0,0,0,1,2,1,34,MS Sans Serif", core_options::option_type::STRING, NULL },
	{ MUIOPTION_COLUMN_WIDTHS,                "185,78,84,84,64,88,74,108,60,144,84,40,40", core_options::option_type::STRING, NULL },
	{ MUIOPTION_COLUMN_ORDER,                 "0,1,2,3,4,5,6,7,8,9,10,11,12", core_options::option_type::STRING, NULL },
	{ MUIOPTION_COLUMN_SHOWN,                 "1,1,1,1,1,1,1,1,1,1,1,1,0", core_options::option_type::STRING,  NULL },
	{ MESSUI_SL_COLUMN_WIDTHS,                "100,75,223,46,120,120", core_options::option_type::STRING, NULL },
	{ MESSUI_SL_COLUMN_ORDER,                 "0,1,2,3,4,5", core_options::option_type::STRING, NULL }, // order of columns
	{ MESSUI_SL_COLUMN_SHOWN,                 "1,1,1,1,1,1", core_options::option_type::STRING, NULL }, // 0=hide,1=show
	{ MESSUI_SL_SORT_COLUMN,                  "0", core_options::option_type::INTEGER, NULL },
	{ MESSUI_SL_SORT_REVERSED,                "0", core_options::option_type::BOOLEAN, NULL },
	{ MESSUI_SW_COLUMN_WIDTHS,                "400", core_options::option_type::STRING, NULL },
	{ MESSUI_SW_COLUMN_ORDER,                 "0", core_options::option_type::STRING, NULL }, // 1= dummy column
	{ MESSUI_SW_COLUMN_SHOWN,                 "1", core_options::option_type::STRING, NULL }, // 0=don't show it
	{ MESSUI_SW_SORT_COLUMN,                  "0", core_options::option_type::INTEGER, NULL },
	{ MESSUI_SW_SORT_REVERSED,                "0", core_options::option_type::BOOLEAN, NULL },
	{ MUIOPTION_CHECK_GAME,                   "0",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_JOYSTICK_IN_INTERFACE,        "1",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_KEYBOARD_IN_INTERFACE,        "0",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_HIDE_MOUSE,                   "0",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_INHERIT_FILTER,               "0",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_OFFSET_CLONES,                "0",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_STRETCH_SCREENSHOT_LARGER,    "0",        core_options::option_type::BOOLEAN,    NULL },
	{ MUIOPTION_CYCLE_SCREENSHOT,             "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_SCREENSHOT_BORDER_SIZE,       "11",       core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_SCREENSHOT_BORDER_COLOR,      "-1",       core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_EXEC_COMMAND,                 "",         core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_EXEC_WAIT,                    "0",        core_options::option_type::INTEGER,                 NULL },
	{ MUIOPTION_BACKGROUND_DIRECTORY,         "bkground\\bkground.png", core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_DATS_DIRECTORY,               "dats",     core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_VIDEO_DIRECTORY,              "video",     core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_MANUALS_DIRECTORY,            "manuals",     core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_KEY_UP,                    "KEYCODE_UP",                        core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_DOWN,                  "KEYCODE_DOWN",                     core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_LEFT,                  "KEYCODE_LEFT",                     core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_RIGHT,                 "KEYCODE_RIGHT",                    core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_START,                 "KEYCODE_ENTER NOT KEYCODE_LALT",    core_options::option_type::STRING,            NULL },
	{ MUIOPTION_UI_KEY_PGUP,                  "KEYCODE_PGUP",                     core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_PGDWN,                 "KEYCODE_PGDN",                     core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_HOME,                  "KEYCODE_HOME",                     core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_END,                   "KEYCODE_END",                        core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_SS_CHANGE,             "KEYCODE_INSERT",                    core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_HISTORY_UP,            "KEYCODE_DEL",                        core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_HISTORY_DOWN,          "KEYCODE_LALT KEYCODE_0",            core_options::option_type::STRING,          NULL },
	{ MUIOPTION_UI_KEY_CONTEXT_FILTERS,       "KEYCODE_LCONTROL KEYCODE_F", core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_SELECT_RANDOM,         "KEYCODE_LCONTROL KEYCODE_R", core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_GAME_AUDIT,            "KEYCODE_LALT KEYCODE_A",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_GAME_PROPERTIES,       "KEYCODE_LALT KEYCODE_ENTER", core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_HELP_CONTENTS,         "KEYCODE_F1",                 core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_UPDATE_GAMELIST,       "KEYCODE_F5",                 core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_FOLDERS,          "KEYCODE_LALT KEYCODE_D",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_FULLSCREEN,       "KEYCODE_F11",                core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_PAGETAB,          "KEYCODE_LALT KEYCODE_B",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_PICTURE_AREA,     "KEYCODE_LALT KEYCODE_P",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_SOFTWARE_AREA,    "KEYCODE_LALT KEYCODE_W",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_STATUS,           "KEYCODE_LALT KEYCODE_S",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TOOLBARS,         "KEYCODE_LALT KEYCODE_T",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_CABINET,      "KEYCODE_LALT KEYCODE_3",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_CPANEL,       "KEYCODE_LALT KEYCODE_6",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_FLYER,        "KEYCODE_LALT KEYCODE_2",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_HISTORY,      "KEYCODE_LALT KEYCODE_8",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_MARQUEE,      "KEYCODE_LALT KEYCODE_4",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_SCREENSHOT,   "KEYCODE_LALT KEYCODE_1",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_TITLE,        "KEYCODE_LALT KEYCODE_5",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_VIEW_TAB_PCB,          "KEYCODE_LALT KEYCODE_7",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_KEY_QUIT,                  "KEYCODE_LALT KEYCODE_Q",     core_options::option_type::STRING, NULL },
	{ MUIOPTION_UI_JOY_UP,                    "1,1,1,1",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_DOWN,                  "1,1,1,2",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_LEFT,                  "1,1,2,1",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_RIGHT,                 "1,1,2,2",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_START,                 "1,0,1,0",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_PGUP,                  "2,1,2,1",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_PGDWN,                 "2,1,2,2",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_HOME,                  "0,0,0,0",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_END,                   "0,0,0,0",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_SS_CHANGE,             "2,0,3,0",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_HISTORY_UP,            "2,0,4,0",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_HISTORY_DOWN,          "2,0,1,0",  core_options::option_type::STRING,                 NULL },
	{ MUIOPTION_UI_JOY_EXEC,                  "0,0,0,0",  core_options::option_type::STRING,                 NULL },
	{ "$end" }
};

class winui_ui_options
{
	std::map<std::string, std::string> m_list;
	const char *m_filename;

	void create_index(std::ifstream &fp)
	{
		if (!fp.good())
			return;
		bool is_ready = false;
		std::string file_line;
		std::getline(fp, file_line);
		while (fp.good())
		{
			if (is_ready)
			{
				char s[file_line.length()+1];
				strcpy(s, file_line.c_str());

				const char* name = strtok(s, "\t");  // get adjustment name
				char* data = strtok(NULL, "\t");    // get next part (there's no next tab, so just return whatever is left)
				if (name)
					m_list[name] = data ? data : "";
			}
			else
			{
				if (file_line == "$start")
					is_ready = true;
			}

			std::getline(fp, file_line);
		}

		fp.close();
		return;
	}

	bool ends_with_filter(const std::string &str)
	{
		string ending = "_filters";
		u8 endl = ending.length();
		u8 strl = str.length();
		if (strl < endl)
			return false;
		return str.compare(strl - endl, endl, ending) == 0;
	}

public:
	// construction/destruction
	winui_ui_options()
	{
		// set up default values
		for (int i = 0; option_entries[i].name != "$end"; i++)
			m_list[option_entries[i].name] = option_entries[i].value;
		//printf("*** START DUMP OF DEFAULT ***\n");
		//for (auto const &it : m_list)
		//  printf("%s = %s\n", it.first.c_str(), it.second.c_str());
		//printf("*** END DUMP OF DEFAULT ***\n");
	}

	void load_file(const char *filename)
	{
		if (!m_filename)
			m_filename = filename;
		std::ifstream infile (filename);
		create_index(infile);
	}

	void save_file(const char *filename)
	{
		if (!filename)
			return;
		std::string inistring = std::string("\nYOU CAN SAFELY DELETE THIS FILE TO RESET THE EMULATOR BACK TO DEFAULTS.\n\n$start\n");
		for (auto const &it : m_list)
			inistring.append(it.first).append("\t").append(it.second).append("\n");

		std::ofstream outfile (filename, std::ios::out | std::ios::trunc);
		size_t size = inistring.size();
		char t1[size+1];
		strcpy(t1, inistring.c_str());
		outfile.write(t1, size);
		outfile.close();
		return;
	}

	void reset_and_save(const char *filename)
	{
		// set up default values
		for (int i = 0; option_entries[i].name != "$end"; i++)
			m_list[option_entries[i].name] = option_entries[i].value;

		save_file(filename);
	}

	void setter(const char* name, std::string value)
	{
		m_list[name] = value;
		save_file(m_filename);
	}

	// cannot be "setter" otherwise most strings use it, causing "1" to be saved.
	//void bool_setter(const char* name, bool value)
	//{
	//  m_list[name] = value ? "1" : "0";
	//  save_file(m_filename);
	//}

	void setter(const char* name, int value)
	{
		u8 s_write = 3;
		// filters: only want an entry if a filter is applied
		if (ends_with_filter(name))
		{
			if (value == 0)
			{
				if (m_list.find(name) == m_list.end())
					s_write = 0; // there is no entry so do nothing
				else
					s_write = 2; // delete the existing entry
			}
		}
		if (s_write)
		{
			if (s_write == 2)
				m_list.erase(m_list.find(name)); // delete
			else
				m_list[name] = std::to_string(value); // add or update

			save_file(m_filename);
		}
	}

	std::string getter(const char* name)
	{
		if (m_list.count(name))
			return m_list.find(name)->second;
		else
			return "";
	}

	int int_value(const char* name)
	{
		string t = getter(name);
		if (t.empty())
			return 0;
		else
			return std::atoll(t.c_str());
	}

	bool bool_value(const char* name)
	{
		return int_value(name) ? 1 : 0;
	}
};

#endif //  WINUI_UIOPTS_H

