// license:GPL_2.0
// copyright-holders:Robbbert

#include "includes/neogeo.h"


/************************
 The King of Fighters '99
****************************/
ROM_START( kof99s001 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s001.p1",  0x000000, 0x100000, CRC(2d553276) SHA1(84a858f702374736e1349b879a5a58e5580ffff6) )
	ROM_LOAD16_WORD_SWAP( "251ob.p2", 0x100000, 0x400000, CRC(f88a4970) SHA1(6cce092f0d60aff7c0fcad796e9604cdf440219f) )

	NEO_SFIX_128K( "251ndis.s1", CRC(16edaa55) SHA1(d8601a14c703e56c0635e2f7540492b164447d6b) )

	NEO_BIOS_AUDIO_128K( "251ob.m1", CRC(151c7a8d) SHA1(ccf557d1818edb579aa72e05f494305e5449d5ee) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ob.v1",  0x000000, 0x400000, CRC(33d2e8b4) SHA1(f1ff9facc59eadc257edc06ba6bb3dddf27cfae2) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ob.c7", 0x3000000, 0x800000, CRC(f3b25375) SHA1(80d6b06adce5190bb71f2f0233db60008a33c51e) )
	ROM_LOAD16_BYTE( "251ob.c8", 0x3000001, 0x800000, CRC(d2d0041a) SHA1(02283e2ac22e2f0521c3b2d126aff624ac820b63) )
ROM_END

ROM_START( kof99s002 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s002.p1",  0x000000, 0x100000, CRC(014acf56) SHA1(a461860e0587505e2ff15201831f7b8597a8268e) )
	ROM_LOAD16_WORD_SWAP( "251s002.p2", 0x100000, 0x400000, CRC(5f433cab) SHA1(2066babb1f03a8b5369e9c898fcc301d23629a35) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s002.c7", 0x3000000, 0x800000, CRC(ae9c1b04) SHA1(28aace5ca28345647cb58231dc6d9fcc6ed07eba) )
	ROM_LOAD16_BYTE( "251s002.c8", 0x3000001, 0x800000, CRC(92f1b4f8) SHA1(57c0e7703bbcbdef62e2cb0bbba8bb7a08f846d6) )
ROM_END

ROM_START( kof99s003 ) //kof99evo, kof99evoru
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s003.p1",  0x000000, 0x100000, CRC(3dff0380) SHA1(6d9b9ee2e40f8c20e6e9a0069f1bc1d18bc38579) )
	ROM_LOAD16_WORD_SWAP( "251s003.p2", 0x100000, 0x400000, CRC(da68e5be) SHA1(d955f6186df89bdbb8eb16b7ea86815874ee5e40) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1", 0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s004 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s004.p1",  0x000000, 0x100000, CRC(43263e84) SHA1(865ea330380f29aea309d1fff87216735958dd5c) )
	ROM_LOAD16_WORD_SWAP( "251s004.p2", 0x100000, 0x400000, CRC(ba3e05a7) SHA1(61c086de8b8d783c5ca3e8a970c9214b19f22d46) )

	NEO_SFIX_128K( "251hc08.s1", CRC(141c3221) SHA1(f54ad0ce87cd3fa273be770647d2dcce05d96876) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s005 ) // kof99ab - Hack by Marcochen/PPX Hack Team - (Rolls moves sideways version)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ab.p1",   0x000000, 0x100000, CRC(8ABC720E) SHA1(3D8FDC2F3AE1F4F1DC121587EF37240C15548280) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s006 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s006.p1",  0x000000, 0x100000, CRC(d02b17c6) SHA1(2041d5b5835878e3ee80903fa3077bea479b6d43) )
	ROM_LOAD16_WORD_SWAP( "251ndis.p2", 0x100000, 0x400000, CRC(c012ff9f) SHA1(ef53386e34464eaaed1fcba3d4d1dcfb269f995c) )

	NEO_SFIX_128K( "251s006.s1", CRC(2c0a314a) SHA1(2ca439e6c2798864d9bade7753d512b64ed34f50) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s007 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s007.p1",  0x000000, 0x100000, CRC(fa5cf0a7) SHA1(86bdde3a8c08e43b69cc28eee7f0b34ecfd78b76) )
	ROM_LOAD16_WORD_SWAP( "251ndis.p2", 0x100000, 0x400000, CRC(c012ff9f) SHA1(ef53386e34464eaaed1fcba3d4d1dcfb269f995c) )

	NEO_SFIX_128K( "251s006.s1", CRC(2c0a314a) SHA1(2ca439e6c2798864d9bade7753d512b64ed34f50) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s008 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s008.p1",  0x000000, 0x100000, CRC(04f962cc) SHA1(c44847199baae551111efa32a0b3d886f864305b) )
	ROM_LOAD16_WORD_SWAP( "251s008.p2", 0x100000, 0x400000, CRC(86c53edc) SHA1(13b4c435459553312bcf8cb30270ca10c6968265) )

	NEO_SFIX_128K( "251bs.s1", CRC(697c1f85) SHA1(117d12908b060db62716a8ac8a155c8303287746) )

	NEO_BIOS_AUDIO_128K( "251s008.m1", CRC(1c78d81d) SHA1(f9252a27000b5235153df87ab8f02799b894d821) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251s008.v1", 0x000000, 0x400000, CRC(5cd53b2d) SHA1(915c01401e1965fe32a0eb893cae057058754e28) )
	ROM_LOAD( "251s008.v2", 0x400000, 0x400000, CRC(5ec6f579) SHA1(e4ea7cef986b24e576df1e8aea56276be05bc8b2) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251ae.c1",    0x0000000, 0x800000, CRC(d0048356) SHA1(3a5a381f531751c8469d74b59e9e668d21cbc06b) )
	ROM_LOAD16_BYTE( "251ae.c2",    0x0000001, 0x800000, CRC(1d405bb0) SHA1(76c4b1d6e5ff0d5814b19203fbdd1f02d663de3e) )
	ROM_LOAD16_BYTE( "251d.c3",     0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",     0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",     0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",     0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s008.c7",  0x3000000, 0x800000, CRC(1f67c92e) SHA1(a0299f26a2a6a026525040ec6546e4b054fde64a) )
	ROM_LOAD16_BYTE( "251s008.c8",  0x3000001, 0x800000, CRC(9f8d41ed) SHA1(f8d30e89f7f2295329abb431a143b764655cc948) )
	ROM_LOAD16_BYTE( "251s008.c9",  0x4000000, 0x800000, CRC(c44d430d) SHA1(54082189818ddb51356f60b4212f1de5177b3239) )
	ROM_LOAD16_BYTE( "251s008.c10", 0x4000001, 0x800000, CRC(0e5ae418) SHA1(9f1811db741f1b063fb73f5e64ef4e56acd0b25c) )
	ROM_LOAD16_BYTE( "251aex.c11",  0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12",  0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s009 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s19.p1",  0x000000, 0x100000, CRC(e7692e5c) SHA1(7cbff47c4dbcd8e979170c8a56e4d57bd0602e67) )
	ROM_LOAD16_WORD_SWAP( "251hc19.p2", 0x100000, 0x400000, CRC(86c0e2df) SHA1(68210da594aee37981a474ab801201d2533a0225) )

	NEO_SFIX_128K( "251bs.s1", CRC(697c1f85) SHA1(117d12908b060db62716a8ac8a155c8303287746) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1", 0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251ae.c1",   0x0000000, 0x800000, CRC(d0048356) SHA1(3a5a381f531751c8469d74b59e9e668d21cbc06b) )
	ROM_LOAD16_BYTE( "251ae.c2",   0x0000001, 0x800000, CRC(1d405bb0) SHA1(76c4b1d6e5ff0d5814b19203fbdd1f02d663de3e) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251ae.c9",   0x4000000, 0x800000, CRC(7d90d06d) SHA1(a72e91d689ef23b4bab43266c4360f663fc7836f) )
	ROM_LOAD16_BYTE( "251ae.c10",  0x4000001, 0x800000, CRC(3e2bf178) SHA1(e606e69595c0e9601c1dea142f0fcf77c2964347) )
	ROM_LOAD16_BYTE( "251ae.c11",  0x5000000, 0x800000, CRC(90016920) SHA1(6686e98a25d906131f73ed83c712096a6946c62e) )
	ROM_LOAD16_BYTE( "251ae.c12",  0x5000001, 0x800000, CRC(49cfed23) SHA1(63fa8682b86802967b36489c7483c59039f35aa5) )
ROM_END

ROM_START( kof99s010 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s010.p1",  0x000000, 0x454F49, CRC(84583b25) SHA1(98da9e5209bed220c98d1b77ed4fbc2585aea0df) )
	ROM_LOAD16_WORD_SWAP( "251s010.p2", 0x100000, 0x400000, CRC(9cda859f) SHA1(f51708be33dca1046bcae900c8b4bb03135b662a) )
	ROM_IGNORE(0x54f4a)
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s011 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s011.p1",  0x000000, 0x100000, CRC(ae257f76) SHA1(f9d8f7de03d934a50c88b598a7f05b83d3b9c30d) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2",  0x100000, 0x400000, CRC(C923EE2B) SHA1(98B4F40812D5479F7D6E683E5EF4002F4C86785C) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s012 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s013.p1", 0x000000, 0x100000, CRC(3dad12db) SHA1(0ced53f7719254fd2369f724b659c1e5274d146f) )
	ROM_LOAD16_WORD_SWAP( "251s013.p2", 0x100000, 0x400000, CRC(f8566133) SHA1(8414b35d5c9e0eb22197f2b403d3626eccb70923) )
	ROM_LOAD16_WORD_SWAP( "251s013.p3", 0x500000, 0x400000, CRC(bc85cf02) SHA1(a1a8228299a76bf840822d50528a67d4d3c5ac5e) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s014 ) // kof99bxfix : all confirmed
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ob.p1", 0x000000, 0x100000, CRC(b6147b23) SHA1(921dad6a2f1011ad67a82a6f9874b30658f233b0) )
	ROM_LOAD16_WORD_SWAP( "251s014.p2", 0x100000, 0x400000, CRC(e22375ba) SHA1(464dcc32fb29d6a714e3dee517bea8083c76bbbf) )
	ROM_IGNORE(0x05500a)

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEOGEO_BIOS
	ROM_REGION( 0x20000, "audiobios", 0 )
	ROM_LOAD( "sm1.sm1", 0x00000, 0x20000, CRC(94416d67) SHA1(42f9d7ddd6c0931fd64226a60dc73602b2819dcf) )
	ROM_REGION( 0x30000, "audiocpu", 0 )
	ROM_LOAD( "251s014.m1", 0x00000, 0x20000, CRC(6ac5779b) SHA1(6aa2a93cb12aa865e851808cfc33775956d7d357) )
	ROM_IGNORE(0x434f47)
	ROM_RELOAD(     0x10000, 0x20000 )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251s014.v1", 0x000000, 0x454f50, CRC(80e95dbf) SHA1(818080b406881e765900bad8690582e15cee2574) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s014.c7", 0x3000000, 0x800000, CRC(da3d47da) SHA1(19aeda9d1280d54e6a6a49754e98ad1f6bae1470) )
	ROM_LOAD16_BYTE( "251s014.c8", 0x3000001, 0x800000, CRC(0990e9a4) SHA1(5d172b0903404aabc27b5ea9867409f7aad518a0) )
ROM_END

ROM_START( kof99s015 ) // c7,c8,px,s1 confirmed
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s015.p1", 0x000000, 0x100000, CRC(fdefcc3c) SHA1(fb33436c107e1b38ad182755d743ba50a4de795a) )
	ROM_LOAD16_WORD_SWAP( "251sr.p2", 0x100000, 0x400000, CRC(9f1d1660) SHA1(d23466a5aac70c69d10c6bec59f019419940d914) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251sr.s1", CRC(08055c7a) SHA1(682e0084e62b547482929babe828027fdd64cde0) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251sr.c7",  0x3000000, 0x800000, CRC(65de862c) SHA1(83c0446f19ca567cd7664956f617f4f7625422b7) )
	ROM_LOAD16_BYTE( "251sr.c8",  0x3000001, 0x800000, CRC(3ff457fe) SHA1(1838de77ceaf78cb75604f227ffdf59311c0bbe5) )
ROM_END

ROM_START( kof99s016 ) // all confirmed
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s016.p1", 0x000000, 0x100000, CRC(6e9315de) SHA1(cf499d14fa763890ffb4af141a4f4315afe2bd42) )
	ROM_LOAD16_WORD_SWAP( "251fc.p2", 0x100000, 0x400000, CRC(01e111b3) SHA1(4ae2fbd552246779146684d2191a7bc9a3554c59) )

	NEO_SFIX_128K( "251fc.s1", CRC(ca942904) SHA1(f84b79282bb2de61d24faacca1feda0187e42dcd) )

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251fc.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251fc.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251fc.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251fc.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251fc.c7", 0x3000000, 0x800000, CRC(1dfd5103) SHA1(edbe56d9434abdff58e7e9ceed7ea3d7975c40d2) )
	ROM_LOAD16_BYTE( "251fc.c8", 0x3000001, 0x800000, CRC(23fe3c43) SHA1(b601a14cd023b28f8e8eed8afd6a05d2c3df115a) )
ROM_END

ROM_START( kof99s017 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s017.p1", 0x000000, 0x100000, CRC(5aa33f2d) SHA1(081afc41baa8769f4c0935bb865965ba74237009) )
	ROM_LOAD16_WORD_SWAP( "251rev.p2", 0x100000, 0x400000, CRC(7a7dcf34) SHA1(df424b6b44f007721bb1cf3fee00f4bedb5a63e6) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s018 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s018.p1", 0x000000, 0x100000, CRC(6ed66fa5) SHA1(7389823fcff8f6fabfa419e57a52e8d04856b2b7) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2",  0x100000, 0x400000, CRC(C923EE2B) SHA1(98B4F40812D5479F7D6E683E5EF4002F4C86785C) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s019 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s019.p1", 0x000000, 0x100000, CRC(3c8e7e70) SHA1(f82060d02c1d823762cd28c607d99215814364c2) )
	ROM_LOAD16_WORD_SWAP( "251s003.p2", 0x100000, 0x400000, CRC(da68e5be) SHA1(d955f6186df89bdbb8eb16b7ea86815874ee5e40) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1", 0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s020 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s020.p1", 0x000000, 0x100000, CRC(6b187829) SHA1(48d11cc47c6d65e7d9444898c01a2a649d9d098d) )
	ROM_LOAD16_WORD_SWAP( "251s020.p2", 0x100000, 0x400000, CRC(3697eff6) SHA1(f8d382ae94306b040d62045210c05d899b290dfa) )
	ROM_LOAD16_WORD_SWAP( "251s020.p3", 0x500000, 0x400000, CRC(56c53cd7) SHA1(6f61b8e6e2fc61a8f5a9b94c974c5045f9fac775) )

	NEO_SFIX_128K( "251ae.s1", CRC(6243a70b) SHA1(452371f20e31c4d79022a128fc5335e951a6af1e) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251s020.c9",   0x4000000, 0x800000, CRC(9594e401) SHA1(488adbe6d8609b0093ff81458534b06cfe6e3869) )
	ROM_LOAD16_BYTE( "251s020.c10",  0x4000001, 0x800000, CRC(a778cdd6) SHA1(f829fb3f527c6aafd108a43ad3931aaac1dd5dd2) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s022 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s022.p1", 0x000000, 0x100000, CRC(a31973d7) SHA1(2e0cc954aba90952cd1f452a35c5d5a2506cd373) )
	ROM_LOAD16_WORD_SWAP( "251s022.p2", 0x100000, 0x400000, CRC(71e60a1f) SHA1(fe039350109fafcc7eda2668d3758dee3dda0ff2) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s023 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s023.p1", 0x000000, 0x100000, CRC(ae0b3fac) SHA1(2c381fe892e7daa0eeb5207d39b26466d95497c9) )
	ROM_LOAD16_WORD_SWAP( "251s023.p2", 0x100000, 0x400000, CRC(695b4619) SHA1(993f350908b103ce0d40d3484bab4539dba9c12f) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s024 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s024.p1", 0x000000, 0x100000, CRC(e93422cf) SHA1(1c98bfb5d0fccdaedb737d51a686c889ba969af4) )
	ROM_LOAD16_WORD_SWAP( "251s024.p2", 0x100000, 0x400000, CRC(ee264700) SHA1(efd797907a1ea8e65bdeb86d20f0b91435c89bc7) )

	NEO_SFIX_128K( "251s006.s1", CRC(2c0a314a) SHA1(2ca439e6c2798864d9bade7753d512b64ed34f50) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s025 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s025.p1", 0x000000, 0x4550F6, CRC(16726387) SHA1(c23d2c4af01fa833a6ab6415077c8b89392d0224) )
	ROM_LOAD16_WORD_SWAP( "251s025.p2", 0x100000, 0x454F58, CRC(fadf6a6e) SHA1(96f45ab3efcb3502527f34c1411af2ee05a5f6ff) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251s006.s1", CRC(2c0a314a) SHA1(2ca439e6c2798864d9bade7753d512b64ed34f50) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s025.c1",  0x0000000, 0x800000, CRC(216350b0) SHA1(cfd0adeea1104bc909560cd74c712f0a9df55243) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251s025.c3",  0x1000000, 0x800000, CRC(b6191162) SHA1(4eff46891102f707ace41780e39fb1da08b7d042) )
	ROM_LOAD16_BYTE( "251s025.c4",  0x1000001, 0x800000, CRC(c010a63c) SHA1(50e4b92df2683b16c88e3c6a778715723c7d486c) )
	ROM_LOAD16_BYTE( "251s025.c5",  0x2000000, 0x800000, CRC(6d721ff6) SHA1(32745dafe1443d0024d3a9d306ad1f1c3b6c73d8) )
	ROM_LOAD16_BYTE( "251s025.c6",  0x2000001, 0x800000, CRC(42406d1f) SHA1(57ea529c0aec5ae02bda2d9833fe09d68faac346) )
	ROM_LOAD16_BYTE( "251s025.c7",  0x3000000, 0x800000, CRC(d51026af) SHA1(474be5b1262485719e7f5bc28489b71c9ffaaf04) )
	ROM_LOAD16_BYTE( "251s025.c8",  0x3000001, 0x800000, CRC(3a4feeb4) SHA1(01cc62c75563e358ef01de7d4a977c15d174d040) )
ROM_END

ROM_START( kof99s026 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s026.p1", 0x000000, 0x100000, CRC(b5058c20) SHA1(aa0fb295af195e2ef231bcddbb1240e53e41ee69) )
	ROM_LOAD16_WORD_SWAP( "251s004.p2", 0x100000, 0x400000, CRC(ba3e05a7) SHA1(61c086de8b8d783c5ca3e8a970c9214b19f22d46) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s027 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s027.p1", 0x000000, 0x100000, CRC(cf1e98e7) SHA1(ec22ff296a3034d9227ccb95900136a93bd19bad) )
	ROM_LOAD16_WORD_SWAP( "251s027.p2", 0x100000, 0x400000, CRC(f38fe174) SHA1(3d4bdd76d137fbec18e5e14ba22eb5a95abaddef) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s028 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s028.p1", 0x000000, 0x100000, CRC(6806bb9a) SHA1(83f52e72ea678d0d84f399a65211987a342c442f) )
	ROM_LOAD16_WORD_SWAP( "251s028.p2", 0x100000, 0x400000, CRC(d8d74ec0) SHA1(769df8b5eb9ae648dc68d6bb84d8b52c2622a1e1) )

	NEO_SFIX_128K( "251s028.s1", CRC(b676c8fe) SHA1(b15223fc44e93bde5bfbfa3bef978b05a7117b2b) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s029 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s029.p1", 0x000000, 0x100000, CRC(3f6791d4) SHA1(84aff0e973b72cefd345c25f06062f5d5861db6d) )
	ROM_LOAD16_WORD_SWAP( "251s028.p2", 0x100000, 0x400000, CRC(d8d74ec0) SHA1(769df8b5eb9ae648dc68d6bb84d8b52c2622a1e1) )

	NEO_SFIX_128K( "251s028.s1", CRC(b676c8fe) SHA1(b15223fc44e93bde5bfbfa3bef978b05a7117b2b) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s030 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s019.p1", 0x000000, 0x100000, CRC(3c8e7e70) SHA1(f82060d02c1d823762cd28c607d99215814364c2) )
	ROM_LOAD16_WORD_SWAP( "251eur3.p2", 0x100000, 0x400000, CRC(b777285d) SHA1(ed613324ded46983dd3a40bd3f00c34b37166c31) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1", 0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s031 ) //kof99bx
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s31.p1", 0x000000, 0x100000, CRC(891afe3b) SHA1(badafe26e877332e84003bbbb2045ca9f47d5450) )
	ROM_IGNORE(0x3551C0)
	ROM_LOAD16_WORD_SWAP( "251s014.p2", 0x100000, 0x400000, CRC(e22375ba) SHA1(464dcc32fb29d6a714e3dee517bea8083c76bbbf) )
	ROM_IGNORE(0x05500a)

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEOGEO_BIOS
	ROM_REGION( 0x20000, "audiobios", 0 )
	ROM_LOAD( "sm1.sm1", 0x00000, 0x20000, CRC(94416d67) SHA1(42f9d7ddd6c0931fd64226a60dc73602b2819dcf) )
	ROM_REGION( 0x30000, "audiocpu", 0 )
	ROM_LOAD( "251s014.m1", 0x00000, 0x20000, CRC(6ac5779b) SHA1(6aa2a93cb12aa865e851808cfc33775956d7d357) )
	ROM_IGNORE(0x434f47)
	ROM_RELOAD(     0x10000, 0x20000 )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251s014.v1", 0x000000, 0x454f50, CRC(80e95dbf) SHA1(818080b406881e765900bad8690582e15cee2574) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s014.c7", 0x3000000, 0x800000, CRC(da3d47da) SHA1(19aeda9d1280d54e6a6a49754e98ad1f6bae1470) )
	ROM_LOAD16_BYTE( "251s014.c8", 0x3000001, 0x800000, CRC(0990e9a4) SHA1(5d172b0903404aabc27b5ea9867409f7aad518a0) )
ROM_END

ROM_START( kof99s032 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eur3.p1", 0x000000, 0x100000, CRC(31ebbcd6) SHA1(236dc2b5b53bbde0e0fb3fe5101341dd1ffee1cd) )
	ROM_LOAD16_WORD_SWAP( "251s032.p2", 0x100000, 0x400000, CRC(c8abcf9a) SHA1(7aea7f0c99dc2053353e04f3d0194336581edacd) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1",  0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s033 ) //kof99co
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s033.p1", 0x000000, 0x100000, CRC(0efe0a7e) SHA1(6492da39524593e867b89b1a873d2e3b7349e3a2) )
	ROM_LOAD16_WORD_SWAP( "251co2.p2", 0x100000, 0x400000, CRC(c79df28d) SHA1(352edc22d5b5ecb84748cb703135de5c2a7a0032) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251co2.s1", CRC(10b87e35) SHA1(f466e9b3ecc7b14cde42a767c3fac73a9eed282b) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s034 ) // kof99fmi
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251fmi.p1", 0x000000, 0x100000, CRC(ac853905) SHA1(e72abc420f3213ca90a60e46674ced48b0ef2f30) )
	ROM_LOAD16_WORD_SWAP( "251fmi.p2", 0x100000, 0x400000, CRC(abbc9bf3) SHA1(72ac57e9b12f1533712379d1d33b6a80bcd7a4e1) )

	NEO_SFIX_128K( "251bh.s1", CRC(b696a8c9) SHA1(3388feab11374a6eca6f1615fdfd93464f86dcee) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251xxx.c7", 0x3000000, 0x800000, CRC(a02acaf8) SHA1(4136b4bedf51e02f0e22488bf8ca21847ad63f93) )
	ROM_LOAD16_BYTE( "251xxx.c8", 0x3000001, 0x800000, CRC(e3cee593) SHA1(1ea4b9f13344b33348ef3fb95b325509399ef756) )
ROM_END

ROM_START( kof99s035 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s013.p1", 0x000000, 0x100000, CRC(3dad12db) SHA1(0ced53f7719254fd2369f724b659c1e5274d146f) )
	ROM_LOAD16_WORD_SWAP( "251s035.p2", 0x100000, 0x400000, CRC(23193920) SHA1(60d9bd3e8139e62f342b10f3a2853baff4b4e3bd) )
	ROM_LOAD16_WORD_SWAP( "251s035.p3", 0x500000, 0x400000, CRC(e3847545) SHA1(aef5625674901b33c151e81acb8d4c1118cf90d0) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s035.c1.bin", 0x000000, 0x800000, CRC(7eabea6c) SHA1(246db26c521ec3b25ac20cdc96a3c0ababffa3c2) )
	ROM_LOAD16_BYTE( "251s035.c2.bin", 0x000001, 0x800000, CRC(e5a5bc5c) SHA1(d131c4be01e97e55d2645c28defe6899fb3e0ab6) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s035.c7",   0x3000000, 0x800000, CRC(963c28ab) SHA1(35d987c115ca5785c04ebdc087667a9467c8661c) )
	ROM_LOAD16_BYTE( "251s035.c8",   0x3000001, 0x800000, CRC(43f1e92e) SHA1(70f4ece035999e80c4a39a908696369c67734121) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s036 ) // kof99hbi
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251hbi.p1", 0x000000, 0x100000, CRC(0b17b5fb) SHA1(72e0ad53fa4081df04c5aec193caf83c5baaaa7b) )
	ROM_LOAD16_WORD_SWAP( "251hbi.p2", 0x100000, 0x400000, CRC(b73cabf7) SHA1(8c2e387c8f66ca6f710be5acf21bf56284f1bbda) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251hbi.c7",  0x3000000, 0x800000, CRC(0e12697e) SHA1(65a8d5666d98ba53c3d3e5b29f24f4306c32534c) )
	ROM_LOAD16_BYTE( "251hbi.c8",  0x3000001, 0x800000, CRC(ca3b76c8) SHA1(d28c818f6561b06c2ac2d95b76f704d566549caa) )
ROM_END

ROM_START( kof99s037 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )
	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s037.c1", 0x0000000, 0x800000, CRC(57347756) SHA1(1434a903b6a2786a8a80c6168346fd4a582b9275) )
	ROM_LOAD16_BYTE( "251s037.c2", 0x0000001, 0x800000, CRC(f43de805) SHA1(fcbb1dcdaaa421e13556d9071b23652cb1020fe4) )
	ROM_LOAD16_BYTE( "251s037.c3", 0x1000000, 0x800000, CRC(b86a3b95) SHA1(0dff877d317f79683b14f4eb97325e3d7a7a4150) )
	ROM_LOAD16_BYTE( "251s037.c4", 0x1000001, 0x800000, CRC(7b61eb44) SHA1(d6bd0c24dea0c51a9078bfc317416d41c870a40e) )
	ROM_LOAD16_BYTE( "251s037.c5", 0x2000000, 0x800000, CRC(054e835d) SHA1(7ae555be8637f455458038c9dc061e0481e45715) )
	ROM_LOAD16_BYTE( "251s037.c6", 0x2000001, 0x800000, CRC(8c6ff206) SHA1(6d7ecd1e8fbbb6fcbe01fb2331c6f233dcaaaf1e) )
	ROM_LOAD16_BYTE( "251s037.c7", 0x3000000, 0x800000, CRC(fb05ae3c) SHA1(81de3b551ad9927d7b869242045e82570cbb155d) )
	ROM_LOAD16_BYTE( "251s037.c8", 0x3000001, 0x800000, CRC(3b8d30ec) SHA1(f20626488c4326f5e943e32d19478b63dbb421b3) )
ROM_END

ROM_START( kof99s038 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )
	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s038.c1", 0x0000000, 0x800000, CRC(38386019) SHA1(369e954d975d5888a99715300f6e8a1310a520e9) )
	ROM_LOAD16_BYTE( "251s038.c2", 0x0000001, 0x800000, CRC(56c50657) SHA1(95dba83d7bc6f96ea9945fc57d382bfdb4a80912) )
	ROM_LOAD16_BYTE( "251s038.c3", 0x1000000, 0x800000, CRC(11971b80) SHA1(303a735c444e24f189bdff3fa90d7d322bc0ca66) )
	ROM_LOAD16_BYTE( "251s038.c4", 0x1000001, 0x800000, CRC(ac3996c1) SHA1(033c68e1ce45fb9e6588baf833aff1696d84920d) )
	ROM_LOAD16_BYTE( "251s038.c5", 0x2000000, 0x800000, CRC(849b0ea2) SHA1(bffe70cfc5de210221c4b54902c8c4a08216b8d9) )
	ROM_LOAD16_BYTE( "251s038.c6", 0x2000001, 0x800000, CRC(174301d3) SHA1(4c63ee7e829cb76070350141223e08f7ca2ed37c) )
	ROM_LOAD16_BYTE( "251s038.c7", 0x3000000, 0x800000, CRC(547ae84e) SHA1(8b43ecd3407913b1a47a4a682b1130f0df6cce2b) )
	ROM_LOAD16_BYTE( "251s038.c8", 0x3000001, 0x800000, CRC(95ae16c6) SHA1(e71f2fa8a82e1be1dcf728273b5766119a9e7c70) )
ROM_END

ROM_START( kof99s039 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )
	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s039.c1", 0x0000000, 0x800000, CRC(348d9dfb) SHA1(e6cc6d0a935d78df901df5edc7d5b5e88622f32c) )
	ROM_LOAD16_BYTE( "251s039.c2", 0x0000001, 0x800000, CRC(1bf5929d) SHA1(430f52d6f5a125695927bdaae6cf579bccd31367) )
	ROM_LOAD16_BYTE( "251s039.c3", 0x1000000, 0x800000, CRC(b08084ac) SHA1(d6f8049304aa029b798cc92b19204d59accf11de) )
	ROM_LOAD16_BYTE( "251s039.c4", 0x1000001, 0x800000, CRC(c30e5b21) SHA1(7a68b6fe9f02e6d76c5f9cecbb67ed3eda82a0f4) )
	ROM_LOAD16_BYTE( "251s039.c5", 0x2000000, 0x800000, CRC(c64c2f8b) SHA1(7bdde4640576b30b7a6f42c94e6e140c236eda1d) )
	ROM_LOAD16_BYTE( "251s039.c6", 0x2000001, 0x800000, CRC(28110a53) SHA1(001a258d4c34b04f9e5afa179ab113633093ee5f) )
	ROM_LOAD16_BYTE( "251s039.c7", 0x3000000, 0x800000, CRC(d48656d4) SHA1(82e79cc7734a6b821399bb02aafbeb8cf1f30cf1) )
	ROM_LOAD16_BYTE( "251s039.c8", 0x3000001, 0x800000, CRC(de422e41) SHA1(fb530f8bda53b5aeb729d7b0cd9490eec0fe1ac7) )
ROM_END

ROM_START( kof99s040 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )
	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s040.c1", 0x0000000, 0x800000, CRC(1fa75649) SHA1(432ebba8a81e5ec5961588bf440669a1de1d6618) )
	ROM_LOAD16_BYTE( "251s040.c2", 0x0000001, 0x800000, CRC(0b14d920) SHA1(dc4b21e0c76f12e3b2666fcaaa6fffbca63d22a9) )
	ROM_LOAD16_BYTE( "251s040.c3", 0x1000000, 0x800000, CRC(3588cbb0) SHA1(016a3c9a1d82c85ff05dbe10e98339cc4f65bba3) )
	ROM_LOAD16_BYTE( "251s040.c4", 0x1000001, 0x800000, CRC(52a99d6b) SHA1(3098f30d3c7bac3cb9ba48f8e17809b56c34d2c8) )
	ROM_LOAD16_BYTE( "251s040.c5", 0x2000000, 0x800000, CRC(62864388) SHA1(c101e244d6429ffa733a374a510797e2a1e66e82) )
	ROM_LOAD16_BYTE( "251s040.c6", 0x2000001, 0x800000, CRC(1e84c62b) SHA1(cd096cf8a7b3e684047bffb5d372ab21a1da1f83) )
	ROM_LOAD16_BYTE( "251s040.c7", 0x3000000, 0x800000, CRC(1b3b73ef) SHA1(5b9395cc0234c3139f8c2e6e81e2bf175ce864c2) )
	ROM_LOAD16_BYTE( "251s040.c8", 0x3000001, 0x800000, CRC(772c7c0d) SHA1(dcc6d59992f91fe67e1da5ba48a804418044e5c6) )
ROM_END

ROM_START( kof99s041 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )
	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s041.c1", 0x0000000, 0x800000, CRC(882a613a) SHA1(b24e4166c8dcd4c1e892af4880ac1ea97b5cab61) )
	ROM_LOAD16_BYTE( "251s041.c2", 0x0000001, 0x800000, CRC(bbea5b8c) SHA1(3845c975fc8b5a1f6f60c8e29308a7c3c9095f7f) )
	ROM_LOAD16_BYTE( "251s041.c3", 0x1000000, 0x800000, CRC(00749329) SHA1(401e0b52731dca85cc003a4a3f0226f49f38eb08) )
	ROM_LOAD16_BYTE( "251s041.c4", 0x1000001, 0x800000, CRC(ca760380) SHA1(5b5898aac852bb334c05e4d3ff76b9dc73fb1a87) )
	ROM_LOAD16_BYTE( "251s041.c5", 0x2000000, 0x800000, CRC(8838926c) SHA1(16e8e86a6d7212d99571e84f297d06f478a7022d) )
	ROM_LOAD16_BYTE( "251s041.c6", 0x2000001, 0x800000, CRC(551c684b) SHA1(94240fb238ba502ba329473b384c1b959fff4641) )
	ROM_LOAD16_BYTE( "251s041.c7", 0x3000000, 0x800000, CRC(26c29725) SHA1(98e73cf8c3cfcc6f844daf351ceca291fc1f60cf) )
	ROM_LOAD16_BYTE( "251s041.c8", 0x3000001, 0x800000, CRC(0dc58700) SHA1(d4433d734ffac1eb4b8354e06830d8977ac6fb1f) )
ROM_END

ROM_START( kof99s042 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )
	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s042.c1", 0x0000000, 0x800000, CRC(46de5432) SHA1(f1894d03d7e3067a9c05fe06f333bd2bf4adf811) )
	ROM_LOAD16_BYTE( "251s042.c2", 0x0000001, 0x800000, CRC(ed4affdd) SHA1(8d0e8a76f5c3e8432f416651939ee0b71c92275a) )
	ROM_LOAD16_BYTE( "251s042.c3", 0x1000000, 0x800000, CRC(68ea2a39) SHA1(edbc096d21959dd9ce8d6d5014e844827c144bef) )
	ROM_LOAD16_BYTE( "251s042.c4", 0x1000001, 0x800000, CRC(49f7cf11) SHA1(58c33c6bc098179dd29b841fed6ec267c44b7a18) )
	ROM_LOAD16_BYTE( "251s042.c5", 0x2000000, 0x800000, CRC(e6b10a3d) SHA1(858cb4e7243594ba341f207cd943e030f1586d08) )
	ROM_LOAD16_BYTE( "251s042.c6", 0x2000001, 0x800000, CRC(d9d9f553) SHA1(3a159f78c6fda4cda02ba8c6a291e8895269e972) )
	ROM_LOAD16_BYTE( "251s042.c7", 0x3000000, 0x800000, CRC(58d00efe) SHA1(5521e6c6a79269f6952f541292299dd743532a31) )
	ROM_LOAD16_BYTE( "251s042.c8", 0x3000001, 0x800000, CRC(7a69b0ae) SHA1(1d7ad6d400794d7a0c655000a25ae3c3544bfe53) )
ROM_END

ROM_START( kof99s043 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "ka.neo-sma", 0x0c0000, 0x040000, CRC(7766d09e) SHA1(4e0a49d1ad669a62676cb30f527c6590cde80194) )
	ROM_LOAD16_WORD_SWAP( "251s043.p1",  0x100000, 0x400000, CRC(601c4859) SHA1(540207be113288e378a4db594cc3e961c7eb7a2b) )
	ROM_LOAD16_WORD_SWAP( "251.p2",  0x500000, 0x400000, CRC(90175f15) SHA1(aa9e75810438a8b45808a8bf32cb04d91b5c0b3a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s044 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s044.p1",  0x000000, 0x100000, CRC(9e3ef1df) SHA1(f2d0d4883f79f04f846bd5fd6499bae26f24a00c) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s045 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s045.p1",  0x000000, 0x100000, CRC(139493f7) SHA1(90d240c9f3e4f06ea8aeb917f0d09990c7c76716) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s046 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s046.p1",  0x000000, 0x100000, CRC(16b39384) SHA1(b512ad118ba1b8c6f7eafbec82b67d89f18f8793) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s047 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s047.p1",  0x000000, 0x100000, CRC(f6ebb8bb) SHA1(c08aac9130526256bfb6eb991afc86237f09f980) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s048 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s048.p1",  0x000000, 0x100000, CRC(decaaabb) SHA1(6d699fb798967771b87171260bc4d0e727d67c9c) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s049 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s049.p1",  0x000000, 0x100000, CRC(efbb7db2) SHA1(b90892cce7e8b73711ebd4a334c6d2489529d307) )
	ROM_LOAD16_WORD_SWAP( "251s049.p2", 0x100000, 0x400000, CRC(ee123196) SHA1(fe4bafab2d91136f7b681ca15b6d829c52db6b5e) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s050 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s050.p1",  0x000000, 0x100000, CRC(19f79912) SHA1(0095a6bfda75926d20dca3707e30b037f909df56) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s051 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s051.p1",  0x000000, 0x100000, CRC(9d6628ae) SHA1(76075cac1591838ca58270c4d95a669075769ec5) )
	ROM_LOAD16_WORD_SWAP( "251s051.p2", 0x100000, 0x400000, CRC(474096ad) SHA1(c41aaba04c789736ca066e3831a9efe7357c4f58) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s051.c1", 0x0000000, 0x800000, CRC(fb5e54a4) SHA1(41638ed31c065040b07c59cdc5ca94e96a4c110c) )
	ROM_LOAD16_BYTE( "251s051.c2", 0x0000001, 0x800000, CRC(82e7c712) SHA1(3ec0fd5c4bf7619e29522757269f42c3bcb08132) )
	ROM_LOAD16_BYTE( "251s051.c3", 0x1000000, 0x800000, CRC(69b76dce) SHA1(f36a69504db26b1e338cb816cd8783ea72c22308) )
	ROM_LOAD16_BYTE( "251s051.c4", 0x1000001, 0x800000, CRC(8cba5e55) SHA1(346596486b1e7fe28e73c83ef7d3650ddd95ffed) )
	ROM_LOAD16_BYTE( "251s051.c5", 0x2000000, 0x800000, CRC(3be082f6) SHA1(d1dcc03fbc78c95f6bbdbee48d7baf03a950a230) )
	ROM_LOAD16_BYTE( "251s051.c6", 0x2000001, 0x800000, CRC(ce7faa60) SHA1(8411ff688d29972b2e27fbad2b88df87a5c233f7) )
	ROM_LOAD16_BYTE( "251s051.c7", 0x3000000, 0x800000, CRC(2546c2c3) SHA1(309203d916e142997f097e9d75c2ceea7c7c843d) )
	ROM_LOAD16_BYTE( "251s051.c8", 0x3000001, 0x800000, CRC(d6e78b0b) SHA1(42be53ed225600d537de192e8f8ea71c7feec5b6) )
ROM_END

ROM_START( kof99s052 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s052.p1",  0x000000, 0x100000, CRC(f5e23fb5) SHA1(9324485d0124e6ef95093eb4e27b2c4a5cfa9622) )
	ROM_LOAD16_WORD_SWAP( "251s052.p2", 0x100000, 0x400000, CRC(a204d82b) SHA1(d1aa09f0df1e9986d8befa54d512f9ea9c8dc4ea) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s052.c1", 0x0000000, 0x800000, CRC(97bc5011) SHA1(7605a274151e17ffdab7159a839d97c6ae6915a4) )
	ROM_LOAD16_BYTE( "251s052.c2", 0x0000001, 0x800000, CRC(f8bf9832) SHA1(4aa804cf0c776ade22048520a99010a3336a8fe5) )
	ROM_LOAD16_BYTE( "251s052.c3", 0x1000000, 0x800000, CRC(119ddd2a) SHA1(4b2fc0fa70d06f4438eb1f96923fd70d0a1d2ad5) )
	ROM_LOAD16_BYTE( "251s052.c4", 0x1000001, 0x800000, CRC(937c46af) SHA1(7ac8b6c5243b70ca5ca384020aad28319ae43f1b) )
	ROM_LOAD16_BYTE( "251s052.c5", 0x2000000, 0x800000, CRC(c1352eb2) SHA1(067b1822b566cd4f65fe94312c1f81647d4e31f5) )
	ROM_LOAD16_BYTE( "251s052.c6", 0x2000001, 0x800000, CRC(1593644b) SHA1(26260b2f8b6ecb995ac4286f90ed7047ce1fe014) )
	ROM_LOAD16_BYTE( "251s052.c7", 0x3000000, 0x800000, CRC(b613eab2) SHA1(c31c7a397754310d099c829fdfe7a8da27639480) )
	ROM_LOAD16_BYTE( "251s052.c8", 0x3000001, 0x800000, CRC(2499ce26) SHA1(d52dffea56dd9b72d72fee4adf0d706c68782a5f) )
ROM_END

ROM_START( kof99s053 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s053.p2", 0x100000, 0x400000, CRC(0ad3b005) SHA1(51bb54d70bc052a21a3ef8d59db4d698817746ab) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s054 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s054.p1",  0x000000, 0x100000, CRC(ca8ff61a) SHA1(7180c4212cc12034c661311a4dcc40f159086298) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s055 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s055.p1",  0x000000, 0x100000, CRC(e5d021ec) SHA1(3358406910c2f05ef7fa97b0f9488b96b59fdffb) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s056 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s056.p1",  0x000000, 0x100000, CRC(225e4794) SHA1(e1c7dbe276e8301f69205f1fe659610a6db5782b) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s057 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s057.p1",  0x000000, 0x100000, CRC(5ce2f562) SHA1(2bcd61e18d19460b85abaf72729ae997b1a2f16b) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s058 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s058.p1",  0x000000, 0x100000, CRC(1a6c3e26) SHA1(c17c239bcf114896fe2eb469487473d86616a4f2) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s059 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s059.p1",  0x000000, 0x100000, CRC(a8e01c4b) SHA1(f239f98d003db87fb72f169fa182c1ea360f40bd) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s060 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s060.p1",  0x000000, 0x100000, CRC(4edabf26) SHA1(d63c76a94ddb416870998b3c03acb2d68b52f4b0) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s061 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s061.p1",  0x000000, 0x100000, CRC(e5f0a5eb) SHA1(2689342a031e20f6b4387eed0023caa4bcfcd74e) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s062 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s062.p1",  0x000000, 0x100000, CRC(67bb2344) SHA1(7bc258389bb72f91a22e083e09234a43f1730434) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s063 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s063.p2", 0x100000, 0x400000, CRC(a7b9b55f) SHA1(7c1bed31e0932e97cf04fd1296d71a40f47a312a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s064 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s064.p1",  0x000000, 0x100000, CRC(4e9a83b6) SHA1(056e414028d6e56604ad819464232b860f4d4c29) )
	ROM_LOAD16_WORD_SWAP( "251s064.p2", 0x100000, 0x400000, CRC(1c8667c9) SHA1(73098d4057aba08da302b94631310f2ce7f0d9b3) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s065 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s065.p1",  0x000000, 0x100000, CRC(24cf7eff) SHA1(99b63c7880a513bdbf9407bdd57c00186f789755) )
	ROM_LOAD16_WORD_SWAP( "251s065.p2", 0x100000, 0x400000, CRC(faaf8d5f) SHA1(c4571e64f146e005c6b65d48a2d425f053fd473f) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s066 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s066.p2", 0x100000, 0x400000, CRC(31520041) SHA1(11d44ef8f8d789eccdbf57848472dc1b442f7676) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s067 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s067.p2", 0x100000, 0x400000, CRC(a92d22a7) SHA1(b927a3933c1314588fb9a506f713eaf8be675f4c) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s068 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s068.p2", 0x100000, 0x400000, CRC(00911e1d) SHA1(5326ee55641e4ffe2011da6424c57b0470ce0d07) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s069 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s069.p2", 0x100000, 0x400000, CRC(1c974457) SHA1(7cefe34e0a560106a77275247b62d31ae03b5725) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s070 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s070.p2", 0x100000, 0x400000, CRC(ab83c2fb) SHA1(48a3a50c12a5e5e2603db72527c1b2920bcbe63a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s071 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s071.p2", 0x100000, 0x400000, CRC(d4719ae3) SHA1(ffa11c531460c5310ae3d171b0920d7c67438aed) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s072 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s072.p2", 0x100000, 0x400000, CRC(c00cd9ee) SHA1(42140abc9ffd640b4a190cbcbb83936a549d8f3b) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s073 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s073.p1",  0x000000, 0x100000, CRC(c539927c) SHA1(f39074fc2340ebc1096911d504ecb7af1024eb93) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s074 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s074.p1",  0x000000, 0x100000, CRC(ffa43218) SHA1(e9463795f940c4a167f8913066584c2dc673bbc7) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s075 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s075.p2", 0x100000, 0x400000, CRC(625e22fe) SHA1(fc20b2e245f4760dcadded8c050a61baf8ca8c30) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s076 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s076.p1",  0x000000, 0x100000, CRC(20e8ac1b) SHA1(dba655fad002960fb122e153ee6d1db15cf1945d) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s077 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s077.p2", 0x100000, 0x400000, CRC(60afe537) SHA1(65ddbce138cb7892ad15ceb966efc9f5c42feac2) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s078 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s078.p2", 0x100000, 0x400000, CRC(7e5b6fc4) SHA1(1c999e17bb45882cc8784639b3798dcec8377180) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s079 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s079.p2", 0x100000, 0x400000, CRC(2a9c0344) SHA1(7889bf53a96ead999d727febb7e9185a0795fc1d) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s080 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s080.p1",  0x000000, 0x100000, CRC(1085897a) SHA1(0571ac758b4605e0ebe02276df94fb8034dd9337) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s081 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s081.p1",  0x000000, 0x100000, CRC(ed4687ce) SHA1(3fe7fee58a63e0946d57d18dfd542ca6effa598c) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s082 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s082.p1",  0x000000, 0x100000, CRC(df865462) SHA1(bd2b4284ab182f5e0548c221e6ef3e201a038a82) )
	ROM_LOAD16_WORD_SWAP( "251s082.p2", 0x100000, 0x400000, CRC(19654b9f) SHA1(393816bcc46c65f1fd6764cd1720910c3a39dd70) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s083 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s083.p1",  0x000000, 0x100000, CRC(5df509d0) SHA1(f609f4a914caba43643b7923c1900135f22139f2) )
	ROM_LOAD16_WORD_SWAP( "251s082.p2", 0x100000, 0x400000, CRC(19654b9f) SHA1(393816bcc46c65f1fd6764cd1720910c3a39dd70) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s084 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s084.p1",  0x000000, 0x100000, CRC(e128e60f) SHA1(8c61947b0589b686a5c9528dd4738def7d281e34) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s085 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251s085.p2", 0x100000, 0x400000, CRC(18c75b55) SHA1(5772fcde18afb627dd52c0fd72a018f1d5d90e8a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s086 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s086.p1",  0x000000, 0x100000, CRC(180ad904) SHA1(6502ef58ee16f54da344d2a36f9d68a579a06e52) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s087 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s087.p1",  0x000000, 0x100000, CRC(b17a9456) SHA1(c1998b085379b33cfb9786c206f950b909e8b392) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s088 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251srr.p1", 0x000000, 0x100000, CRC(c7cd6ffe) SHA1(f0130b9bd80b4b9d452f53fac85853d9fa563144) )
	ROM_LOAD16_WORD_SWAP( "251s003.p2", 0x100000, 0x400000, CRC(da68e5be) SHA1(d955f6186df89bdbb8eb16b7ea86815874ee5e40) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1", 0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s088.c1", 0x0000000, 0x800000, CRC(78112d24) SHA1(c3c57e2d1638261f153ec1cb91f3a5b89c765535) )
	ROM_LOAD16_BYTE( "251s088.c2", 0x0000001, 0x800000, CRC(f8698000) SHA1(8295147bae741b922c4eb8bd77af9ae499674f69) )
	ROM_LOAD16_BYTE( "251s088.c3", 0x1000000, 0x800000, CRC(a84ae021) SHA1(8591ddbf30a73826864983d471548f11f74a551a) )
	ROM_LOAD16_BYTE( "251s088.c4", 0x1000001, 0x800000, CRC(11317026) SHA1(913603db084ef765418f6d2a020e64febc3d499a) )
	ROM_LOAD16_BYTE( "251s088.c5", 0x2000000, 0x800000, CRC(0943a49f) SHA1(2c49e40d85511e5dfe6ebd8b8315c529971305ea) )
	ROM_LOAD16_BYTE( "251s088.c6", 0x2000001, 0x800000, CRC(7ffde364) SHA1(233603fcd481c018862f28045730e4099ff34776) )
	ROM_LOAD16_BYTE( "251s088.c7", 0x3000000, 0x800000, CRC(819c10a3) SHA1(7b5d6fb4ced1176c2d028460334a4049098a2e1e) )
	ROM_LOAD16_BYTE( "251s088.c8", 0x3000001, 0x800000, CRC(fc5ec208) SHA1(cc067814ec8533fe0ee31e435060caf55191caf3) )
ROM_END

ROM_START( kof99s089 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s089.p1",  0x000000, 0x100000, CRC(42104d42) SHA1(5e0987a942aab01386fb6ae95641b86ac557de72) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1", 0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2", 0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3", 0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4", 0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5", 0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6", 0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7", 0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8", 0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s090 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251bs.p1", 0x000000, 0x100000, CRC(43ce0028) SHA1(7f6ee38c5eb89410f56907f66e6c45f38384da2c) )
	ROM_LOAD16_WORD_SWAP( "251bs.p2", 0x100000, 0x400000, CRC(e20677c4) SHA1(3ada6a734a5ec274f96b012146ca3416b66b6865) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s090.c1", 0x0000000, 0x800000, CRC(a282d688) SHA1(000c708b0ba0ac5795625873ed571f958f5d86a7) )
	ROM_LOAD16_BYTE( "251s090.c2", 0x0000001, 0x800000, CRC(780a9660) SHA1(b0e9878e92e5aeb2538be1e5ce41865f9da1d237) )
	ROM_LOAD16_BYTE( "251s090.c3", 0x1000000, 0x800000, CRC(559040a8) SHA1(06bd27db1198f0309890fdf415b5f74c2edca5dd) )
	ROM_LOAD16_BYTE( "251s090.c4", 0x1000001, 0x800000, CRC(689fb919) SHA1(c767e5ae3e3291308ca85a78bfe82a03bff56520) )
	ROM_LOAD16_BYTE( "251s090.c5", 0x2000000, 0x800000, CRC(7c0b9dc8) SHA1(ece329cfe13128172653e530809b972c6bdcb623) )
	ROM_LOAD16_BYTE( "251s090.c6", 0x2000001, 0x800000, CRC(31fcf35a) SHA1(919ad733029ca941e774ac609f6352c3deafd45f) )
	ROM_LOAD16_BYTE( "251s090.c7", 0x3000000, 0x800000, CRC(52c5497c) SHA1(288c2932f483cffd80b7e1f58c14cf2c5ba3ef09) )
	ROM_LOAD16_BYTE( "251s090.c8", 0x3000001, 0x800000, CRC(4b03235e) SHA1(8451fc9e605a07a1afc8718af36c2a157eee02e5) )
ROM_END

ROM_START( kof99s091 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251bs2.p1", 0x000000, 0x100000, CRC(3adcedbb) SHA1(ce21a4d981354303031fee17e8db9f9961ebe5c9) )
	ROM_LOAD16_WORD_SWAP( "251bs2.p2", 0x100000, 0x400000, CRC(62b11826) SHA1(13113692b43c3d1b5c8572d2024777e6a1a15e2b) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s091.c1", 0x0000000, 0x800000, CRC(56adec5f) SHA1(85399fdaeef2f803bac64c351d8bb634780678b4) )
	ROM_LOAD16_BYTE( "251s091.c2", 0x0000001, 0x800000, CRC(883492ec) SHA1(953ce11f76962e9b2b903d6c0d49810039a1ea23) )
	ROM_LOAD16_BYTE( "251s091.c3", 0x1000000, 0x800000, CRC(03bd5cd5) SHA1(8af63544160e4b6249b24092e5fb8f14ca274b65) )
	ROM_LOAD16_BYTE( "251s091.c4", 0x1000001, 0x800000, CRC(824fb11c) SHA1(b3c336364fe330a52ccb4e22f532df2de8baf7da) )
	ROM_LOAD16_BYTE( "251s091.c5", 0x2000000, 0x800000, CRC(3d9f57a4) SHA1(224449294706d7af11a4b6ffc3bf17ea3ad2ff86) )
	ROM_LOAD16_BYTE( "251s091.c6", 0x2000001, 0x800000, CRC(e1fb7f44) SHA1(318af6331a2622991f3c6e6cb381958d16e8879c) )
	ROM_LOAD16_BYTE( "251s091.c7", 0x3000000, 0x800000, CRC(11bd7a83) SHA1(4a11bccc442eb29b6a799a6fde08a29337f1348a) )
	ROM_LOAD16_BYTE( "251s091.c8", 0x3000001, 0x800000, CRC(caf0f9bc) SHA1(804d4ec9d3d9e4aef1fdf14ad64bf613694aef10) )
ROM_END

ROM_START( kof99s092 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251revo.p1", 0x000000, 0x100000, CRC(38FD8609) SHA1(fded1624a670835ae107dc19707c2fa8b06d6cea) )
	ROM_LOAD16_WORD_SWAP( "251revo.p2", 0x100000, 0x400000, CRC(361F64DB) SHA1(a789df74ff197f2c552a87be4db8d321603d404e) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s092.c1", 0x0000000, 0x800000, CRC(e0f8fc12) SHA1(54c716787d153dc874ad56059835cdef4f241f96) )
	ROM_LOAD16_BYTE( "251s092.c2", 0x0000001, 0x800000, CRC(bb047b16) SHA1(c68138dcfa630922f287a0a64e4fb6a69b4f70d1) )
	ROM_LOAD16_BYTE( "251s092.c3", 0x1000000, 0x800000, CRC(72e4cb0b) SHA1(c4eeb028a4fe288f2ccd6836a49eefdea469b43d) )
	ROM_LOAD16_BYTE( "251s092.c4", 0x1000001, 0x800000, CRC(45d52911) SHA1(097116add7eccfb8b99f88e1257fade96c33ce59) )
	ROM_LOAD16_BYTE( "251s092.c5", 0x2000000, 0x800000, CRC(3ebdce7e) SHA1(7ae38c01e2e4d06c3926595040dd574869270f17) )
	ROM_LOAD16_BYTE( "251s092.c6", 0x2000001, 0x800000, CRC(ea80f6ba) SHA1(65f76c9e88632c01d9dd6ef6dd94549527e4776f) )
	ROM_LOAD16_BYTE( "251s092.c7", 0x3000000, 0x800000, CRC(247f7a9d) SHA1(e4871688000f66ae7ddabec986c8911e981c1799) )
	ROM_LOAD16_BYTE( "251s092.c8", 0x3000001, 0x800000, CRC(ac3b1ba1) SHA1(d8cad41ef482159043f17a4979d3d496f5473432) )
ROM_END

ROM_START( kof99s093 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251fc2.p1", 0x000000, 0x100000, CRC(7f14f664) SHA1(0f17b6fbe919b78f63de4e10fc95c6e7e688206d) )
	ROM_LOAD16_WORD_SWAP( "251fc.p2", 0x100000, 0x400000, CRC(01e111b3) SHA1(4ae2fbd552246779146684d2191a7bc9a3554c59) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s093.c1", 0x0000000, 0x800000, CRC(39fbe868) SHA1(6207a11f53dfd1253d5f4e09de7e6399fbc00cb1) )
	ROM_LOAD16_BYTE( "251s093.c2", 0x0000001, 0x800000, CRC(ef461a92) SHA1(96dbf00b283630a9f4bc4ce1998f1e68c5c021e8) )
	ROM_LOAD16_BYTE( "251s093.c3", 0x1000000, 0x800000, CRC(c79dfe9d) SHA1(d0cdc2d6de828bd01c56b26a81a3f21c61ecf5f5) )
	ROM_LOAD16_BYTE( "251s093.c4", 0x1000001, 0x800000, CRC(24907843) SHA1(af11409ac8cffc499a87f3e5962a73b1780f6f89) )
	ROM_LOAD16_BYTE( "251s093.c5", 0x2000000, 0x800000, CRC(3192738e) SHA1(73ac21770606f65b8e62a23c263bef6f61dbaaf4) )
	ROM_LOAD16_BYTE( "251s093.c6", 0x2000001, 0x800000, CRC(0c9f4912) SHA1(74fd7d24f1ddae4b087c6ef790fed2db8dba1b6f) )
	ROM_LOAD16_BYTE( "251s093.c7", 0x3000000, 0x800000, CRC(54bc5d03) SHA1(bd27254cbc5c19247cef2ff84ef52561dc35007d) )
	ROM_LOAD16_BYTE( "251s093.c8", 0x3000001, 0x800000, CRC(4943a1c3) SHA1(40ed95a443ebf626c599118daa7c35da29aba489) )
ROM_END

ROM_START( kof99s094 ) // kof99iori - iori
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251iori.p1", 0x000000, 0x100000, CRC(6140956d) SHA1(e4dabd3b134701459c1360fffec4bcb27a48dac0) )
	ROM_LOAD16_WORD_SWAP( "251iori.p2", 0x100000, 0x400000, CRC(d31111e3) SHA1(c6396c0eefd464320b0c3d68f7bcfaddb31b63ba) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s095 ) //kof99alpha
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s095.p1", 0x000000, 0x100000, CRC(ec0b98e2) SHA1(aa499df2f0d5ae4e69ae6d47e618b1410c80c172) )
	ROM_LOAD16_WORD_SWAP( "251s095.p2", 0x100000, 0x400000, CRC(d20f9923) SHA1(b90d0befd572b1cfb04f76ba590558940cde1c8b) )
	ROM_FILL(0x02abe8,1,0x65)

	NEO_SFIX_128K( "251pb.s1", CRC(0b3d79d3) SHA1(2647c617c52d9955ee29520c416b59febfe7c0db) )

	NEO_BIOS_AUDIO_256K( "251s095.m1", CRC(e9944b02) SHA1(f900f1c6d84be4194578b599bdeb203ab23d6f10) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251s095.v4", 0xc00000, 0x400000, CRC(a5baad2a) SHA1(f8b2a0b88f1214ed0e82220494bfbb3616465930) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251bhp2.c7", 0x3000000, 0x800000, CRC(a0fb0a24) SHA1(89b01efb4b5352efd3e1483e424e319d5a1f1451) )
	ROM_LOAD16_BYTE( "251bhp2.c8", 0x3000001, 0x800000, CRC(fbc1112c) SHA1(3f3789b8bbc335a4f9b66fc66a350767ec7bc32c) )
ROM_END

ROM_START( kof99s096 ) //kof99alpha
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s096.p1", 0x000000, 0x100000, CRC(436cff3f) SHA1(bf1721e7a9cd3ba0b87ced7daa40aa4ef8f2b96e) )
	ROM_LOAD16_WORD_SWAP( "251s095.p2", 0x100000, 0x400000, CRC(d20f9923) SHA1(b90d0befd572b1cfb04f76ba590558940cde1c8b) )

	NEO_SFIX_128K( "251pb.s1", CRC(0b3d79d3) SHA1(2647c617c52d9955ee29520c416b59febfe7c0db) )

	NEO_BIOS_AUDIO_256K( "251s095.m1", CRC(e9944b02) SHA1(f900f1c6d84be4194578b599bdeb203ab23d6f10) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251s095.v4", 0xc00000, 0x400000, CRC(a5baad2a) SHA1(f8b2a0b88f1214ed0e82220494bfbb3616465930) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251bhp2.c7", 0x3000000, 0x800000, CRC(a0fb0a24) SHA1(89b01efb4b5352efd3e1483e424e319d5a1f1451) )
	ROM_LOAD16_BYTE( "251bhp2.c8", 0x3000001, 0x800000, CRC(fbc1112c) SHA1(3f3789b8bbc335a4f9b66fc66a350767ec7bc32c) )
ROM_END

ROM_START( kof99s097 ) // kof99rp2f
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s097.p1", 0x000000, 0x100000, CRC(1c5fd0ad) SHA1(78cfe664ca9b461587e5029ec34a0da228ba0788) )
	ROM_LOAD16_WORD_SWAP( "251fc.p2", 0x100000, 0x400000, CRC(01e111b3) SHA1(4ae2fbd552246779146684d2191a7bc9a3554c59) )

	NEO_SFIX_128K( "251fc.s1", CRC(ca942904) SHA1(f84b79282bb2de61d24faacca1feda0187e42dcd) )

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251fc.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251fc.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251fc.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251fc.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251fc.c7", 0x3000000, 0x800000, CRC(1dfd5103) SHA1(edbe56d9434abdff58e7e9ceed7ea3d7975c40d2) )
	ROM_LOAD16_BYTE( "251fc.c8", 0x3000001, 0x800000, CRC(23fe3c43) SHA1(b601a14cd023b28f8e8eed8afd6a05d2c3df115a) )
ROM_END

ROM_START( kof99s098 ) //kof99ae
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s098.p1", 0x000000, 0x100000, CRC(886ce3d7) SHA1(ea28928523c65e8cc3511ab635407613b9880b92) )
	ROM_LOAD16_WORD_SWAP( "251s035.p2", 0x100000, 0x400000, CRC(23193920) SHA1(60d9bd3e8139e62f342b10f3a2853baff4b4e3bd) )
	ROM_LOAD16_WORD_SWAP( "251s035.p3", 0x500000, 0x400000, CRC(e3847545) SHA1(aef5625674901b33c151e81acb8d4c1118cf90d0) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s035.c1.bin", 0x000000, 0x800000, CRC(7eabea6c) SHA1(246db26c521ec3b25ac20cdc96a3c0ababffa3c2) )
	ROM_LOAD16_BYTE( "251s035.c2.bin", 0x000001, 0x800000, CRC(e5a5bc5c) SHA1(d131c4be01e97e55d2645c28defe6899fb3e0ab6) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s035.c7",   0x3000000, 0x800000, CRC(963c28ab) SHA1(35d987c115ca5785c04ebdc087667a9467c8661c) )
	ROM_LOAD16_BYTE( "251s035.c8",   0x3000001, 0x800000, CRC(43f1e92e) SHA1(70f4ece035999e80c4a39a908696369c67734121) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s099 ) //kof99evoru
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s099.p1", 0x000000, 0x100000, CRC(211146a3) SHA1(e24ab9d56143afd701de21f11d0beceb7e4d87a1) )
	ROM_LOAD16_WORD_SWAP( "251s099.p2", 0x100000, 0x400000, CRC(f152908b) SHA1(b48a359dee478be540ae0f11c7d3ae9177d44908) )
	ROM_FILL(0x02abe8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1",  0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s099.c7", 0x3000000, 0x800000, CRC(7c55a99c) SHA1(d874a79b802860d4eee4a55bacd0bb6a034be625) )
	ROM_LOAD16_BYTE( "251s099.c8", 0x3000001, 0x800000, CRC(ee2fec70) SHA1(1a093c8e727b167062b985a0d33ee932fafc7c8a) )
ROM_END

ROM_START( kof99s100 ) //kof99rpg
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s100.p1", 0x000000, 0x100000, CRC(3d957393) SHA1(ed21c19208d661ce86e43a51fb3b6186c9469da9) )
	ROM_LOAD16_WORD_SWAP( "251fc.p2", 0x100000, 0x400000, CRC(01e111b3) SHA1(4ae2fbd552246779146684d2191a7bc9a3554c59) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251fc.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251fc.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251fc.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251fc.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251s100.c7", 0x3000000, 0x800000, CRC(d8af223a) SHA1(c75103f2a3ab56c4409da3ce62ae019bd8152bc9) )
	ROM_LOAD16_BYTE( "251s100.c8", 0x3000001, 0x800000, CRC(c796b9bb) SHA1(5aff960de2ee63eed5fbfed1acb058629fb990af) )
ROM_END

ROM_START( kof99s101 ) //kof99ae
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s013.p1", 0x000000, 0x100000, CRC(3dad12db) SHA1(0ced53f7719254fd2369f724b659c1e5274d146f) )
	ROM_LOAD16_WORD_SWAP( "251s101.p2", 0x100000, 0x400000, CRC(f3f47f41) SHA1(319ddb12c5353f4e27712db041c750f36df832b0) )
	ROM_LOAD16_WORD_SWAP( "251s013.p3", 0x500000, 0x400000, CRC(bc85cf02) SHA1(a1a8228299a76bf840822d50528a67d4d3c5ac5e) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s035.c1.bin", 0x000000, 0x800000, CRC(7eabea6c) SHA1(246db26c521ec3b25ac20cdc96a3c0ababffa3c2) )
	ROM_LOAD16_BYTE( "251s035.c2.bin", 0x000001, 0x800000, CRC(e5a5bc5c) SHA1(d131c4be01e97e55d2645c28defe6899fb3e0ab6) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s035.c7",   0x3000000, 0x800000, CRC(963c28ab) SHA1(35d987c115ca5785c04ebdc087667a9467c8661c) )
	ROM_LOAD16_BYTE( "251s035.c8",   0x3000001, 0x800000, CRC(43f1e92e) SHA1(70f4ece035999e80c4a39a908696369c67734121) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s102 ) //kof99ae
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s102.p1", 0x000000, 0x100000, CRC(3ce800cb) SHA1(1656c99fc9d16179fea1209aa45d8b769bb25fb3) )
	ROM_LOAD16_WORD_SWAP( "251s101.p2", 0x100000, 0x400000, CRC(f3f47f41) SHA1(319ddb12c5353f4e27712db041c750f36df832b0) )
	ROM_LOAD16_WORD_SWAP( "251s013.p3", 0x500000, 0x400000, CRC(bc85cf02) SHA1(a1a8228299a76bf840822d50528a67d4d3c5ac5e) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251s035.c1.bin", 0x000000, 0x800000, CRC(7eabea6c) SHA1(246db26c521ec3b25ac20cdc96a3c0ababffa3c2) )
	ROM_LOAD16_BYTE( "251s035.c2.bin", 0x000001, 0x800000, CRC(e5a5bc5c) SHA1(d131c4be01e97e55d2645c28defe6899fb3e0ab6) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s035.c7",   0x3000000, 0x800000, CRC(963c28ab) SHA1(35d987c115ca5785c04ebdc087667a9467c8661c) )
	ROM_LOAD16_BYTE( "251s035.c8",   0x3000001, 0x800000, CRC(43f1e92e) SHA1(70f4ece035999e80c4a39a908696369c67734121) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s103 ) //kof99maxp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s103.p1", 0x000000, 0x100000, CRC(b33712fd) SHA1(c0e1076c0bb34df003a979a89a0347c09900e3ef) )
	ROM_LOAD16_WORD_SWAP( "251s103.p2", 0x100000, 0x400000, CRC(3955b253) SHA1(993610003b23c0fcdcfa44f7537e9d31c5c9378e) )

	NEO_SFIX_128K( "251s006.s1", CRC(2c0a314a) SHA1(2ca439e6c2798864d9bade7753d512b64ed34f50) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s104 ) //kof99ndps
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s104.p1", 0x000000, 0x100000, CRC(09c70195) SHA1(e3db41b49700138ce7b9423438a2fc9cbe15e65e) )
	ROM_LOAD16_WORD_SWAP( "251s104.p2", 0x100000, 0x400000, CRC(d89a2677) SHA1(20cfaea7da0934286675ad0718e09474aa87b38e) )
	ROM_FILL(0x02abe8,1,0x65)

	NEO_SFIX_128K( "251sr.s1", CRC(08055c7a) SHA1(682e0084e62b547482929babe828027fdd64cde0) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s104.c7", 0x3000000, 0x800000, CRC(96992b0c) SHA1(ef516e5c114f2adef0f3b8ec861bc25977e748c2) )
	ROM_LOAD16_BYTE( "251s104.c8", 0x3000001, 0x800000, CRC(a791c727) SHA1(d62e99683fea28ec405360e4379466b7d91386f8) )
ROM_END

ROM_START( kof99s105 ) //kof99ndps
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s105.p1", 0x000000, 0x100000, CRC(afa3ef37) SHA1(5a275cb5de5703a7388a6805adf2ed7200b416f5) )
	ROM_LOAD16_WORD_SWAP( "251s104.p2", 0x100000, 0x400000, CRC(d89a2677) SHA1(20cfaea7da0934286675ad0718e09474aa87b38e) )
	ROM_FILL(0x02abe8,1,0x65)

	NEO_SFIX_128K( "251sr.s1", CRC(08055c7a) SHA1(682e0084e62b547482929babe828027fdd64cde0) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251s104.c7", 0x3000000, 0x800000, CRC(96992b0c) SHA1(ef516e5c114f2adef0f3b8ec861bc25977e748c2) )
	ROM_LOAD16_BYTE( "251s104.c8", 0x3000001, 0x800000, CRC(a791c727) SHA1(d62e99683fea28ec405360e4379466b7d91386f8) )
ROM_END

ROM_START( kof99s106 ) // kof99ndbc
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251s106.p1", 0x000000, 0x100000, CRC(cb5701ed) SHA1(81b5633cdc951bac576b7e0823fb1efeed1a4c88) )
	ROM_LOAD16_WORD_SWAP( "251bhp2.p2", 0x100000, 0x400000, CRC(23339a53) SHA1(e76564ae5464abf06235f813b70b38c492c2f7dc) )

	NEO_SFIX_128K( "251pb.s1", CRC(0b3d79d3) SHA1(2647c617c52d9955ee29520c416b59febfe7c0db) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251bhp2.c7", 0x3000000, 0x800000, CRC(a0fb0a24) SHA1(89b01efb4b5352efd3e1483e424e319d5a1f1451) )
	ROM_LOAD16_BYTE( "251bhp2.c8", 0x3000001, 0x800000, CRC(fbc1112c) SHA1(3f3789b8bbc335a4f9b66fc66a350767ec7bc32c) )
ROM_END

/* The King of Fighters '99 - Anniversary Edition.
   Unfortunately Yashional does not put revision dates in his games,
   so we've had to guess which roms to use.
   For the name, we go by the date on the zipfile (if provided). */
ROM_START( kof99s107 ) // kof99ae
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ae.p1", 0x000000, 0x100000, CRC(67f52d45) SHA1(cadf1c5c8c3e234204c8b32677f347e66d0373e5) )
	ROM_LOAD16_WORD_SWAP( "251ae.p2", 0x100000, 0x400000, CRC(67134a67) SHA1(c853f67ec66b0f01273c3ce1e1003262cbca0a60) )

	NEO_SFIX_128K( "251ae.s1", CRC(6243a70b) SHA1(452371f20e31c4d79022a128fc5335e951a6af1e) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1",  0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251ae.c1",   0x0000000, 0x800000, CRC(d0048356) SHA1(3a5a381f531751c8469d74b59e9e668d21cbc06b) )
	ROM_LOAD16_BYTE( "251ae.c2",   0x0000001, 0x800000, CRC(1d405bb0) SHA1(76c4b1d6e5ff0d5814b19203fbdd1f02d663de3e) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251ae.c9",   0x4000000, 0x800000, CRC(7d90d06d) SHA1(a72e91d689ef23b4bab43266c4360f663fc7836f) )
	ROM_LOAD16_BYTE( "251ae.c10",  0x4000001, 0x800000, CRC(3e2bf178) SHA1(e606e69595c0e9601c1dea142f0fcf77c2964347) )
	ROM_LOAD16_BYTE( "251ae.c11",  0x5000000, 0x800000, CRC(90016920) SHA1(6686e98a25d906131f73ed83c712096a6946c62e) )
	ROM_LOAD16_BYTE( "251ae.c12",  0x5000001, 0x800000, CRC(49cfed23) SHA1(63fa8682b86802967b36489c7483c59039f35aa5) )
ROM_END

ROM_START( kof99s108 ) // kof99ae20150520 - Anniversary Edition
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251aeoe.p1", 0x000000, 0x100000, CRC(149bd289) SHA1(c1818ce416c7036b8cc51d6ec752b2a612b7d2b1) )
	ROM_LOAD16_WORD_SWAP( "251aeoe.p2", 0x100000, 0x400000, CRC(86658d87) SHA1(d3d8a2f596b145a1bc98d65fcf3715d86b7a6dd6) )
	ROM_LOAD16_WORD_SWAP( "251aeoe.p3", 0x500000, 0x400000, CRC(e66a79c0) SHA1(a13bf66ceb15a4d42855c539a658427845c7d148) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251aex.c9",  0x4000000, 0x800000, CRC(f33d51d5) SHA1(b7d95afc0e85fec3c3279a766e22227cce91f3f4) )
	ROM_LOAD16_BYTE( "251aex.c10", 0x4000001, 0x800000, CRC(852770d7) SHA1(734520728d7e8162021fd1cc93f2fe2f8bd02e75) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s109 ) // kof99ae20150711 - Anniversary Edition
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251aeog.p1", 0x000000, 0x100000, CRC(78057e71) SHA1(f027654620c2490ef834713265deec1ada542e9b) )
	ROM_LOAD16_WORD_SWAP( "251aeog.p2", 0x100000, 0x800000, CRC(b7e50e35) SHA1(9706fe6bce816d75893ee8882eb4e9cd0590daac) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s110 ) // kof99ae20160411 - all confirmed
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251aepc.p1", 0x000000, 0x100000, CRC(5cbb24fd) SHA1(082bdbce405138ef08ccb274d48de2272494b62a) )
	ROM_LOAD16_WORD_SWAP( "251aepc.p2", 0x100000, 0x800000, CRC(55418995) SHA1(419258fc68ae35cde605cc3f89ff05d426299d27) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s111 ) // kof99ae20160419 - all confirmed
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251aepd.p1", 0x000000, 0x100000, CRC(c19447eb) SHA1(45c25eaaf1a03a5756e2df4a54abf2f7ebfab45a) )
	ROM_LOAD16_WORD_SWAP( "251aepc.p2", 0x100000, 0x800000, CRC(55418995) SHA1(419258fc68ae35cde605cc3f89ff05d426299d27) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s112 ) // kof99aes - all confirmed
	ROM_REGION( 0xd00000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251aes.p1", 0x000000, 0x100000, CRC(5dfe36ed) SHA1(d27a2abf3aa7e8a87faf55ff15e4b87905fa0061) )
	ROM_LOAD16_WORD_SWAP( "251aepc.p2", 0x100000, 0x800000, CRC(55418995) SHA1(419258fc68ae35cde605cc3f89ff05d426299d27) )
	ROM_LOAD16_WORD_SWAP( "251aes.p3", 0x900000, 0x400000, CRC(de66edce) SHA1(57d773552cfd22e6d301aa5350dd4d049ef247ac) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	NEO_SFIX_128K( "251aex.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251aex.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251aex.c1.bin", 0x000000, 0x800000, CRC(497c2e83) SHA1(379887e839dd4e33b41ab634a54789621bdfea98) )
	ROM_LOAD16_BYTE( "251aex.c2.bin", 0x000001, 0x800000, CRC(0a13eeb7) SHA1(2cb196a955a3472f922d0085cee2ddc0111fdbd3) )
	ROM_LOAD16_BYTE( "251d.c3",    0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",    0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",    0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",    0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ae.c7",   0x3000000, 0x800000, CRC(f22760ad) SHA1(a503898d9b6141c76f63b7c505ac78d3575530b2) )
	ROM_LOAD16_BYTE( "251ae.c8",   0x3000001, 0x800000, CRC(396c3a70) SHA1(6cd0acd05c138ac85ad63a04dfc015a3e70fa572) )
	ROM_LOAD16_BYTE( "251aeog.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251aeog.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251aex.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251aex.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s113 ) // kof99bh - Hack by Dodowang - (Can choose Krizalid and Krizalid' - have icons in character select menu)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ndh.p1",  0x000000, 0x100000, CRC(eedcc5bd) SHA1(8280c4329d666b4831c766853f5334355dc40cc9) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251bh.s1", CRC(b696a8c9) SHA1(3388feab11374a6eca6f1615fdfd93464f86dcee) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hhc04.c1", 0x0000000, 0x800000, CRC(9864655e) SHA1(9c543ae156aaca186fa8da2443358573c9e673be) )
	ROM_LOAD16_BYTE( "251hhc04.c2", 0x0000001, 0x800000, CRC(4cd81e02) SHA1(f3b9202a4997c039277800cdef69800c8f499ac4) )
	ROM_LOAD16_BYTE( "251hhc04.c3", 0x1000000, 0x800000, CRC(3fc352cb) SHA1(5dcf47e8b48214dc32653de8bacbf65fb90912e3) )
	ROM_LOAD16_BYTE( "251hhc04.c4", 0x1000001, 0x800000, CRC(a7668796) SHA1(682c1df0ff8e3ce9cbee8af87a213b26cb4f8b27) )
	ROM_LOAD16_BYTE( "251hhc04.c5", 0x2000000, 0x800000, CRC(5e82dc3f) SHA1(c113744685aa0c63bda088ebe9e2f8fae6feab3b) )
	ROM_LOAD16_BYTE( "251hhc04.c6", 0x2000001, 0x800000, CRC(fa5419ae) SHA1(92c9aa9c800c4d906f01a66c633319267b5a769b) )
	ROM_LOAD16_BYTE( "251hhc04.c7", 0x3000000, 0x800000, CRC(3733fd9d) SHA1(78678ec0841bdcbb37c66274ad73bc6e69fc3530) )
	ROM_LOAD16_BYTE( "251hhc04.c8", 0x3000001, 0x800000, CRC(947dedbc) SHA1(186a75b8c43aa2733404a5763c8c90d5265ab751) )
ROM_END

ROM_START( kof99s114 ) // kof99bhp2 - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251bhp2.p1", 0x000000, 0x100000, CRC(a4deff9a) SHA1(a445cd48bc0a8b386cd232bcc5b0d82c9d757c6d) )
	ROM_LOAD16_WORD_SWAP( "251bhp2.p2", 0x100000, 0x400000, CRC(23339a53) SHA1(e76564ae5464abf06235f813b70b38c492c2f7dc) )

	NEO_SFIX_128K( "251pb.s1", CRC(0b3d79d3) SHA1(2647c617c52d9955ee29520c416b59febfe7c0db) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251bhp2.c7", 0x3000000, 0x800000, CRC(a0fb0a24) SHA1(89b01efb4b5352efd3e1483e424e319d5a1f1451) )
	ROM_LOAD16_BYTE( "251bhp2.c8", 0x3000001, 0x800000, CRC(fbc1112c) SHA1(3f3789b8bbc335a4f9b66fc66a350767ec7bc32c) )
ROM_END

ROM_START( kof99s115 ) // kof99bhs
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251bhs.p1",  0x000000, 0x100000, CRC(c2d1b2fc) SHA1(016f168e5d657abbfb1b81389b1b1613a225d1ad) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251bh.s1", CRC(b696a8c9) SHA1(3388feab11374a6eca6f1615fdfd93464f86dcee) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s116 ) // kof99bs2 - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251bs2.p1", 0x000000, 0x100000, CRC(3adcedbb) SHA1(ce21a4d981354303031fee17e8db9f9961ebe5c9) )
	ROM_LOAD16_WORD_SWAP( "251bs2.p2", 0x100000, 0x400000, CRC(62b11826) SHA1(13113692b43c3d1b5c8572d2024777e6a1a15e2b) )

	NEO_SFIX_128K( "251bs.s1", CRC(697c1f85) SHA1(117d12908b060db62716a8ac8a155c8303287746) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251bs2.c1", 0x0000000, 0x800000, CRC(598cc558) SHA1(451d3f9fadb1810e383057591c46b736b6f595cb) )
	ROM_LOAD16_BYTE( "251bs2.c2", 0x0000001, 0x800000, CRC(5b4c297b) SHA1(147342a115b0237d1cb55eceae093a7ee4a3c438) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251bs2.c7", 0x3000000, 0x800000, CRC(3ac342ad) SHA1(325d0c407129a2cbf30c52e5317bbeb8fc056448) )
	ROM_LOAD16_BYTE( "251bs2.c8", 0x3000001, 0x800000, CRC(500aea52) SHA1(a0c03d1c27c0f5013aff713b53e4e61bc76ff748) )
ROM_END

ROM_START( kof99s117 ) // kof99ch - Remix by Chase - (Character move change)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ch.p1",   0x000000, 0x100000, CRC(6efd349b) SHA1(f876df9137801125b8f142102d4165295607ba02) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s118 ) // kof99chf - Remix by Chase - (Character move change - fixed)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251chf.p1",  0x000000, 0x100000, CRC(34387e01) SHA1(cc56d936d931d793a7d02dddf4a4521ed09e1e52) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s119 ) // kof99co - combo
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251co.p1", 0x000000, 0x100000, CRC(99242c0c) SHA1(11d9d52783e4958a53f12469a75a784846d7ba49) )
	ROM_LOAD16_WORD_SWAP( "251co.p2", 0x100000, 0x400000, CRC(c3ddba7b) SHA1(1890a3cbf33b76d532b4d31eb602698dbff840ea) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251co.s1", CRC(6c36e84f) SHA1(80052ce8e9f09c4e2f7edf5c6423f3b5588eb33b) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s120 ) // kof99co2 - combo
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251co2.p1", 0x000000, 0x100000, CRC(857276bd) SHA1(722ab77fea24a0db8691e64c4c3ed098d1dc5360) )
	ROM_LOAD16_WORD_SWAP( "251co2.p2", 0x100000, 0x400000, CRC(c79df28d) SHA1(352edc22d5b5ecb84748cb703135de5c2a7a0032) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251co2.s1", CRC(10b87e35) SHA1(f466e9b3ecc7b14cde42a767c3fac73a9eed282b) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251ks03.c1", 0x0000000, 0x800000, CRC(159e0d25) SHA1(f92cc1351aa9c1ee2fd4f0565e3c4cf74e19cc26) )
	ROM_LOAD16_BYTE( "251ks03.c2", 0x0000001, 0x800000, CRC(b15e6d91) SHA1(4a861de5c5f35318de8c4f09e2836ea063ee7e51) )
	ROM_LOAD16_BYTE( "251ks03.c3", 0x1000000, 0x800000, CRC(7342c91d) SHA1(ed3bbb6342e1e1556473df13c803789f9caccf62) )
	ROM_LOAD16_BYTE( "251ks03.c4", 0x1000001, 0x800000, CRC(d0af0ea2) SHA1(a3950b62cec276fa4d362b61a57cbf9f5fa745c2) )
	ROM_LOAD16_BYTE( "251ks03.c5", 0x2000000, 0x800000, CRC(a99c2167) SHA1(21c6578de6e6bfeadb24c4de32fb3e2fc578c745) )
	ROM_LOAD16_BYTE( "251ks03.c6", 0x2000001, 0x800000, CRC(00290083) SHA1(4190738ab5e153458965dcc9d65146fd2e568a50) )
	ROM_LOAD16_BYTE( "251ks03.c7", 0x3000000, 0x800000, CRC(483420ec) SHA1(6649ff6221e7b14adaff77b4df56151f601cce0d) )
	ROM_LOAD16_BYTE( "251ks03.c8", 0x3000001, 0x800000, CRC(5195dd28) SHA1(b35db15458e08be14ca8c8f33478d16272ea7374) )
ROM_END

ROM_START( kof99s121 ) // kof99d
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "kc.neo-sma", 0x0c0000, 0x040000, CRC(6c9d0647) SHA1(2a0ce62ca6c18007e8fbe1b60475c7874ab79389) )
	ROM_LOAD16_WORD_SWAP( "251.p1",  0x100000, 0x400000, CRC(006e4532) SHA1(47791ab4044ad55988b1d3412d95b65b91a163c8) )
	ROM_LOAD16_WORD_SWAP( "251-pg2.p2", 0x500000, 0x400000, CRC(d9057f51) SHA1(8d365b4dd40351495df99d6c765df1434b0b0548) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s122 ) // kof99eh - Enhance by Ydmis - (Can choose Krizalid, Krizalid', Kyo and Iori - ultra kill start is max)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eh.p1",   0x000000, 0x100000, CRC(93f05c57) SHA1(e92e18e0572ae313952b2416c76d06c86202f755) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251eh.s1", CRC(46803457) SHA1(685f0b5afd0d9904f6c8fa6052e127297e3d63d4) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s123 ) // kof99ehr - Remix by Raymonose - (Can choose Krizalid, Krizalid', Kyo and Iori - ultra kill start is max - ultra power hack)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ehr.p1",  0x000000, 0x100000, CRC(08dfc6cb) SHA1(5f3fed5e1c598c580aa33b66aeb92d5d95d2b2e6) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s124 ) // kof99eur
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eur.p1", 0x000000, 0x100000, CRC(66fa20fd) SHA1(6fbda6db41558e4d7a073c7d5fc568f7cc57df2d) )
	ROM_LOAD16_WORD_SWAP( "251eur.p2", 0x100000, 0x400000, CRC(aec93904) SHA1(9270e1a920c6f99dc2b716fc1d3536ce7783cd74) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1",  0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s125 ) // kof99eur1
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eur1.p1", 0x000000, 0x100000, CRC(a10ddd49) SHA1(0d524db74f414d2ac5694b9f0fd8a39e1bc41322) )
	ROM_LOAD16_WORD_SWAP( "251eur1.p2", 0x100000, 0x400000, CRC(cbb73011) SHA1(984a0581a146bde46834ea3672c6003c5eb4539a) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251eur1.s1", CRC(f0c559ea) SHA1(43f7409fa56a851e621d42d76c7be440427c6ad3) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur1.c7", 0x3000000, 0x800000, CRC(295e8e9c) SHA1(26c6df1ec94b0c524b2477223b645dc797e1e198) )
	ROM_LOAD16_BYTE( "251eur1.c8", 0x3000001, 0x800000, CRC(638614a6) SHA1(8a9d8fee7272e13eb500faefc5125ed0844acf07) )
ROM_END

ROM_START( kof99s126 ) // kof99eur2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eur2.p1", 0x000000, 0x100000, CRC(df07d4f6) SHA1(b14c6449bffcb3b6719408e5ea48a18b43536f64) )
	ROM_LOAD16_WORD_SWAP( "251eur2.p2", 0x100000, 0x400000, CRC(4b6fdd2b) SHA1(2321c4e0f8da21fc47b3db782c50598810ebae9a) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251sr.s1", CRC(08055c7a) SHA1(682e0084e62b547482929babe828027fdd64cde0) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur2.c7", 0x3000000, 0x800000, CRC(52da5196) SHA1(956fc48d62f397c45b576f08003c1360ecd7f9ed) )
	ROM_LOAD16_BYTE( "251eur2.c8", 0x3000001, 0x800000, CRC(f5276981) SHA1(0a70429be7a8488f73b4f2d071ccfe9c24c9cdb4) )
ROM_END

ROM_START( kof99s127 ) // kof99eur3
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eur3.p1", 0x000000, 0x100000, CRC(31ebbcd6) SHA1(236dc2b5b53bbde0e0fb3fe5101341dd1ffee1cd) )
	ROM_LOAD16_WORD_SWAP( "251eur3.p2", 0x100000, 0x400000, CRC(b777285d) SHA1(ed613324ded46983dd3a40bd3f00c34b37166c31) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251eur.s1", CRC(a6747969) SHA1(6577c00aceb0d612819c703b3334ebb6c760e126) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1",  0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2",  0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s128 ) //  // kof99eur4 - multijet kof99eur
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251eur4.p1", 0x000000, 0x100000, CRC(327b963c) SHA1(c6a61f2d1ab7339d6b56d5f88575c4d8e1b8f261) )
	ROM_LOAD16_WORD_SWAP( "251eur4.p2", 0x100000, 0x400000, CRC(09d34c25) SHA1(40de394d28b86b63382226cc8943e06740d0eaf5) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251eur1.s1", CRC(f0c559ea) SHA1(43f7409fa56a851e621d42d76c7be440427c6ad3) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251eur2.c7", 0x3000000, 0x800000, CRC(52da5196) SHA1(956fc48d62f397c45b576f08003c1360ecd7f9ed) )
	ROM_LOAD16_BYTE( "251eur2.c8", 0x3000001, 0x800000, CRC(f5276981) SHA1(0a70429be7a8488f73b4f2d071ccfe9c24c9cdb4) )
ROM_END

ROM_START( kof99s129 ) // kof99ev2 - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ev2.p1", 0x000000, 0x100000, CRC(e97d9d67) SHA1(bcb77706868757de09c74a0af664747e7e8c412a) )
	ROM_LOAD16_WORD_SWAP( "251ev2.p2", 0x100000, 0x400000, CRC(947241fa) SHA1(66aac76cfe54e7aa874bb2b2e10de2eee2952400) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s130 ) // kof99evo
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251evo.p1",  0x000000, 0x100000, CRC(18960f8b) SHA1(41dae74f7d429873946752b28527655466dd38c9) )
	ROM_LOAD16_WORD_SWAP( "251evo.p2",  0x100000, 0x400000, CRC(c6431b4a) SHA1(cd30903f200428b9ea6901aab1bd7fdd1672713f) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251wet.m1", CRC(8c96b012) SHA1(8ae72cd0d88c742791b1f1f1d2af2253bf4f762d) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s131 ) // kof99fc - Remix Pro200 Final - FCHT
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251fc.p1", 0x000000, 0x100000, CRC(6d3d14c4) SHA1(f40784505b82f59d289ce45e3de8f7fb8e87069b) )
	ROM_LOAD16_WORD_SWAP( "251fc.p2", 0x100000, 0x400000, CRC(01e111b3) SHA1(4ae2fbd552246779146684d2191a7bc9a3554c59) )

	NEO_SFIX_128K( "251fc.s1", CRC(ca942904) SHA1(f84b79282bb2de61d24faacca1feda0187e42dcd) )

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251fc.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251fc.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251fc.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251fc.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251fc.c7", 0x3000000, 0x800000, CRC(1dfd5103) SHA1(edbe56d9434abdff58e7e9ceed7ea3d7975c40d2) )
	ROM_LOAD16_BYTE( "251fc.c8", 0x3000001, 0x800000, CRC(23fe3c43) SHA1(b601a14cd023b28f8e8eed8afd6a05d2c3df115a) )
ROM_END

ROM_START( kof99s132 ) // kof99fc1
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251fc1.p1", 0x000000, 0x100000, CRC(48b8641d) SHA1(cb8e9992762d00cdb04f019398975d8d3b0cf1eb) )
	ROM_LOAD16_WORD_SWAP( "251fc1.p2", 0x100000, 0x400000, CRC(143a7080) SHA1(29007713d2f1298e890d82d8a11c5700a6e680e6) )

	NEO_SFIX_128K( "251fc.s1", CRC(ca942904) SHA1(f84b79282bb2de61d24faacca1feda0187e42dcd) )

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251fc.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251fc.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251fc.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251fc.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251fc.c7", 0x3000000, 0x800000, CRC(1dfd5103) SHA1(edbe56d9434abdff58e7e9ceed7ea3d7975c40d2) )
	ROM_LOAD16_BYTE( "251fc.c8", 0x3000001, 0x800000, CRC(23fe3c43) SHA1(b601a14cd023b28f8e8eed8afd6a05d2c3df115a) )
ROM_END

ROM_START( kof99s133 ) // kof99fc2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251fc2.p1", 0x000000, 0x100000, CRC(7f14f664) SHA1(0f17b6fbe919b78f63de4e10fc95c6e7e688206d) )
	ROM_LOAD16_WORD_SWAP( "251fc.p2", 0x100000, 0x400000, CRC(01e111b3) SHA1(4ae2fbd552246779146684d2191a7bc9a3554c59) )

	NEO_SFIX_128K( "251fc.s1", CRC(ca942904) SHA1(f84b79282bb2de61d24faacca1feda0187e42dcd) )

	NEO_BIOS_AUDIO_128K( "251fc.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251fc.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251fc.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251fc.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251fc.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251fc.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251fc.c7", 0x3000000, 0x800000, CRC(1dfd5103) SHA1(edbe56d9434abdff58e7e9ceed7ea3d7975c40d2) )
	ROM_LOAD16_BYTE( "251fc.c8", 0x3000001, 0x800000, CRC(23fe3c43) SHA1(b601a14cd023b28f8e8eed8afd6a05d2c3df115a) )
ROM_END

ROM_START( kof99s134 ) // kof99jh - Hack by Jason/K3 - (Simple move revision - Athena style change - can choose Krizalid - can choose Kyo and Iori in MVS mode 20031018)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251jh.p1",   0x000000, 0x100000, CRC(855936ca) SHA1(bf788fa7c49cf3365e1e859df3811a5ca0ff69cc) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s135 ) // kof99jho - [OLD] Hack by Jason/K3 - (Simple move revision - Athena style change - can choose Krizalid - can choose Kyo and Iori in MVS mode 20030924)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251jho.p1",  0x000000, 0x100000, CRC(690ea82d) SHA1(2938738e57514a672c79abe1d3696c51f9fdc04d) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s136 ) // kof99lb - Hack by lb70
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251lb.p1", 0x000000, 0x100000, CRC(38d49ceb) SHA1(474e5bca53cfb78727fbe17577fbd7f710b78c9b) )
	ROM_LOAD16_WORD_SWAP( "251lb.p2", 0x100000, 0x400000, CRC(095524ce) SHA1(59009b5f74d0c02f85bf2e59f2833d65863ba8c3) )

	NEO_SFIX_128K( "251bh.s1", CRC(b696a8c9) SHA1(3388feab11374a6eca6f1615fdfd93464f86dcee) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251lb.c7", 0x3000000, 0x800000, CRC(c5a4d2e6) SHA1(ca0e8b45b126bc091242ad62c846c1b2a685b396) )
	ROM_LOAD16_BYTE( "251lb.c8", 0x3000001, 0x800000, CRC(7160d0dd) SHA1(37a3fb72a32bcfdd2ba3ae7a957c4b3ba593b528) )
ROM_END

ROM_START( kof99s137 ) // kof99m - Hack by MasakiAnton - (Can choose Krizalid and Krizalid')
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251m.p1",    0x000000, 0x100000, CRC(e056b767) SHA1(86cc38fa6158aa6b72fe0cb74a43f98ef4b285c6) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s138 ) // kof99nd
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1", 0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s139 ) // kof99ndis - all complete
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ndis.p1", 0x000000, 0x4550f6, CRC(0ca863be) SHA1(4da27476f81fd1d10ff2ba8fc7d12b662804cc5d) )
	ROM_LOAD16_WORD_SWAP( "251ndis.p2", 0x100000, 0x400000, CRC(c012ff9f) SHA1(ef53386e34464eaaed1fcba3d4d1dcfb269f995c) )

	NEO_SFIX_128K( "251ndis.s1", CRC(16edaa55) SHA1(d8601a14c703e56c0635e2f7540492b164447d6b) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s140 ) // kof99ndkt
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ndkt.p1", 0x000000, 0x100000, CRC(b98c12c5) SHA1(91ca79201cc1bf6faaa909039511a5db7f347c8a) )
	ROM_LOAD16_WORD_SWAP( "251ndkt.p2", 0x100000, 0x400000, CRC(d87f8748) SHA1(1e5f1c3327d1ffe50b393ccdae81e10f9dd1c605) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_JAPAN_BIOS_AUDIO(0x20000, "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251ndkt.c1",  0x0000000, 0x800000, CRC(4a400a35) SHA1(bf4fabb061e7775b78589f791ec96c85190ee8a1) )
	ROM_LOAD16_BYTE( "251ndkt.c2",  0x0000001, 0x800000, CRC(de7e7c17) SHA1(9a07b06033a655dbe7c54e7d4b216c313676df30) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s141 ) // kof99nevo - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251nevo.p1", 0x000000, 0x100000, CRC(1afba5f1) SHA1(646c04030f85e1b1e06d830379f6c9b6b3bca505) )
	ROM_LOAD16_WORD_SWAP( "251nevo.p2", 0x100000, 0x400000, CRC(7f86d784) SHA1(a2ca66b5f04ed9855c6fff8d5b1e9c426df8aa3d) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251wet.m1", CRC(8c96b012) SHA1(8ae72cd0d88c742791b1f1f1d2af2253bf4f762d) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s142 ) // kof99ob
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ob.p1", 0x000000, 0x100000, CRC(b6147b23) SHA1(921dad6a2f1011ad67a82a6f9874b30658f233b0) )
	ROM_LOAD16_WORD_SWAP( "251ob.p2", 0x100000, 0x400000, CRC(f88a4970) SHA1(6cce092f0d60aff7c0fcad796e9604cdf440219f) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251ob.m1", CRC(151c7a8d) SHA1(ccf557d1818edb579aa72e05f494305e5449d5ee) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ob.v1",  0x000000, 0x400000, CRC(33d2e8b4) SHA1(f1ff9facc59eadc257edc06ba6bb3dddf27cfae2) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ob.c7", 0x3000000, 0x800000, CRC(f3b25375) SHA1(80d6b06adce5190bb71f2f0233db60008a33c51e) )
	ROM_LOAD16_BYTE( "251ob.c8", 0x3000001, 0x800000, CRC(d2d0041a) SHA1(02283e2ac22e2f0521c3b2d126aff624ac820b63) )
ROM_END

ROM_START( kof99s143 ) // kof99ob2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ob2.p1", 0x000000, 0x100000, CRC(13f57712) SHA1(d08cc331049950d19e59a6016a2dcd8cdc733a14) )
	ROM_LOAD16_WORD_SWAP( "251ob2.p2", 0x100000, 0x400000, CRC(7a747b84) SHA1(dd38867d055d51465630254dcff32e9fdc9f523e) )

	NEO_SFIX_128K( "251sr.s1", CRC(08055c7a) SHA1(682e0084e62b547482929babe828027fdd64cde0) )

	NEO_BIOS_AUDIO_128K( "251ob.m1", CRC(151c7a8d) SHA1(ccf557d1818edb579aa72e05f494305e5449d5ee) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ob.v1",  0x000000, 0x400000, CRC(33d2e8b4) SHA1(f1ff9facc59eadc257edc06ba6bb3dddf27cfae2) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251ob2.c7",  0x3000000, 0x800000, CRC(b9123865) SHA1(1f99321a2695a8be372c27bd012b5d476fbef318) )
	ROM_LOAD16_BYTE( "251ob2.c8",  0x3000001, 0x800000, CRC(f34606e5) SHA1(7ba4b28afda82383361e935dd83dc9d158fc2e5e) )
ROM_END

ROM_START( kof99s144 ) // kof99pb
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251pb.p1", 0x000000, 0x100000, CRC(1cdf4d3e) SHA1(2019ffe300651d9faabc65e53e95d4dc98bba6bf) )
	ROM_LOAD16_WORD_SWAP( "251pb.p2", 0x100000, 0x400000, CRC(e0a0100a) SHA1(21a723818faa1bfbeff850caa1837f1ad566adda) )

	NEO_SFIX_128K( "251pb.s1", CRC(0b3d79d3) SHA1(2647c617c52d9955ee29520c416b59febfe7c0db) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251pb.c7", 0x3000000, 0x800000, CRC(65c896fb) SHA1(7d673bca1b38438f7ceb7aab26fe2beb452c74e7) )
	ROM_LOAD16_BYTE( "251pb.c8", 0x3000001, 0x800000, CRC(6db9afe1) SHA1(beeed20292320e2a742d31c2a3ad05ffeb0d6f61) )
ROM_END

ROM_START( kof99s145 ) // kof99pjc1 - Colour fix by TcwLee - (Character colour change revision 1 200209xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1", 0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251pjc1.p2", 0x100000, 0x400000, CRC(79aa31b0) SHA1(04a15e211b4453cb4e249f8cbd175ce09136d92a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s146 ) // kof99pjc2 - Colour fix by TcwLee - (Character colour change revision 2 20030302)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1", 0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251pjc2.p2", 0x100000, 0x400000, CRC(024c5b3f) SHA1(e52b9035c5853027b37534c97872fdd1dd0a2791) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s147 ) // kof99pjc3 (kof99pjcr3) - Colour fix by TcwLee - (Character colour change revision 3 20030720)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1", 0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251pjc3.p2", 0x100000, 0x400000, CRC(8054a5d5) SHA1(b240d427baf1c68cdc4ce2ab9e8d93471afa701a) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s148 ) // kof99pjco - Colour fix by TcwLee - (Character colour change)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1",  0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251pjco.p2", 0x100000, 0x400000, CRC(4b08d6b3) SHA1(481b740bde2141abbdc6c516d27564d9ffa03662) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s149 ) // kof99pt - Hack by Creamymami - (Ultra kill hack)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251pt.p1", 0x000000, 0x100000, CRC(c14497cc) SHA1(ce275b3c146b48b40ded3a7754c71b722d6eab67) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s150 ) // kof99r - Hack by Raymonose - (General character move change 200310xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251r.p1", 0x000000, 0x100000, CRC(7374f261) SHA1(1277e33d4ae4e40b0dbb49c9ac156cd132b6d890) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s151 ) // kof99rd - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251b.p1", 0x000000, 0x100000, CRC(f2c7ddfa) SHA1(d592eecc53d442c55c2f26a6a721fdf2924d2a5b) )
	ROM_LOAD16_WORD_SWAP( "251rd.p2",  0x100000, 0x400000, CRC(316672c6) SHA1(a8738e8ee3f4618e313a978f831483bb45329c04) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s152 ) // kof99rev - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rev.p1", 0x000000, 0x100000, CRC(b53286e7) SHA1(f0d143f21a679943caa6b94645210fd4c332c1eb) )
	ROM_LOAD16_WORD_SWAP( "251rev.p2", 0x100000, 0x400000, CRC(7a7dcf34) SHA1(df424b6b44f007721bb1cf3fee00f4bedb5a63e6) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s153 ) // kof99roll
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251roll.p1", 0x000000, 0x100000, CRC(4afaaadc) SHA1(afb68252a57f4e67aadf7a9eb1b289d1e5d3dc8a) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s154 ) // kof99rp - KOF Remix PRO by FCHT - (Character move change v1.07a 20041224)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp.p1", 0x000000, 0x100000, CRC(5806CDD2) SHA1(279A8181374ECF77DA4605D1CBE1152324784B97) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2", 0x100000, 0x400000, CRC(C923EE2B) SHA1(98B4F40812D5479F7D6E683E5EF4002F4C86785C) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s155 ) // kof99rp0
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp0.p1", 0x000000, 0x100000, CRC(0570df7e) SHA1(f6a66cf39e8aff68b2962115aa65c79ca222cc74) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2",  0x100000, 0x400000, CRC(c923ee2b) SHA1(98b4f40812d5479f7d6e683e5ef4002f4c86785c) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s156 ) // kof99rp1 - [OLD]KOF Remix PRO by FCHT - (Character move change v1.02 final1 20031010)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp1.p1", 0x000000, 0x100000, CRC(c21d1580) SHA1(a81380d9f2e66036f92e02fe5b3b54741f2e59fc) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2",  0x100000, 0x400000, CRC(C923EE2B) SHA1(98B4F40812D5479F7D6E683E5EF4002F4C86785C) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s157 ) // kof99rp2 - [OLD][BETA](kof99rp101c-b) - Remix PRO by FCHT - (Remix pro 1.01c by FCHT Built 0309h 200309xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp2.p1",  0x000000, 0x100000, CRC(07c52235) SHA1(2ca600d7c0d4bf2780c1313f31e23ec767d1f636) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s158 ) // kof99rp3 - [OLD][BETA](kof99rp101b-b) - Remix PRO by FCHT - (Remix pro 1.01b by FCHT Built 0309e 200309xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp3.p1",  0x000000, 0x100000, CRC(7e2da123) SHA1(4a5275ccce118244fb02416ef1cca72b71a55b1a) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s159 ) // kof99rp4 - [OLD][BETA](kof99rp101a2-b) - Remix PRO by FCHT - (Remix pro 1.01a2 by FCHT 200309xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp4.p1",  0x000000, 0x100000, CRC(0758dfef) SHA1(3a3254a2dcb073da00351921291fb9595a504a3c) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s160 ) // kof99rp5 - [OLD][BETA](kof99rp101a-b) - Remix PRO by FCHT - (Remix pro 1.01a by FCHT 200309xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp5.p1", 0x000000, 0x100000, CRC(b00aa815) SHA1(bf199a9977d542b38d953cf9c9347e22f8c31fbb) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s161 ) // kof99rp6 - [OLD][BETA](kof99rp101-b) - Remix PRO by FCHT - (Remix pro 1.01 by FCHT Built 0308b 200309xx)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp6.p1",  0x000000, 0x100000, CRC(9c3308e7) SHA1(e443a8bd184f6fc49f9d288b2884d95a5c7bca63) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s162 ) // kof99rp7 - [OLD][BETA](kof99rpcex-b) - Remix PRO by FCHT - (Remix pro 1.00c by FCHT Built 0308e EX-Version)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp7.p1",  0x000000, 0x100000, CRC(da91f15c) SHA1(64e2b0bc6592b5ca148ccec9f4ccfa0d6ac4aaf7) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s163 ) // kof99rp8 - [OLD][BETA](kof99rpc-b) - Remix PRO by FCHT - (Remix pro 1.00c by FCHT Built 0308e)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp8.p1",  0x000000, 0x100000, CRC(55d97c9a) SHA1(35b176cc4005c07478df1dc99fe40344210e690b) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s164 ) // kof99rp9 - [OLD][BETA](kof99rse-b) - Remix PRO by FCHT - (Remix pro 1.00b by FCHT - Enhance)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rp9.p1",  0x000000, 0x100000, CRC(9ef748b0) SHA1(8f2cccc36d2ce019f8d0e69dec267240978bef4e) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s165 ) // kof99rpa - [OLD][BETA](kof99rps-b) - Remix PRO by FCHT - (Remix pro 1.00b by FCHT)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rpa.p1",  0x000000, 0x100000, CRC(e390960c) SHA1(992f9ca6bffb34d589287ed1ab3c7a53d5940078) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s166 ) // kof99rpb - [OLD][BETA](kof99rpe-b) - Remix PRO by FCHT - (Remix pro 1.00a by FCHT - Enhance)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rpb.p1",  0x000000, 0x100000, CRC(69f172ce) SHA1(c40f72d58331cd416154eef6f58d5398effe75ef) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s167 ) // kof99rpc - [OLD][BETA](kof99rp-b) - Remix PRO by FCHT - (Remix pro 1.00a by FCHT)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rpc.p1",  0x000000, 0x100000, CRC(1496ac72) SHA1(60b4cb55ad8cfa27342b489fd2b53c5d41feea18) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s168 ) // kof99rpp - [OLD] - KOF Remix PRO PLUS by FCHT - (Character move change v1.02 FINAL PRO PLUS 20040327)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rpp.p1", 0x000000, 0x100000, CRC(f954fc44) SHA1(654d1252dec3dfcf3fd3b8b19689bc68cd221e39) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2",  0x100000, 0x400000, CRC(C923EE2B) SHA1(98B4F40812D5479F7D6E683E5EF4002F4C86785C) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251hsx05.c1", 0x0000000, 0x800000, CRC(45fe3ba8) SHA1(760f0a7464a01b046cfd7392f19558d1a8bb0520) )
	ROM_LOAD16_BYTE( "251hsx05.c2", 0x0000001, 0x800000, CRC(a2f03bee) SHA1(78808dc790c4a8f928a399d1d34a122184a374d5) )
	ROM_LOAD16_BYTE( "251hsx05.c3", 0x1000000, 0x800000, CRC(b283cea5) SHA1(6c41550d175f01df6861599a37f1ffbe98d0eb1e) )
	ROM_LOAD16_BYTE( "251hsx05.c4", 0x1000001, 0x800000, CRC(4420f15e) SHA1(27c149000fcb0948a18d3ab18a5e3993bd47909f) )
	ROM_LOAD16_BYTE( "251hsx05.c5", 0x2000000, 0x800000, CRC(3935b688) SHA1(6a50565924b4aa4b8f627b2d74374ed15855b0bc) )
	ROM_LOAD16_BYTE( "251hsx05.c6", 0x2000001, 0x800000, CRC(49ac9349) SHA1(197bd9ed9ce2b144d65bb8482444bb7caee1684c) )
	ROM_LOAD16_BYTE( "251hsx05.c7", 0x3000000, 0x800000, CRC(a6f29098) SHA1(b57ef7c311dea25b6ae4192e4bed4b56778f13a8) )
	ROM_LOAD16_BYTE( "251hsx05.c8", 0x3000001, 0x800000, CRC(666b81a4) SHA1(4b35a00b8e39379d5922787db02970c62e478a8d) )
ROM_END

ROM_START( kof99s169 ) // kof99rr - Remix by Raymonose - (Character move change)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251rr.p1",   0x000000, 0x100000, CRC(fd7399b5) SHA1(bac6892fec986942bb02c00fe96d00fc11a0ddda) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s170 ) // kof99seh - Super Enhance Hack by Creamymami and Ydmis - (Can choose Krizalid, Krizalid', Kyo and Iori - ultra power hack - ultra kill start is max)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251seh.p1",  0x000000, 0x100000, CRC(3dd574cf) SHA1(9005041b52e196639f70675abbc8949f3f52e6af) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s171 ) // kof99spd - multijet
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "kc.neo-sma", 0x0c0000, 0x040000, CRC(6c9d0647) SHA1(2a0ce62ca6c18007e8fbe1b60475c7874ab79389) )
	ROM_LOAD16_WORD_SWAP( "251spd.p1",  0x100000, 0x400000, CRC(11b8a2b5) SHA1(89f95746b76b4f730080921292970898dc296051) )
	ROM_LOAD16_WORD_SWAP( "251-pg2.p2", 0x500000, 0x400000, CRC(d9057f51) SHA1(8d365b4dd40351495df99d6c765df1434b0b0548) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s172 ) // kof99sr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251sr.p1", 0x000000, 0x100000, CRC(b96da0bf) SHA1(260b8fd7888b54f5f61fa07175dacd1743f1c6bb) )
	ROM_LOAD16_WORD_SWAP( "251sr.p2", 0x100000, 0x400000, CRC(9f1d1660) SHA1(d23466a5aac70c69d10c6bec59f019419940d914) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251srj.s1", CRC(c16fbccc) SHA1(ab019608617ba4868673e35836261c9557ac74f2) )
	ROM_IGNORE(0x0D01C0)
	//NEO_SFIX_128K( "251sr.s1", CRC(08055c7a) SHA1(682e0084e62b547482929babe828027fdd64cde0) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251sr.c7",  0x3000000, 0x800000, CRC(65de862c) SHA1(83c0446f19ca567cd7664956f617f4f7625422b7) )
	ROM_LOAD16_BYTE( "251sr.c8",  0x3000001, 0x800000, CRC(3ff457fe) SHA1(1838de77ceaf78cb75604f227ffdf59311c0bbe5) )
ROM_END

ROM_START( kof99s173 ) // kof99srr - Remix by Raymonose - (Character move change) Super Remix Red
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251srr.p1", 0x000000, 0x100000, CRC(c7cd6ffe) SHA1(f0130b9bd80b4b9d452f53fac85853d9fa563144) )
	ROM_LOAD16_WORD_SWAP( "251srr.p2", 0x100000, 0x400000, CRC(a7f4ed1d) SHA1(5f3024c66370c8b4be3a1b7bbe7225574c19fc4c) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s174 ) // kof99srr1 - multijet kof99srr
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251srr.p1", 0x000000, 0x100000, CRC(c7cd6ffe) SHA1(f0130b9bd80b4b9d452f53fac85853d9fa563144) )
	ROM_LOAD16_WORD_SWAP( "251rd.p2", 0x100000, 0x400000, CRC(316672c6) SHA1(a8738e8ee3f4618e313a978f831483bb45329c04) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s175 ) // kof99t
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251t.p1", 0x000000, 0x100000, CRC(b89ba128) SHA1(112bda6df0c6e6c6922865fe896fea063668483b) )
	ROM_LOAD16_WORD_SWAP( "251t.p2", 0x100000, 0x400000, CRC(f767394c) SHA1(d1b0b37035b7aecf42c0334de18728b3fe338fae) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s176 ) // kof99the4
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251the4.p1", 0x000000, 0x100000, CRC(6055c72c) SHA1(45089a3e17e6476113f2c471632b3029b3344743) )
	ROM_LOAD16_WORD_SWAP( "251the4.p2", 0x100000, 0x400000, CRC(62757ec3) SHA1(ad1d1f5b341e08ebb17a247c42b3e28dde989f12) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s177 ) // kof99the42
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251the42.p1", 0x000000, 0x100000, CRC(d7d0b651) SHA1(de739b9f9ba5816a12ce7936d3f285d3ec8fc1f7) )
	ROM_LOAD16_WORD_SWAP( "251the4.p2", 0x100000, 0x400000, CRC(62757ec3) SHA1(ad1d1f5b341e08ebb17a247c42b3e28dde989f12) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s178 ) // kof99vor - all confirmed
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "vor.ka.neo-sma", 0x0c0000, 0x040000, CRC(ca267237) SHA1(9f7c3fbef8e9ae3a9e8990b93589b1d3325468f5) )
	ROM_LOAD16_WORD_SWAP( "251vor.p1",  0x100000, 0x400000, CRC(a466e66d) SHA1(41653d6ca325d084cda851fecb677976f469978a) )
	ROM_LOAD16_WORD_SWAP( "251vor.p2",  0x500000, 0x400000, CRC(2bf8ac94) SHA1(d6a9a9740819b91d01990ab999f41eef84361760) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251vor.c1",   0x0000000, 0x800000, CRC(4b3b9454) SHA1(ee0178c9f90d43c704450ef3e39861826e9d3dad) )
	ROM_LOAD16_BYTE( "251vor.c2",   0x0000001, 0x800000, CRC(74f028c4) SHA1(2d1e1768a5d842292c5367c861e093f6cae02379) )
	ROM_LOAD16_BYTE( "251vor.c3",   0x1000000, 0x800000, CRC(51ecbae7) SHA1(2cf2e2ae3856a7e5d77af7f97d9dc3532d396b27) )
	ROM_LOAD16_BYTE( "251vor.c4",   0x1000001, 0x800000, CRC(96c0594b) SHA1(503844cc4c937caa6fe4a0a76f13cc6fbb47e94f) )
	ROM_LOAD16_BYTE( "251vor.c5",   0x2000000, 0x800000, CRC(8875aee9) SHA1(29e79c3a2f40ddcdd2d5432e37c5629cbbecd37f) )
	ROM_LOAD16_BYTE( "251vor.c6",   0x2000001, 0x800000, CRC(585786b7) SHA1(acfb462d467e914f165f67b8cc2be56937c0feaa) )
	ROM_LOAD16_BYTE( "251vor.c7",   0x3000000, 0x800000, CRC(a25152d1) SHA1(bb1dc7d5bff9a599e7ed234abd199c26d8103bbd) )
	ROM_LOAD16_BYTE( "251vor.c8",   0x3000001, 0x800000, CRC(2d8a1014) SHA1(dc729bc19b775bb62301d7f98cc9566b9aa8bf7a) )
ROM_END

ROM_START( kof99s179 ) // kof99wet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251ndh.p1",  0x000000, 0x100000, CRC(eedcc5bd) SHA1(8280c4329d666b4831c766853f5334355dc40cc9) )
	ROM_LOAD16_WORD_SWAP( "251wet.p2",  0x100000, 0x400000, CRC(bdb6e48c) SHA1(af0ce253e48df64693c45a123c3ddb03e5679cba) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251wet.m1", CRC(8c96b012) SHA1(8ae72cd0d88c742791b1f1f1d2af2253bf4f762d) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7",  0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8",  0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END

ROM_START( kof99s180 ) // kof99xxx
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251xxx.p1", 0x000000, 0x100000, CRC(29ac1595) SHA1(db2452de23dfbbb27c06c4d9abc9da4c9f3adacb) )
	ROM_LOAD16_WORD_SWAP( "251xxx.p2", 0x100000, 0x400000, CRC(3d930046) SHA1(1f04c000f1b16b334240f88bea386a8435185989) )

	NEO_SFIX_128K( "251xxx.s1", CRC(d55f8b72) SHA1(6843e41836611fcdb5db084047ab35a4606999c3) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1",  0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2",  0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251xxx.c7", 0x3000000, 0x800000, CRC(a02acaf8) SHA1(4136b4bedf51e02f0e22488bf8ca21847ad63f93) )
	ROM_LOAD16_BYTE( "251xxx.c8", 0x3000001, 0x800000, CRC(e3cee593) SHA1(1ea4b9f13344b33348ef3fb95b325509399ef756) )
ROM_END

ROM_START( kof99s181 ) // kof99y - Hack by Ydmis - (Can choose Krizalid, Krizalid', Kyo and Iori)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251y.p1",    0x000000, 0x100000, CRC(17a293ae) SHA1(b0f84a6c7688995eb93e5a4a13a4ca2a4e3645eb) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s182 ) // kof99yd - Hack by Ydmis - (Ultra kill start is max)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251yd.p1",   0x000000, 0x100000, CRC(9caffc4d) SHA1(100bb80ffc9f938b107dbd7994a2b6febd7b3a9c) )
	ROM_LOAD16_WORD_SWAP( "251r.p2", 0x100000, 0x400000, CRC(274ef47a) SHA1(98654b68cc85c19d4a90b46f3110f551fa2e5357) )

	NEO_SFIX_MT_128K

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251.c1",   0x0000000, 0x800000, CRC(0f9e93fe) SHA1(c7d77f0833c6f526f632e4f2dce59e302f6b9a15) )
	ROM_LOAD16_BYTE( "251.c2",   0x0000001, 0x800000, CRC(e71e2ea3) SHA1(39c7a326fddbcca3b29c68cdc96aad4d62295c0f) )
	ROM_LOAD16_BYTE( "251.c3",   0x1000000, 0x800000, CRC(238755d2) SHA1(01125b5c7a28e350f091280b041954fd1ac7c98f) )
	ROM_LOAD16_BYTE( "251.c4",   0x1000001, 0x800000, CRC(438c8b22) SHA1(ffbc643f5b27dd00f2f95d4ef4c5f29ee814722b) )
	ROM_LOAD16_BYTE( "251.c5",   0x2000000, 0x800000, CRC(0b0abd0a) SHA1(d5ad324fe523bdc6f09209d236cc4932524a48f1) )
	ROM_LOAD16_BYTE( "251.c6",   0x2000001, 0x800000, CRC(65bbf281) SHA1(79ae174667a23dabcfe865b6cd6133c86098452e) )
	ROM_LOAD16_BYTE( "251.c7",   0x3000000, 0x800000, CRC(ff65f62e) SHA1(7cd335fede05b56e15db90ce407c1183a78da4e9) )
	ROM_LOAD16_BYTE( "251.c8",   0x3000001, 0x800000, CRC(8d921c68) SHA1(42acf1d27d52a8e3b6262eb7df50693c0b135565) )
ROM_END

ROM_START( kof99s183 ) // kof99bs
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251bs.p1", 0x000000, 0x100000, CRC(43ce0028) SHA1(7f6ee38c5eb89410f56907f66e6c45f38384da2c) )
	ROM_LOAD16_WORD_SWAP( "251bs.p2", 0x100000, 0x400000, CRC(e20677c4) SHA1(3ada6a734a5ec274f96b012146ca3416b66b6865) )

	NEO_SFIX_128K( "251bs.s1", CRC(697c1f85) SHA1(117d12908b060db62716a8ac8a155c8303287746) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d-c1bs.c1", 0x0000000, 0x800000, CRC(a472f1db) SHA1(f941f39e95da3a866e5b05e61fffabe7731bdfcf) )
	ROM_LOAD16_BYTE( "251d-c1bs.c2", 0x0000001, 0x800000, CRC(11037779) SHA1(93a9c5031844aa8a13e758283621bf32cf41bb5b) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d-c1bs.c7", 0x3000000, 0x800000, CRC(165607a2) SHA1(7899a0cff743a942fa3af7def57dac6684e76231) )
	ROM_LOAD16_BYTE( "251d-c1bs.c8", 0x3000001, 0x800000, CRC(720c9304) SHA1(ecd5813bd0ab8df55191b21c9f425176945726c3) )
ROM_END

ROM_START( kof99s184 ) // kf99rev2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251revo.p1", 0x000000, 0x100000, CRC(38FD8609) SHA1(fded1624a670835ae107dc19707c2fa8b06d6cea) )
	ROM_LOAD16_WORD_SWAP( "251revo.p2", 0x100000, 0x400000, CRC(361F64DB) SHA1(a789df74ff197f2c552a87be4db8d321603d404e) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251rev2.c7", 0x3000000, 0x800000, CRC(4e8865b2) SHA1(8d7283d3782278b4fd5344a8986b1c9611118c32) )
	ROM_LOAD16_BYTE( "251rev2.c8", 0x3000001, 0x800000, CRC(040fcfcb) SHA1(27cb93f13ffa6f1ef97d2b967ffd4b4d757b1ca0) )
ROM_END

ROM_START( kof99s185 ) //kof99ae,kof99hc09
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251_hc09.p1", 0x000000, 0x100000, CRC(4c63e81c) SHA1(29bf0446db097e594c3705f7ff9ca20fa9d0d565) )
	ROM_LOAD16_WORD_SWAP( "251_hc09.p2", 0x100000, 0x400000, CRC(f3f47f41) SHA1(319ddb12c5353f4e27712db041c750f36df832b0) )
	ROM_LOAD16_WORD_SWAP( "251_hc09.p3", 0x500000, 0x400000, CRC(e3847545) SHA1(aef5625674901b33c151e81acb8d4c1118cf90d0) )

	NEO_SFIX_128K( "251_hc09.s1", CRC(3c31ee43) SHA1(f3bf265ad41037c2317702818136eb08e3ade3a2) )

	NEO_BIOS_AUDIO_128K( "251_hc01.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0xe00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251_hc09.v1", 0x000000, 0x400000, CRC(ceaa3bae) SHA1(ec598f92e7d3b41f38448fee2dd2ee599a482f8f) )
	ROM_LOAD( "251_hc01.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x6000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251_hc09.c1",  0x0000000, 0x800000, CRC(7eabea6c) SHA1(246db26c521ec3b25ac20cdc96a3c0ababffa3c2) )
	ROM_LOAD16_BYTE( "251_hc09.c2",  0x0000001, 0x800000, CRC(e5a5bc5c) SHA1(d131c4be01e97e55d2645c28defe6899fb3e0ab6) )
	ROM_LOAD16_BYTE( "251d.c3",      0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",      0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",      0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",      0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251_hc09.c7",  0x3000000, 0x800000, CRC(963c28ab) SHA1(35d987c115ca5785c04ebdc087667a9467c8661c) )
	ROM_LOAD16_BYTE( "251_hc09.c8",  0x3000001, 0x800000, CRC(43f1e92e) SHA1(70f4ece035999e80c4a39a908696369c67734121) )
	ROM_LOAD16_BYTE( "251_hc09.c9",  0x4000000, 0x800000, CRC(86a3550d) SHA1(ec74bcadb315a004297dc9e02c72efe5f2e2c5b0) )
	ROM_LOAD16_BYTE( "251_hc09.c10", 0x4000001, 0x800000, CRC(986bb897) SHA1(14572621122e97c3ae96a3b85069b9cde062ef19) )
	ROM_LOAD16_BYTE( "251_hc09.c11", 0x5000000, 0x800000, CRC(7fe785c2) SHA1(b49c3ab1ebf89090388c4757f24d1c02c730cc99) )
	ROM_LOAD16_BYTE( "251_hc09.c12", 0x5000001, 0x800000, CRC(a7541483) SHA1(3b3f0e67acfae1c3b6c5549ac350d855482f285f) )
ROM_END

ROM_START( kof99s186 ) //kof99jh,kof99hc15
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251_hc15.p1", 0x000000, 0x100000, CRC(48fe95b5) SHA1(070b8bee395682b4f3681fa5c6e05d7126ff3af4) )
	ROM_LOAD16_WORD_SWAP( "251_hc14.p2", 0x100000, 0x400000, CRC(2fcd21a1) SHA1(426c3c8178a2c03915c203c5aa7cb4b94aaff0a7) )
	ROM_FILL(0x2abe8,1,0x65)

	NEO_SFIX_128K( "251_hc12.s1", CRC(599f5fac) SHA1(73115e4977a2d81df3e89af2b92cf10be41fd46c) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251p.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "251p.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "251p.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "251p.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "251p.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "251p.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "251p.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99s187 ) //kof99jq,kof99hc17
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251_hc17.p1", 0x000000, 0x100000, CRC(ff897106) SHA1(48369d4044b48a8f8fc79cc3c4c4bdada0ee2f52) )
	ROM_LOAD16_WORD_SWAP( "251_hc17.p2", 0x100000, 0x400000, CRC(c8602aae) SHA1(f7ef1c55e45f5ec9574827daad477c214260350b) )

	NEO_SFIX_128K( "251_hc17.s1", CRC(b39bf6ed) SHA1(ec6512ecc8d475c553106601c2456e01c9623027) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251_hc05.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251_hc05.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "251p.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "251p.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "251p.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "251p.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251_hc05.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251_hc05.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99s188 ) //kof99pls,kof99hc18
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251_hc18.p1", 0x000000, 0x100000, CRC(dcba09c6) SHA1(15804fdcc16c38762f0a073cd023a2dac378c071) )
	ROM_LOAD16_WORD_SWAP( "251_hc18.p2", 0x100000, 0x400000, CRC(4fde8e58) SHA1(57b6f317fbd92ecb34be8b1dc7c5cd3a1da2a8d3) )

	NEO_SFIX_128K( "251d.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251_hc18.c1",  0x0000000, 0x800000, CRC(598cc558) SHA1(451d3f9fadb1810e383057591c46b736b6f595cb) )
	ROM_LOAD16_BYTE( "251_hc18.c2",  0x0000001, 0x800000, CRC(5b4c297b) SHA1(147342a115b0237d1cb55eceae093a7ee4a3c438) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5",  0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6",  0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251_hc18.c7",  0x3000000, 0x800000, CRC(3ac342ad) SHA1(325d0c407129a2cbf30c52e5317bbeb8fc056448) )
	ROM_LOAD16_BYTE( "251_hc18.c8",  0x3000001, 0x800000, CRC(500aea52) SHA1(a0c03d1c27c0f5013aff713b53e4e61bc76ff748) )
ROM_END

ROM_START( kof99s189 ) //kof99rp,kof99hc06
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251_hc06.p1", 0x000000, 0x100000, CRC(815f0b12) SHA1(46644a9d3258c0959cb9c5e497431f716c8fcb8a) )
	ROM_LOAD16_WORD_SWAP( "251_hc06.p2", 0x100000, 0x400000, CRC(0d35fb8f) SHA1(b25498aa2644af9ae1b12c301649cd4b1e9be175) )

	NEO_SFIX_128K( "251_hc06.s1", CRC(ca942904) SHA1(f84b79282bb2de61d24faacca1feda0187e42dcd) )

	NEO_BIOS_AUDIO_128K( "251_hc02.m1", CRC(0cb24d46) SHA1(7e6f41c093e2cc7353592cfda53e855b5e03c4e3) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251_hc02.v3",  0x800000, 0x400000, CRC(403628da) SHA1(e9fddfbedfdb70ba345820d95b154c1c73101a1c) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251_hc02.c1", 0x0000000, 0x800000, CRC(f0409101) SHA1(419ca1ea525f76d92b562e30bb043d39bd9a6c41) )
	ROM_LOAD16_BYTE( "251_hc02.c2", 0x0000001, 0x800000, CRC(3a9eff54) SHA1(8eb1918e7d6f823c8965546cd064f44b1b6982f2) )
	ROM_LOAD16_BYTE( "251d.c3",  0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4",  0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251_hc02.c5", 0x2000000, 0x800000, CRC(dd023649) SHA1(e65c3e82a66553a4f87277984e630ec7e288626a) )
	ROM_LOAD16_BYTE( "251_hc02.c6", 0x2000001, 0x800000, CRC(b8f60a8c) SHA1(f6a31066ffbf87937701df80abed8d9603629a5d) )
	ROM_LOAD16_BYTE( "251_hc02.c7", 0x3000000, 0x800000, CRC(1dfd5103) SHA1(edbe56d9434abdff58e7e9ceed7ea3d7975c40d2) )
	ROM_LOAD16_BYTE( "251_hc02.c8", 0x3000001, 0x800000, CRC(23fe3c43) SHA1(b601a14cd023b28f8e8eed8afd6a05d2c3df115a) )
ROM_END

ROM_START( kof99s190 ) //kof99sk,kof99hc26
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251_hc26.p1", 0x000000, 0x100000, CRC(ccfb323c) SHA1(113137918622ef59d8dd73f641392ea0647fba21) )
	ROM_LOAD16_WORD_SWAP( "251_hc26.p2", 0x100000, 0x400000, CRC(d322fb59) SHA1(6d7005966b4d2eb5cbdd9b05ee53255e887220e2) )

	NEO_SFIX_128K( "251d.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251d.c1", 0x0000000, 0x800000, CRC(b3d88546) SHA1(c277525f3db5b4cb07e9842605c7c40e6c203ad9) )
	ROM_LOAD16_BYTE( "251d.c2", 0x0000001, 0x800000, CRC(915c8634) SHA1(685ecb4271edf61f6a28a2235de11dd219b999d6) )
	ROM_LOAD16_BYTE( "251d.c3", 0x1000000, 0x800000, CRC(b047c9d5) SHA1(b840eab2208e6c0a1db0cdb28df46ba07da2ddca) )
	ROM_LOAD16_BYTE( "251d.c4", 0x1000001, 0x800000, CRC(6bc8e4b1) SHA1(674cb8145aeada1683a70beb02ed4ea028f5bdf8) )
	ROM_LOAD16_BYTE( "251d.c5", 0x2000000, 0x800000, CRC(9746268c) SHA1(59d839f01f4827377a752679922bc7281099430d) )
	ROM_LOAD16_BYTE( "251d.c6", 0x2000001, 0x800000, CRC(238b3e71) SHA1(f929c942972f768e68a5a009a3d174d203029160) )
	ROM_LOAD16_BYTE( "251d.c7", 0x3000000, 0x800000, CRC(2f68fdeb) SHA1(37167c84a39141c179f94800f207dac3aabc5478) )
	ROM_LOAD16_BYTE( "251d.c8", 0x3000001, 0x800000, CRC(4c2fad1e) SHA1(26779e79296eb1988a8c4d60d2e1baf041f2c0cf) )
ROM_END


/************************************
 The King of Fighters '99 Prototype
************************************/
ROM_START( kof99p00 ) // kof99hp - Hack by HackPlus - (Can choose Krizalid and Krizalid')
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p00.p1", 0x000000, 0x100000, CRC(15c044a1) SHA1(c78b627e7667952094066fbdb4dbb5ecd0032af3) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p01 ) // kof99evos - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p01.p1", 0x000000, 0x100000, CRC(a40dbe6d) SHA1(a1db02bd804edcbee32bb38edc416e1b81a9073c) )
	ROM_LOAD16_WORD_SWAP( "251p01.p2", 0x100000, 0x400000, CRC(f5831e0e) SHA1(ce8a34584b075d2568344e5ecb669bfff3d0d0f4) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p02 ) // kof99fc0
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p02.p1", 0x000000, 0x100000, CRC(ab81c822) SHA1(6091c9018b9384c34fd87bcad03e3e17d984bc56) )
	ROM_LOAD16_WORD_SWAP( "251rp.p2", 0x100000, 0x400000, CRC(C923EE2B) SHA1(98B4F40812D5479F7D6E683E5EF4002F4C86785C) )

	NEO_SFIX_128K( "251rp.s1", CRC(963D51B3) SHA1(B50A585E1CF7B47052A3D6FD85F47EA739B08BA8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p03 ) // kof99fix
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p03.p1", 0x000000, 0x100000, CRC(a71a0541) SHA1(49cac7ceedd6ef986987b2efed32f93a983d2319) )
	ROM_LOAD16_WORD_SWAP( "251p03.p2", 0x100000, 0x400000, CRC(e45ffa4f) SHA1(1ee1956eaba2283ffadfd7fd70618e9fcbeda7a8) )

	NEO_SFIX_128K( "251p03.s1", CRC(1d264e1b) SHA1(6e694465c31b75a8d75711abf653c2d878927f25) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p26.c7", 0x3000000, 0x800000, CRC(4e8bb555) SHA1(f68c597c1f10fb0f756e8252fa83de41ded27417) )
	ROM_LOAD16_BYTE( "251p26.c8", 0x3000001, 0x800000, CRC(d79a6e0d) SHA1(f6b1b930a62982ef20d1374b213d246f6352d558) )
ROM_END

ROM_START( kof99p04 ) // kof99fix1 - multijet kof99fix
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p04.p1", 0x000000, 0x100000, CRC(62bcb221) SHA1(956e245cdbf8afa11f85017225ed303a40218959) )
	ROM_LOAD16_WORD_SWAP( "251p04.p2", 0x100000, 0x400000, CRC(84519898) SHA1(acba79a5d6dfcfc9e68ba3b27b12d5608e76c819) )

	NEO_SFIX_128K( "251p03.s1", CRC(1d264e1b) SHA1(6e694465c31b75a8d75711abf653c2d878927f25) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251sp.c7", 0x3000000, 0x800000, CRC(4e8bb555) SHA1(f68c597c1f10fb0f756e8252fa83de41ded27417) )
	ROM_LOAD16_BYTE( "251sp.c8", 0x3000001, 0x800000, CRC(d79a6e0d) SHA1(f6b1b930a62982ef20d1374b213d246f6352d558) )
ROM_END

ROM_START( kof99p05 ) // kof99fix2 - multijet kof99fx2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p05.p1", 0x000000, 0x100000, CRC(e62d039d) SHA1(e358707e6954c07bf6b53b877463d1d8e6e973c2) )
	ROM_LOAD16_WORD_SWAP( "251p03.p2", 0x100000, 0x400000, CRC(e45ffa4f) SHA1(1ee1956eaba2283ffadfd7fd70618e9fcbeda7a8) )

	NEO_SFIX_128K( "251p05.s1", CRC(7fbf6061) SHA1(c4af13c28b1aaa198d117debedee1896b13a9e5d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p26.c7", 0x3000000, 0x800000, CRC(4e8bb555) SHA1(f68c597c1f10fb0f756e8252fa83de41ded27417) )
	ROM_LOAD16_BYTE( "251p26.c8", 0x3000001, 0x800000, CRC(d79a6e0d) SHA1(f6b1b930a62982ef20d1374b213d246f6352d558) )
ROM_END

ROM_START( kof99p06 ) // kof99kp - Colour fix by Fighters Kim - (Colour change - 10%)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "proto_251.p1", 0x000000, 0x100000, CRC(f37929c4) SHA1(226e7e3d629568399b88275e5bcd4e5b3839be95) )
	ROM_LOAD16_WORD_SWAP( "251p06.p2", 0x100000, 0x400000, CRC(b3aff1ed) SHA1(683561e36417152386317c30629732a1d718e188) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p07 ) // kof99phl - multijet
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p07.p1", 0x000000, 0x100000, CRC(e3923237) SHA1(356c036c9ffc903ba1663ce687b3fc7ec6afdfe3) )
	ROM_LOAD16_WORD_SWAP( "251p07.p2", 0x100000, 0x400000, CRC(58e3b94a) SHA1(010024bb779d5d346879c4d03857936c3a0b103b) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p08 ) // kof99pk - Hack by Kryso Fun - (Can choose Krizalid and Krizalid� - bases on RS - Version + fix? data)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p08.p1", 0x000000, 0x100000, CRC(9006f3a3) SHA1(1f09da2e94afd7f44087174a19ba4c74ea2a3d86) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p09 ) // kof99pko - Hack by Kryso Fun - (Can choose Krizalid and Krizalid� - bases on RS - Version without fix? data
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p09.p1", 0x000000, 0x100000, CRC(f7a95104) SHA1(51fd3befe4e439d9a5a17d99efa439d5f2091ed0) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p10 ) // kof99pm - Fix by UNKNOWN - (Mengele Fix)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p10.p1", 0x000000, 0x100000, CRC(ed68b5f5) SHA1(5a7ec30350dcba08f7617f6c53a051b5284bc00a) )
	ROM_LOAD16_WORD_SWAP( "251p10.p2", 0x100000, 0x400000, CRC(dc81f711) SHA1(2a00f9301e0e81ec00bc5eee5d39faeefa0eba8a) )

	NEO_SFIX_128K( "251p10.s1", CRC(841a498c) SHA1(b9bb31dd9638bad0304e16f2de268e8c1cc4adb1) )

	NEO_BIOS_AUDIO_128K( "251p10.m1", CRC(0659d262) SHA1(cea6c861a15025ad2bc1ad6b787534cfdd5bab53) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p11 ) // kof99py - Hack by Ydmis - (Can choose Kyo and Iori - ultra kill start is max)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p11.p1", 0x000000, 0x100000, CRC(4db24015) SHA1(1103eb498eb54e4787ed4da84a99978803041366) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p12 ) // kof99rs - (Prototype RS-Version)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p12.p1", 0x000000, 0x100000, CRC(9ae7ab90) SHA1(4783042353b2bc796b4e3f8545308fe406019eb2) )
	ROM_LOAD16_WORD_SWAP( "251p12.p2", 0x100000, 0x400000, CRC(838e9331) SHA1(f009382b5a99f6818f83f37f76af2d14f006237f) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p13 ) // kof99rsm - Fix by UNKNOWN - (Mengele fix for RS-Version)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p13.p1", 0x000000, 0x100000, CRC(788ebe35) SHA1(760d50701b8cd9a824b2b8e3e12b045bd0c0eaf1) )
	ROM_LOAD16_WORD_SWAP( "251p13.p2", 0x100000, 0x400000, CRC(2c98268d) SHA1(552388a4ecb5318bdf654c0fac7ccac77795e760) )

	NEO_SFIX_128K( "251p10.s1", CRC(841a498c) SHA1(b9bb31dd9638bad0304e16f2de268e8c1cc4adb1) )

	NEO_BIOS_AUDIO_128K( "251pm.m1", CRC(0659d262) SHA1(cea6c861a15025ad2bc1ad6b787534cfdd5bab53) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p14 ) // kof99rsp - Fix by UNKNOWN - (Bug Fix for Prototype RS-Version)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p14.p1", 0x000000, 0x100000, CRC(4827d835) SHA1(aac22e61c2b2e9e4ae8f6a19ed52020c42351271) )
	ROM_LOAD16_WORD_SWAP( "251p14.p2", 0x100000, 0x400000, CRC(b09c980d) SHA1(df6d30f01056695de4214c8273a35794faa1652a) )

	NEO_SFIX_128K( "251p14.s1", CRC(ee8f28a5) SHA1(b6531e6ee6bdd38f7d1f7f682dddff5426250015) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p15 ) // kof99wh1 - [OLD][BETA] - (kof99wh-b) - Remix by Wesker - (Character move change)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p15.p1", 0x000000, 0x100000, CRC(9e492265) SHA1(2448485e59ae2f921089f03be77a17bb32d0dd9d) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p16 ) // kof99wh2 - [OLD][BETA] - (kof99wh-b) - Remix by Wesker - (Character move change Ver. 0.02)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p16.p1", 0x000000, 0x100000, CRC(505a8ded) SHA1(cd939b018c43712e69aa9f3de8975a8df310503e) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p17 ) // kof99wh3 - [OLD][BETA] - (kof99wh-b) - Remix by Wesker - (Character move change Ver. 0.03)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p17.p1", 0x000000, 0x100000, CRC(9a312383) SHA1(29eba75aac66c5fec8ab5937312dc41155f243f8) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p18 ) // kof99wh4 - [OLD][BETA] - (kof99wh-b) - Remix by Wesker - (Character move change Ver. 0.04)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p18.p1", 0x000000, 0x100000, CRC(5092e49f) SHA1(09bd471e0c0951677bf76e7fc69cda8dc751e06b) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p19 ) // kof99xpsa - Fix by XPS - (00409 XPSLibrary alternate Andy striker voice fix)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p19.p1", 0x000000, 0x100000, CRC(5d4be286) SHA1(5052c6852cd02452ca4e103b5ef214120aae0452) )
	ROM_LOAD16_WORD_SWAP( "251p20.p2", 0x100000, 0x400000, CRC(6533070c) SHA1(1eff1d11ab1463bd9578055f43684949ac6602e4) )

	NEO_SFIX_128K( "251p20.s1", CRC(56bc7e7a) SHA1(c6b642243148ac89e2cfc1863edd369828a0ffb2) )

	NEO_BIOS_AUDIO_128K( "251pm.m1", CRC(0659d262) SHA1(cea6c861a15025ad2bc1ad6b787534cfdd5bab53) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p20 ) // kof99xpsf - Fix by XPS - (00731 XPSLibrary final fix 20000409 - RS-Version)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p20.p1", 0x000000, 0x100000, CRC(51dd4482) SHA1(71200ca31bb6fc0ac045f303c15a096fc1848901) )
	ROM_LOAD16_WORD_SWAP( "251p20.p2", 0x100000, 0x400000, CRC(6533070c) SHA1(1eff1d11ab1463bd9578055f43684949ac6602e4) )

	NEO_SFIX_128K( "251p20.s1", CRC(56bc7e7a) SHA1(c6b642243148ac89e2cfc1863edd369828a0ffb2) )

	NEO_BIOS_AUDIO_128K( "251p10.m1", CRC(0659d262) SHA1(cea6c861a15025ad2bc1ad6b787534cfdd5bab53) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p21 ) // kof99xpsp - Fix by XPS - (00731 XPSLibrary final fix 20000409)
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p21.p1", 0x000000, 0x100000, CRC(6fad557f) SHA1(a647d8faf44a0ae6d600c1fb2d0b5f5cd63dc854) )
	ROM_LOAD16_WORD_SWAP( "251p21.p2", 0x100000, 0x400000, CRC(952ad690) SHA1(c0aa19462f3451f355b36793a95009b808914329) )

	NEO_SFIX_128K( "251p20.s1", CRC(56bc7e7a) SHA1(c6b642243148ac89e2cfc1863edd369828a0ffb2) )

	NEO_BIOS_AUDIO_128K( "251pm.m1", CRC(0659d262) SHA1(cea6c861a15025ad2bc1ad6b787534cfdd5bab53) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END

ROM_START( kof99p22 ) // kof99s05
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p22.p1", 0x000000, 0x100000, CRC(bd40389d) SHA1(8b6ae1d46feeae7044acc1b4ff61cc0d7c0d59e3) )
	ROM_LOAD16_WORD_SWAP( "251p22.p2", 0x100000, 0x400000, CRC(18f8e9b5) SHA1(450d174378be6bd351cf151ec3ddc51e7d0862a6) )

	NEO_SFIX_128K( "251p22.s1", CRC(cf570e5e) SHA1(7196f8334242ac38f34145a370e7889e4e9f14ff) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251p22.c1", 0x0000000, 0x800000, CRC(0f8cbfba) SHA1(464dff49f1379ac4ba6fc8f8fbe307f82f7ee6e4) )
	ROM_LOAD16_BYTE( "251p22.c2", 0x0000001, 0x800000, CRC(1232d8c0) SHA1(c9e29a696fa6b2a195ec7f0fca84c34e7a451891) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p22.c7",  0x3000000, 0x800000, CRC(f9f17f45) SHA1(cec906600e31ac9a207f601c2751a36096ee0fe3) )
	ROM_LOAD16_BYTE( "251p22.c8",  0x3000001, 0x800000, CRC(aa894237) SHA1(efe635c35a7f442d48ca5a8406984d673d3bd816) )
ROM_END

ROM_START( kof99p23 ) //kof99rpg,kof99s34
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p23.p1", 0x000000, 0x100000, CRC(7eeb6064) SHA1(f846bc2df91c842efa20da4737164f980cc34778) )
	ROM_LOAD16_WORD_SWAP( "251p22.p2", 0x100000, 0x400000, CRC(18f8e9b5) SHA1(450d174378be6bd351cf151ec3ddc51e7d0862a6) )

	NEO_SFIX_128K( "251p22.s1", CRC(cf570e5e) SHA1(7196f8334242ac38f34145a370e7889e4e9f14ff) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251p22.c1", 0x0000000, 0x800000, CRC(0f8cbfba) SHA1(464dff49f1379ac4ba6fc8f8fbe307f82f7ee6e4) )
	ROM_LOAD16_BYTE( "251p22.c2", 0x0000001, 0x800000, CRC(1232d8c0) SHA1(c9e29a696fa6b2a195ec7f0fca84c34e7a451891) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p22.c7",  0x3000000, 0x800000, CRC(f9f17f45) SHA1(cec906600e31ac9a207f601c2751a36096ee0fe3) )
	ROM_LOAD16_BYTE( "251p22.c8",  0x3000001, 0x800000, CRC(aa894237) SHA1(efe635c35a7f442d48ca5a8406984d673d3bd816) )
ROM_END

ROM_START( kof99p24 ) // kof99s36
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p24.p1", 0x000000, 0x100000, CRC(bdb0aad2) SHA1(182ab8d0531e9ab2d5e6367ce3b4508cef6453a7) )
	ROM_LOAD16_WORD_SWAP( "251p24.p2", 0x100000, 0x400000, CRC(115a796a) SHA1(eb869ddd0a30c5e64774e6c3db86e4ed4ab4d9c2) )
	ROM_FILL(0x2ABE8,1,0x65)

	NEO_SFIX_128K( "251p24.s1", CRC(b39bf6ed) SHA1(ec6512ecc8d475c553106601c2456e01c9623027) )

	NEO_BIOS_AUDIO_128K( "251ae.m1", CRC(f847e188) SHA1(0b98595a457292b04f518afcc82c2d6b8f249a7b) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251ae.v1", 0x000000, 0x400000, CRC(4ae46226) SHA1(77dbd53772e1e5000a091b9ff4b3cdc14b62ab0b) )
	ROM_LOAD( "251ae.v2", 0x400000, 0x400000, CRC(07d70650) SHA1(70d274771c07215268292f91517ec61634e32611) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "251eur.c1", 0x0000000, 0x800000, CRC(c7e8bf32) SHA1(ede68ac10356f6824fa6b30e558038e78b604caf) )
	ROM_LOAD16_BYTE( "251eur.c2", 0x0000001, 0x800000, CRC(4e8f9f7d) SHA1(3a60df66bb24702041facb71025241483e5a1832) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251eur.c7", 0x3000000, 0x800000, CRC(f0b5ff02) SHA1(b9a25e6dad48547acce8edb5623be9d35bff1b4c) )
	ROM_LOAD16_BYTE( "251eur.c8", 0x3000001, 0x800000, CRC(7107b8d5) SHA1(6754113de3eb6a34c1913bb5117dd12d705b961c) )
ROM_END

ROM_START( kof99p25 ) // kof99s94
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p07.p1", 0x000000, 0x100000, CRC(e3923237) SHA1(356c036c9ffc903ba1663ce687b3fc7ec6afdfe3) )
	ROM_LOAD16_WORD_SWAP( "251p07.p2", 0x100000, 0x400000, CRC(58e3b94a) SHA1(010024bb779d5d346879c4d03857936c3a0b103b) )

	NEO_SFIX_128K( "251revo.s1", CRC(1b0133fe) SHA1(7f8e743bc0c8384dec12ca7007d32b23fef8875d) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p25.c7", 0x3000000, 0x800000, CRC(d6f4d197) SHA1(5a569b9d5b5672fd26902d429d5d6aa64e3fa7c8) )
	ROM_LOAD16_BYTE( "251p25.c8", 0x3000001, 0x800000, CRC(ac6e9af1) SHA1(296625896d2236ef63383713004f19e3e3b60156) )
ROM_END

ROM_START( kof99p26 ) // kof99sp
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p26.p1", 0x000000, 0x100000, CRC(48017E49) SHA1(67b84e227a1b8389b660008d326cd2b4c2830101) )
	ROM_LOAD16_WORD_SWAP( "251p26.p2", 0x100000, 0x400000, CRC(0b1396A9) SHA1(dbd0d462a0a7558dc35d8cfd01359e6fbf6e1f68) )

	NEO_SFIX_128K( "251p26.s1", CRC(C72989A5) SHA1(c23bc663610340259a29aeaf536f90c244e218f8) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "251p26.c7", 0x3000000, 0x800000, CRC(4E8BB555) SHA1(f68c597c1f10fb0f756e8252fa83de41ded27417) )
	ROM_LOAD16_BYTE( "251p26.c8", 0x3000001, 0x800000, CRC(D79A6E0D) SHA1(f6b1b930a62982ef20d1374b213d246f6352d558) )
ROM_END

ROM_START( kof99p27 ) // kof99yb
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "251p27.p1", 0x000000, 0x100000, CRC(fd2eaf53) SHA1(10dcb41674d236be9560ab442d3e3a8c542ab5f1) )
	ROM_LOAD16_WORD_SWAP( "proto_251.p2", 0x100000, 0x400000, CRC(739742ad) SHA1(31acaf05a9bf186305888d3db7e4e8a83f7bb0a4) )

	NEO_SFIX_128K( "proto_251.s1", CRC(fb1498ed) SHA1(d40060b31b6f217a4abdf3b336439fcd7bd7aaef) )

	NEO_BIOS_AUDIO_128K( "251.m1", CRC(5e74539c) SHA1(6f49a9343cbd026b2c6720ff3fa2e5b1f85e80da) )

	ROM_REGION( 0x0e00000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "251.v1", 0x000000, 0x400000, CRC(ef2eecc8) SHA1(8ed13b9db92dba3124bc5ba66e3e275885ece24a) )
	ROM_LOAD( "251.v2", 0x400000, 0x400000, CRC(73e211ca) SHA1(0e60fa64cab6255d9721e2b4bc22e3de64c874c5) )
	ROM_LOAD( "251.v3", 0x800000, 0x400000, CRC(821901da) SHA1(c6d4975bfaa19a62ed59126cadf2578c0a5c257f) )
	ROM_LOAD( "251.v4", 0xc00000, 0x200000, CRC(b49e6178) SHA1(dde6f76e958841e8c99b693e13ced9aa9ef316dc) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "proto_251.c1", 0x0000000, 0x800000, CRC(e5d8ffa4) SHA1(65f15f9f02424a7a9dd35916166594f283e8d424) )
	ROM_LOAD16_BYTE( "proto_251.c2", 0x0000001, 0x800000, CRC(d822778f) SHA1(b590055e9bf1549bd6e1ecdabd65702202615712) )
	ROM_LOAD16_BYTE( "proto_251.c3", 0x1000000, 0x800000, CRC(f20959e8) SHA1(38293043fa77ac51c5e3191118874c58f1ae4d30) )
	ROM_LOAD16_BYTE( "proto_251.c4", 0x1000001, 0x800000, CRC(54ffbe9f) SHA1(8e62442923551f07a552621951b1accab2830e3b) )
	ROM_LOAD16_BYTE( "proto_251.c5", 0x2000000, 0x800000, CRC(d87a3bbc) SHA1(430f6812088712e0eb5714dcc664d8bba75e921a) )
	ROM_LOAD16_BYTE( "proto_251.c6", 0x2000001, 0x800000, CRC(4d40a691) SHA1(2b580d0678a5e6033ef16130671e860364d35e56) )
	ROM_LOAD16_BYTE( "proto_251.c7", 0x3000000, 0x800000, CRC(a4479a58) SHA1(d50e6cc9ccfe1ddbc6d90d46b8ca2cb0304edd8c) )
	ROM_LOAD16_BYTE( "proto_251.c8", 0x3000001, 0x800000, CRC(ead513ce) SHA1(e9b07a0b01fdeb3004755a479df059c81b4d0ed6) )
ROM_END


/*    YEAR  NAME         PARENT    MACHINE        INPUT   CLASS         INIT          MONITOR COMPANY                 FULLNAME FLAGS */
// The King of Fighters '99
GAME( 1999, kof99s001,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Orochi's Blood 1.0)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s002,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Hidden Characters, 2007-04-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2011, kof99s003,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Evolution Ultra Remix, 2011-12-18)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s004,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Remix Pro v1.07 Plus)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s005,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Marcochen/PPX Hack Team", "Kof'99 (Rolls moves sideways ver)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s006,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Remix Pro Special)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s007,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Super Remix Pro Special)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s008,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional",    "Kof'99 (Anniversary Edition Old Version )", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s009,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional",    "Kof'99 (Anniversary Edition Special Version)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s010,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Combo)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s011,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Chinese Remix Pro v1.07 Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, kof99s012,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional",    "Kof'99 (Anniversary Edition, 2017-09-09)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s014,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Red Storm Edition Unsimplified)", MACHINE_SUPPORTS_SAVE )
GAME( 2012, kof99s015,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Bismil Hassan",    "Kof'99 (Super Revolution Ultra)", MACHINE_SUPPORTS_SAVE )
GAME( 2012, kof99s016,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Bismil Hassan",    "Kof'99 (Remix Pro Like 2k Ultimate Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s017,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Bismil Hassan",    "Kof'99 (Revolution Ver.?)", MACHINE_SUPPORTS_SAVE )
GAME( 2012, kof99s018,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Bismil Hassan",    "Kof'99 (Remix Like 2k)", MACHINE_SUPPORTS_SAVE )
GAME( 2011, kof99s019,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Bismil Hassan",    "Kof'99 (Evolution Ultimate Remix Version Rev.1)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, kof99s020,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional","Kof'99 (Anniversary Edition, 2014-11-11)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s022,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Hack Unknown, 2005-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s023,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Hack Unknown, 2007-07-16)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s024,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Plus, 2004-08-23)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s025,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Revolution, 2009-03-19)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s026,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Remix Pro v1.07, 2017-04-24)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s027,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (The 4 Manipulators Flames)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s028,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Unknown Hack, 2007-04-26)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s029,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Unknown Hack, 2007-04-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2011, kof99s030,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Bismil Hassan",    "Kof'99 (Evolution Ultimate Remix Version Rev.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, kof99s031,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Bloody Edition, 2016-04-09)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s032,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Evolution Ultra Remix, 2011-00-0?)", MACHINE_SUPPORTS_SAVE )
GAME( 2018, kof99s033,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Combo Simplify, 2018-09-03)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s034,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Marcochen", "Kof'99 (Orochi Iori)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, kof99s035,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Anniversary Edition, 2017-11-12)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s036,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Okukochi", "Kof'99 (Happy Birthday to Iori)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s037,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Eddids",    "Kof'99 (Re-Spell Krizalid's Name While Waiting-Striker)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s038,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "oak2003",    "Kof'99 (Fixed Life Bar V0)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s039,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "oak2003",    "Kof'99 (Fixed Life Bar V1)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s040,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "oak2003",    "Kof'99 (Fixed Life Bar V2)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s041,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "oak2003",    "Kof'99 (Fixed Life Bar V3)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s042,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "oak2003",    "Kof'99 (Fixed Life Bar V4)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s043,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "yashional",    "Kof'99 (Investment skills Hit)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s044,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ydmis",    "Kof'99 (Unlock Intensive Mode)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s045,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ydmis",    "Kof'99 (Enable Hidden Characters V1)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s046,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ydmis",    "Kof'99 (Enable Hidden Characters V2)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s047,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "wesker",    "Kof'99 (Hidden Characters - Add Striker Move V1)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s048,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "wesker",    "Kof'99 (Hidden Characters - Add Striker Move V2)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s049,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "kof1996",    "Kof'99 (Hidden Characters - Add Striker Move V3)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s050,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "kof1996",    "Kof'99 (Hidden Characters - Remove Shadow)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s051,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Eddids",    "Kof'99 (Hidden Characters - Add Bosses' Portraits)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s052,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "siromezm",    "Kof'99 (Hidden Characters - Replace Krizalid's Portraits)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s053,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "kof1996",    "Kof'99 (Hidden Characters - Add Krizalid's Moves)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s054,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Enhanced Counter & Armor Mode v1)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s055,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Enhanced Counter & Armor Mode v2)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s056,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Enhanced Counter & Armor Mode v3)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s057,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Get Maximum Power After Attack Or Being Attacked)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s058,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Get Maximum Power At Start Up)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s059,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Free Special Move)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s060,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Power Gauge Upgrade)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s061,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami",    "Kof'99 (Free ST)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s062,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "yashional",    "Kof'99 (Add '97 Shavings Wind)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s063,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Kim",    "Kof'99 (Change K's Moves)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s064,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "star07",    "Kof'99 (Add Kyo's New Moves)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s065,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack",    "Kof'99 (Yagami Temple Moves To Add)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s066,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "abchen",    "Kof'99 (7 Colors Version)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s067,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "tcwlee",    "Kof'99 (Color Change V1)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s068,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "tcwlee",    "Kof'99 (Color Change V2)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s069,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "tcwlee",    "Kof'99 (Color Change V3)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s070,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "tcwlee & Katana",    "Kof'99 (Color Change V4)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s071,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack",    "Kof'99 (Icy Blue Style)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s072,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "abchen",    "Kof'99 (Bloody Red Style)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s073,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "ivex",    "Kof'99 (Fix Iori's Bug)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s074,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "kof1996",    "Kof'99 (Fix Joe's Bug)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s075,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose",    "Kof'99 (Fix Leona's Bug)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s076,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack",    "Kof'99 (Enable Choosing Same One)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s077,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "star07",    "Kof'99 (Change Athena's Move)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s078,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Jason",    "Kof'99 (Enable Hidden)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s079,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "macrochen",    "Kof'99 (Orochi)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s080,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "kof1996",    "Kof'99 (Random Background)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s081,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "kof1996",    "Kof'99 (Random Boss)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s082,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "raymonose and jason",    "Kof'99 (Dodge Imitation kof2000)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s083,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "marcochen",    "Kof'99 (Dodge Imitation kof98)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s084,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "marcochen",    "Kof'99 (Dodge Imitation kof98A)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s085,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "star07",    "Kof'99 (Special Dialogue)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s086,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Eddids",    "Kof'99 (Unlimited Credits In Console Mode)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s087,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "xuyongsheng90",    "Kof'99 (Robert Hidden Trick)" , MACHINE_SUPPORTS_SAVE )
GAME( 2011, kof99s088,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "yashional",    "Kof'99 (Evolution Ultra Remix, 2011-12-20)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s089,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack",    "Kof'99 (Simplify The Move Version)" , MACHINE_SUPPORTS_SAVE )
GAME( 2016, kof99s090,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Eddids",    "Kof'99 (DreamCast 1.0, 2016-05-05)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s091,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Eddids",    "Kof'99 (DreamCast 1.2f)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s092,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "star07",    "Kof'99 (Revolution CE 1.2)" , MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s093,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Raymonose, Jasonly, Eddids, Andy chan, Hiker",    "Kof'99 (Remix Pro 2.00f)" , MACHINE_SUPPORTS_SAVE )
GAME( 2006, kof99s094,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack", "Kof'99 (Unknown Hack, 2016-01-14)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s095,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Alpha, 2020-01-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s096,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Alpha, 2020-01-25)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s097,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "FCHT", "Kof'99 (Remix Pro V2.0 Final)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, kof99s098,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Anniversary Edition, 2019-11-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s099,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Evolution Ultimate Edition, 2020-03-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s100,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Remix Pro, 2020-03-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s101,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional",    "Kof'99 (Anniversary Edition, 2020-03-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s102,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional",    "Kof'99 (Anniversary Edition, 2020-03-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s103,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Max Plus Simplified, 2020-03-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s104,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Imitation PS Enhanced Edition Original, 2020-08-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s105,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Imitation PS Enhanced Edition Simplified, 2020-08-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof99s106,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Imitation 14 BC Version (AC open BC), 2020-09-30)", MACHINE_SUPPORTS_SAVE )
GAME( 2013, kof99s107,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Anniversary Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, kof99s108,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Anniversary Edition, 2015-05-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2015, kof99s109,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Anniversary Edition, 2015-07-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, kof99s110,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Anniversary Edition, 2016-04-11)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, kof99s111,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Anniversary Edition, 2016-04-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2016, kof99s112,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Anniversary Edition Special)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s113,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Dodowang", "Kof'99 (Enable Hidden Characters V3)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, kof99s114,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Kof1996", "Kof'99 (Perfect Boss Edition, 2009-10-08)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s115,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Boss Striker Hack)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s116,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Eddids", "Kof'99 (DreamCast 1.2f/M.Multijet)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s117,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Chase", "Kof'99 (Diff Moves set 3)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s118,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Chase", "Kof'99 (Diff Moves set 3 - Fixed)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, kof99s119,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Ivex", "Kof'99 (Combo 2006)(set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, kof99s120,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ivex", "Kof'99 (Combo 2006)(set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s121,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "SNK", "Kof'99 (Decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s122,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ydmis", "Kof'99 (4 Add Char - Ultra kill start max set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s123,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose", "Kof'99 (4 Add Char - Ultra kill start max - Ultra pow hack set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s124,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Evolution Ultra Remix, 2016-01-04)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s125,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Evolution Ultra Remix old)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s126,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Evolution Ultra Remix)", MACHINE_SUPPORTS_SAVE )
GAME( 2011, kof99s127,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Evolution Ultra Remix, 2011-02-25)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, kof99s128,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Evolution Ultra Remix, 2009-07-17)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s129,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack", "Kof'99 (Evolution Special)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s130,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "wesker", "Kof'99 (Evolution  1.0)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, kof99s131,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Raymonose, Jasonly, Eddids, Andy chan, Hiker", "Kof'99 (Remix Pro)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, kof99s132,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Raymonose, Jasonly, Eddids, Andy chan, Hiker", "Kof'99 (Remix Remix 2.00B)", MACHINE_SUPPORTS_SAVE )
GAME( 2006, kof99s133,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Raymonose, Jasonly, Eddids, Andy chan, Hiker", "Kof'99 (Remix Remix 2.00F)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s134,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Jason/K3", "Kof'99 (3 Add Char - Simple moves rev - Athena style changed, 2003-10-18)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s135,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Jason/K3", "Kof'99 (3 Add Char - Simple moves rev - Athena style changed, 2003-09-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2007, kof99s136,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "lb70", "Kof'99 (Unknown Hack, 2016-01-04)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s137,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "MasakiAnton", "Kof'99 (2 Add Char)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s138,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "SNK", "Kof'99 (Non encrypted P,decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s139,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Remix Pro, 2016-03-11)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s140,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Korean)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s141,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Chl, Robert", "Kof'99 (Evolution Revision)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s142,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Orochi's Blood-Another part of Leona & Iori)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s143,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (Orochi's Blood)(Set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s144,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Perfect Boss)", MACHINE_SUPPORTS_SAVE )
GAME( 2002, kof99s145,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "TcwLee", "Kof'99 (Char color changed rev 1, 2002-09-xx)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s146,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "TcwLee", "Kof'99 (Char color changed rev 2, 2003-03-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s147,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "TcwLee", "Kof'99 (Char color changed rev 3, 2003-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s148,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "TcwLee", "Kof'99 (Char color changed old)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s149,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami", "Kof'99 (Ultra kill hack)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s150,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose", "Kof'99 (Backward rolling)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s151,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "abchen", "Kof'99 (Red Evil Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s152,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "star07", "Kof'99 (Revolution Merry Christmas, 2005-12-26)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s153,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "KofOnTeam", "Kof'99 (Advanced Roll)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, kof99s154,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - v1.07a, 2004-12-24)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, kof99s155,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Edition v1.07a)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s156,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - v1.02 final, 2003-10-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s157,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro(Diff Moves - Beta v1.01c, 2003-09-xx)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s158,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.01b, 2003-09-xx)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s159,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.01a2, 2003-09-xx)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s160,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.01a, 2003-09-xx)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s161,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.01, 2003-09-xx)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s162,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.00c built 0308e - EX ver.)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s163,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.00c built 0308e)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s164,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.00b enhanced)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s165,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.00b)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s166,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.00a enhanced)", MACHINE_SUPPORTS_SAVE )
GAME( 2003, kof99s167,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro)(Diff Moves - Beta v1.00a)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, kof99s168,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose & Jason", "Kof'99 (Remix Pro Plus)(Diff Moves v1.02 final, 2004-03-27)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s169,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Raymonose", "Kof'99 (Diff Moves set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s170,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Creamymami and Ydmis", "Kof'99 (4 Add Char - Ultra kill start max - Ultra pow)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s171,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Star07", "Kof'99 (Special Dialogue/V.Multijet)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s172,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "FCHT", "Kof'99 (Summer Revolution)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s173,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Raymonose", "Kof'99 (Super Remix Red)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s174,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack", "Kof'99 (Super Remix Red Version)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, kof99s175,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack", "Kof'99 (Optimised Version For GOTVG, 2014-08-29)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s176,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (The 4 Flame Manipulators)(set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s177,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Yashional", "Kof'99 (The 4 Flame Manipulators)(set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, kof99s178,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack", "Kof'99 (Renewed version, 2014-11-12)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s179,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Colour set ?)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s180,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Special Boss)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s181,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ydmis", "Kof'99 (4 Add Char)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s182,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "Ydmis", "Kof'99 (Ultra kill start max)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s183,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Boss Like Dreamcast, FCHT Hack)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s184,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "wesker", "Kof'99 (Revolution, Merry Christmas, Okuhoshi Hack Set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, kof99s185,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "GOTVG", "Kof'99 (Anniversary Edition Original, 2020-04-07)", MACHINE_SUPPORTS_SAVE )
GAME( 2023, kof99s186,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "GOTVG", "Kof'99 (Evolution Edition Original Edition, 2023-02-13)", MACHINE_SUPPORTS_SAVE )
GAME( 2024, kof99s187,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "GOTVG", "Kof'99 (Infinite Energy, 2024-01-01)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99s188,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack",  "Kof'99 Plus", MACHINE_SUPPORTS_SAVE )
GAME( 2022, kof99s189,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "hack",  "Kof'99 (Remix Pro v2.01 Final 2022)", MACHINE_SUPPORTS_SAVE )
GAME( 2025, kof99s190,   kof99,    neogeo_noslot, neogeo, neogeo_state, init_kof99,    ROT0, "GOTVG", "Kof'99 (LC+SK, 2025-03-09)", MACHINE_SUPPORTS_SAVE )
// Hacks of the Prototype
GAME( 1999, kof99p00,    neogeo,   neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (2 Add Char set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p01,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Evolution Balanced)", MACHINE_SUPPORTS_SAVE )
GAME( 2004, kof99p02,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Raymonose, Jasonly, Eddids, Andy chan, Hiker", "Kof'99 (Remix Remix 1.07A)", MACHINE_SUPPORTS_SAVE )
GAME( 2009, kof99p03,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Happy birthday to Iori special 2009)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p04,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Happy Birthday to Iori Special set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p05,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Happy Birthday to Iori Special set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p06,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Fighters Kim", "Kof'99 (Color changed - 10%)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p07,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Liyang1983", "Kof'99 (Plus)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p08,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "KrysoFun", "Kof'99 (2 Add Char - Based on RS - ver + Fix? data)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p09,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "KrysoFun", "Kof'99 (2 Add Char - Based on RS - ver without Fix? data)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p10,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Mengele Fix)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p11,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Ydmis","Kof'99 (2 Add Char - Ultra kill start max)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p12,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Proto RS-ver)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p13,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Mengele Fix for RS-ver)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p14,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Bug Fix for RS-ver)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p15,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Wesker", "Kof'99 (Diff Moves)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p16,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Wesker", "Kof'99 (Diff Moves - v.02)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p17,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Wesker", "Kof'99 (Diff Moves - v.03)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p18,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Wesker", "Kof'99 (Diff Moves - v.04)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p19,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "XPS", "Kof'99 (00409 XPSLibrary alternate Andy striker voice Fix)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p20,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "XPS", "Kof'99 (00731 XPSLibrary final Fix, 2000-04-09 - RS-ver)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p21,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "XPS", "Kof'99 (00731 XPSLibrary final Fix, 2000-04-09)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p22,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack",    "Kof'99 (Yagami Soul Prototype)", MACHINE_SUPPORTS_SAVE )
GAME( 2013, kof99p23,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (RPG, 2013-12-30)", MACHINE_SUPPORTS_SAVE )
GAME( 2017, kof99p24,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (EUR Version, 2015-07-13)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p25,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "hack", "Kof'99 (Evolutionary Balance)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p26,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "ZKW", "Kof'99 (Super Plus)", MACHINE_SUPPORTS_SAVE )
GAME( 1999, kof99p27,    kof99p00, neogeo_noslot, neogeo, neogeo_state, init_neogeo,   ROT0, "Ydmis", "Kof'99 (proto)(2 Add Char set 1)", MACHINE_SUPPORTS_SAVE )

