// license:GPL_2.0
// copyright-holders:Robbbert

#include "includes/neogeo.h"


ROM_START( kof2000d )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2000ev ) // all confirmed (alt m1 = d404db70)
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma.ev",   0x0c0000, 0x040000, CRC(329d80c9) SHA1(b1360c265a17a14b885dccfce67d14b3e5bc43a5) )
	ROM_LOAD16_WORD_SWAP( "257ev.p1", 0x100000, 0x400000, CRC(70b76979) SHA1(d6543c5399f9064423923effe0558dbe2d46c1d7) )
	ROM_LOAD16_WORD_SWAP( "257ev.p2", 0x500000, 0x400000, CRC(1ec748c2) SHA1(d2d9c78f35a148ed7629d6be02f4264956849beb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257ev.c1", 0x0000000, 0x800000, CRC(c89d1994) SHA1(2eb8a27f39dea743907b4be9e9d99f1858a30ba4) )
	ROM_LOAD16_BYTE( "257ev.c2", 0x0000001, 0x800000, CRC(19754968) SHA1(ca9692d5eac8e6eef5e5dd9888c5e8edcc9a0a7a) )
	ROM_LOAD16_BYTE( "257ev.c3", 0x1000000, 0x800000, CRC(c76b919b) SHA1(3f6245580e55c63d248478818005348f0cb92a6b) )
	ROM_LOAD16_BYTE( "257ev.c4", 0x1000001, 0x800000, CRC(5e03f2af) SHA1(85b7ec527a70411ad27d32a1169915b62230a3a7) )
	ROM_LOAD16_BYTE( "257ev.c5", 0x2000000, 0x800000, CRC(6a3b2fbd) SHA1(dbcf018f96767f753a2bab87f8d31fa6f6ef98d2) )
	ROM_LOAD16_BYTE( "257ev.c6", 0x2000001, 0x800000, CRC(ac4a8edc) SHA1(a305c8c5df3c2191fcdb73d799074a4191f2a252) )
	ROM_LOAD16_BYTE( "257ev.c7", 0x3000000, 0x800000, CRC(608ffca9) SHA1(0d3b184e44b9833f7338514e5633ccb3b3e39fb1) )
	ROM_LOAD16_BYTE( "257ev.c8", 0x3000001, 0x800000, CRC(73280ea8) SHA1(76bad66577b6d9618f2a190d54259eb3b1082d69) )
ROM_END

ROM_START( kof2000r )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257r.p3", 0x0c0000, 0x040000, CRC(11b98ae2) SHA1(fd901690334ccc26f0680427b05b5c4aad8b7e1a) )
	ROM_LOAD16_WORD_SWAP( "257r.p1", 0x100000, 0x400000, CRC(a9f1fb34) SHA1(a09f2bac40f91fc6910edef9699b10197f08f589) )
	ROM_LOAD16_WORD_SWAP( "257r.p2", 0x500000, 0x400000, CRC(9d26d55d) SHA1(ecb3b0bb98a24553d04c04c30f72f250ea86afeb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kce ) /* The King of Fighters 2000 - Colour fix by UNKNOWN - (Character colour change) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257ce.p2",   0x100000, 0x400000, CRC(60b00b9b) SHA1(eb2ea3980dbd2fe4d15b9155d4de7593396f8555) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kch ) /* The King of Fighters 2000 - Remix by Chase - (Character move change 20030503) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257ch.p1",  0x000000, 0x100000, CRC(6a4ac2cf) SHA1(0120d712439c909b96607b487bfbc93444e3da04) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kcp ) /* The King of Fighters 2000 - Colour fix by UNKNOWN - (Character colour change) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257cp.p2",  0x100000, 0x400000, CRC(a73339fd) SHA1(cce171fdb4e3be4b8431eea60b0bea36630bd94f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2keh ) /* The King of Fighters 2000 - Enhance by Ydmis - (Can choose Kula and Zero - ultra kill start is max) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257eh.p1",  0x000000, 0x100000, CRC(3a301e5b) SHA1(a8fe40cc1577bcf1503726cd38b502e8e5c4f621) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kehr ) /* The King of Fighters 2000 - Remix by Raymonose - (Character move change - can choose Kula and Zero - ultra power hack) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257ehr.p1",  0x000000, 0x100000, CRC(db0a8678) SHA1(d6f11011dfb9e7ee04cffbd9e1768a8fc9982fba) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kevo ) /* The King of Fighters 2000 - KOF2000 Evolution by Jason/K3 and Wesker - (KOF 2000 Evolution v1.2 - see readme for details) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257evo.p1",  0x000000, 0x100000, CRC(3107aa48) SHA1(e7240cc8697d63657ed59c8d2ea69e883d690d7d) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kevo1 ) /* [OLD] The King of Fighters 2000 N - (kof2kevo101) - KOF 2000 Evolution by Jason/K3 and Wesker - (KOF 2000 Evolution v1.01 - see readme for details) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257evo1.p1",  0x000000, 0x100000, CRC(ac684cce) SHA1(1fb72efd4fa0a4c40b0c16b913f5fa5fdd471d74) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kevo2 ) /* [OLD] The King of Fighters 2000 N - (kof2kevo10) - KOF 2000 Evolution by Jason/K3 and Wesker - (KOF 2000 Evolution v1.0 - see readme for details) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257evo2.p1",  0x000000, 0x100000, CRC(2331f409) SHA1(13344ccf1748be13e8605c8cd0f3e7786a0c250c) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kevo3 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257evo3.p1",  0x000000, 0x100000, CRC(93cc8aa5) SHA1(46226909fd182d9edefb529bfe4c91f8a5b02a9e) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2kgbh )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257gbh.p1",  0x000000, 0x100000, CRC(5527a8fb) SHA1(5c861ab496ab713d04fe26ad5e6f73c2bb52bf48) )
	ROM_LOAD16_WORD_SWAP( "257gbh.p2",  0x100000, 0x400000, CRC(7992520d) SHA1(7718348355adbb05e64767ae5d075046ae9b5400) )

	NEO_SFIX_MT_512K
	// This came with the set but doesn't work
	//NEO_SFIX_128K( "257gbh.s1", BAD_DUMP CRC(cabc287b) SHA1(dbf3adc0fe31d3c6c246ed4c996ca9b8c9bbfa4d) ) // confirmed bad dump

	NEO_BIOS_AUDIO_256K( "257gbh.m1", CRC(a082f086) SHA1(809ef4a533cf541b86786f455a7f283a5acecd82) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bh.c7", 0x3000000, 0x800000, CRC(f7636227) SHA1(a76b331c96a7bf6fb4123c88a15f565c82b13373) )
	ROM_LOAD16_BYTE( "257bh.c8", 0x3000001, 0x800000, CRC(b887fe36) SHA1(d6fc2fba39c8f22ddbe911345ba1d21561cc4eb2) )
ROM_END

ROM_START( kof2kgold ) /* The King of Fighters 2000 - Colour fix by Anndy - (Character colour change - attack cremation gold) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257gbh.p2",  0x100000, 0x400000, CRC(7992520d) SHA1(7718348355adbb05e64767ae5d075046ae9b5400) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kiori )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257iori.p1", 0x000000, 0x100000, CRC(d7cdca85) SHA1(2cdc6f528512a8d8eff800602f00f75797e4a5f1) )
	ROM_LOAD16_WORD_SWAP( "257iori.p2", 0x100000, 0x400000, CRC(ce947e0f) SHA1(0d86e181a1a6244fb61ac18d013352c3a9722ebd) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257iori.c7", 0x3000000, 0x800000, CRC(4230c654) SHA1(7e5cb48cbec8b27047e5642af58bebd71a9f986b) )
	ROM_LOAD16_BYTE( "257iori.c8", 0x3000001, 0x800000, CRC(80aa8ac2) SHA1(7a828725e8442e19b1ad34327d9d9025d04f4853) )
ROM_END

ROM_START( kof2kjlc ) /* The King of Fighters 2000 - Colour fix by Jui Lee - (Character colour change for Athena 2P and Kula 2P) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257jlc.p2",  0x100000, 0x400000, CRC(dc36885b) SHA1(b192edc43f598434877df3e2deddca53473bf537) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kkf1 ) /* The King of Fighters 2000 - Hack by Kurouri - (MVS protection removed, can select Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257kf1.p1",  0x000000, 0x100000, CRC(3a6bb418) SHA1(d794bf7ee14fcf3972360f7d47ed6cd08a3269d2) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kkt )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257kt.p1", 0x000000, 0x100000, CRC(0c2ad325) SHA1(40bcc1a27352529423c773ff59c12c59c3f130e9) )
	ROM_LOAD16_WORD_SWAP( "257kt.p2", 0x100000, 0x400000, CRC(b0c817ca) SHA1(414f16ddf1e668effa23090dd8ee843793bb70c8) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257s58.s1", 0x000000, 0x80000, CRC(38901d4d) SHA1(c7684f66ab4ed577094da6ae143477c9df28d1fe) )

	NEO_JAPAN_BIOS_AUDIO(0x40000, "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257kt.c1", 0x0000000, 0x800000, CRC(e5773336) SHA1(9fe83dcbe8d26a66e0c94057b09c9dd65cd63d50) )
	ROM_LOAD16_BYTE( "257kt.c2", 0x0000001, 0x800000, CRC(654c2a61) SHA1(8a572dda43c554a38aec26b28c21edc0ace9b694) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257kt.c7", 0x3000000, 0x800000, CRC(14cc1419) SHA1(70b68c96dde1f27040569ccd4c23a2c35d11ebd0) )
	ROM_LOAD16_BYTE( "257kt.c8", 0x3000001, 0x800000, CRC(cfce677d) SHA1(0cd7cc1c0012940d84e6a13f35294b08aa84f959) )
ROM_END

ROM_START( kof2kkvs ) /* The King of Fighters 2000 - Hack by KVS - (MVS protection removed - can select Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257kvs.p1",  0x000000, 0x100000, CRC(de23e8a0) SHA1(737a3e9c7cac2338f382c3a55d5caa9810fb87ce) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kkzs ) /* The King of Fighters 2000 - Hack by UNKNOWN - (MVS protection removed - can choose Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257kzs.p1",  0x000000, 0x100000, CRC(e41f350c) SHA1(d0d4feb6f91714abe11ec57ba9eecc7bb7f5b354) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2knd )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1",  0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2kpjc ) /* The King of Fighters 2000 - Colour fix by TcwLee - (Colour fix 20030720) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257pjc.p2",  0x100000, 0x400000, CRC(3f94a4d3) SHA1(8fd23e05bde49e9ff25f070338b947c53bbf603f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kpjc1 ) /* [OLD] The King of Fighters 2000 N - (kof2kpjco) - Colour fix by TcwLee - (Colour fix - entire role change) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257pjc1.p2", 0x100000, 0x400000, CRC(c954c944) SHA1(3ca35a5393351ee22ef651f8984067b18aa02144) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kpjc2 ) /* [OLD] The King of Fighters 2000 N - (kof2kc2) - Colour fix by TcwLee - (Colour fix ver. 2) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257pjc2.p2", 0x100000, 0x400000, CRC(136bd0a4) SHA1(5549ba017a9c633a3652ad3fc0d1c41bc247cdcd) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kpjc3 ) /* [OLD] The King of Fighters 2000 N - (kof2kpjco2) - Colour fix by TcwLee - (Colour change - striker not perfect 20030302) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257n.p1", 0x000000, 0x100000, CRC(5f809dbe) SHA1(2bc233dcff5622de86d01e3b74b840c7caf12982) )
	ROM_LOAD16_WORD_SWAP( "257pjc3.p2", 0x100000, 0x400000, CRC(22bf407a) SHA1(dba889edbe0bd641ce678f0ffc79afed24659bde) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kpls )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257pls.p1", 0x000000, 0x100000, CRC(052a5e17) SHA1(1f2c43981e1e762c0d0a81f23311e5d021e94472) )
	ROM_LOAD16_WORD_SWAP( "257pls.p2", 0x100000, 0x400000, CRC(9d716a8b) SHA1(da32f57719155b8dfa86124312d03ee82fbc7151) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257pls.s1", 0x60000, 0x20000, CRC(5a8d9e10) SHA1(2eb244a28b891a6fadbbccf10afe47b78d7948f0) )
	ROM_CONTINUE(0x40000, 0x20000)
	ROM_CONTINUE(0x20000, 0x20000)
	ROM_CONTINUE(0x00000, 0x20000)

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257pls.c7", 0x3000000, 0x800000, CRC(eda5ea7f) SHA1(25e1d5279635eab65ba7b3f565d5cf0dd48ad201) )
	ROM_LOAD16_BYTE( "257pls.c8", 0x3000001, 0x800000, CRC(6df754d8) SHA1(94469836ae8e08448a01f346a09e660ceed9371f) )
ROM_END

ROM_START( kof2krm ) /* The King of Fighters 2000 - Remix by Raymonose - (Character move change) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257rm.p1",  0x000000, 0x100000, CRC(597fdfc7) SHA1(10bb9e4ad0c3ff53336cc0e06303f83bcb5c94e4) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2krp ) /* The King of Fighters 2000 - Remix PRO by FCHT - (Character move change v1.0a 20031103 - BETA) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257rp.p1",  0x000000, 0x100000, CRC(7c81d853) SHA1(b101b64a06ba6292d369d10f75a56de09b04823b) )
	ROM_LOAD16_WORD_SWAP( "257rp.p2",  0x100000, 0x400000, CRC(82a6aeed) SHA1(36f369313999d23f50201c1e240736d00d4921da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kryu )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257ryu.p1",   0x000000, 0x100000, CRC(47806bd7) SHA1(fd61bd7c6758870c24446b07175537ed1c2135af) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2kseh ) /* The King of Fighters 2000 - Super Enhance Hack by Creamymami and Ydmis - (Can choose Kula and Zero - ultra kill start is max - super power hack) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257seh.p1",  0x000000, 0x100000, CRC(b84547e4) SHA1(1c01a764d5333d8acab392f24f9a2f8d00e257ca) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kst ) /* The King of Fighters 2000 N - Hack by KOF1995 - (Boss striker movement change - similar to kof2kevo from FGCH - can choose Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257st.p1",  0x000000, 0x100000, CRC(e21736d5) SHA1(7ea8045775b5d9e111a94a641a372faaf2495a5e) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kwh ) /* The King of Fighters 2000 - Hack by Wesker - (Character move change for Takuma) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257wh.p1",  0x000000, 0x100000, CRC(5fa8d962) SHA1(8285b925c4edf3460ff5cf63fbcb7379568897ac) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kwh2 ) /* The King of Fighters 2000 - Hack by Wesker - (Character move change for Jhun) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257wh2.p1",  0x000000, 0x100000, CRC(06e47159) SHA1(45ae1f2c9c4393ff9cc0425a4a85c7bc1ad31c0e) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kxxx )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257xxx.p1", 0x000000, 0x100000, CRC(b88cd5eb) SHA1(81b5ef268991fe368c6efa836cb822fbcfe54920) )
	ROM_LOAD16_WORD_SWAP( "257xxx.p2", 0x100000, 0x400000, CRC(1a10f2be) SHA1(67794176d3d834b85495fa653a8acd14901b1658) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257xxx.c1", 0x0000000, 0x800000, CRC(3006a5e4) SHA1(e1fa9c32306a7501cb4789ec85521fd6fd7ad28c) )
	ROM_LOAD16_BYTE( "257xxx.c2", 0x0000001, 0x800000, CRC(366fd118) SHA1(36abc1e8e48e47afdab9541a4612b346799693de) )
	ROM_LOAD16_BYTE( "257xxx.c3", 0x1000000, 0x800000, CRC(5b16d7e3) SHA1(3a5cbfc47b7db0ee4f15232066c4f79544dee20f) )
	ROM_LOAD16_BYTE( "257xxx.c4", 0x1000001, 0x800000, CRC(7e57dfc1) SHA1(7a07d1547306646538d29ba9bd3acdaca7c70907) )
	ROM_LOAD16_BYTE( "257xxx.c5", 0x2000000, 0x800000, CRC(671904f4) SHA1(7bfd66b7f1866c06b161eb6cf594aa017b7088b2) )
	ROM_LOAD16_BYTE( "257xxx.c6", 0x2000001, 0x800000, CRC(68adf255) SHA1(a60ad8adbec8c4e6ed85fd3b251a8f187aca85b1) )
	ROM_LOAD16_BYTE( "257xxx.c7", 0x3000000, 0x800000, CRC(8c6b22b3) SHA1(7f4a204de276a9acae2c6d58b2b5c03f76bcab69) )
	ROM_LOAD16_BYTE( "257xxx.c8", 0x3000001, 0x800000, CRC(6223bd1d) SHA1(94b512eb202aec084110e477b283591bad54d027) )
	// Alternate (decrypted) roms
	//NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )
	//ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	//ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	//ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	//ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	//ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	//ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	//ROM_LOAD16_BYTE( "257xxx1.c7", 0x300000, 0x800000, CRC(05125a94) SHA1(cdd77c649945e15088dd07ba282e6dc9ef883a75) )
	//ROM_LOAD16_BYTE( "257xxx1.c8", 0x300001, 0x800000, CRC(300eba2a) SHA1(42defa20e3a0760f64c4c0346ab48d664960c638) )
ROM_END

ROM_START( kof2kyd ) /* The King of Fighters 2000 - Revise by Dodowang and Ydmis - (Style change - can choose Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257yd.p1",  0x000000, 0x100000, CRC(09c64b87) SHA1(8ad7a2c9cf0e360364ad5ee58ed514fbee015a65) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kyg ) /* The King of Fighters 2000 - Hack by Ydmis - (Can choose Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257yg.p1",  0x000000, 0x100000, CRC(684f6f70) SHA1(660a35e8db9d44b246dfc788e5576fe8d138e580) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kz ) /* The King of Fighters 2000 - Hack by Ydmis - (Can choose Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257z.p1",  0x000000, 0x100000, CRC(029a6b8a) SHA1(1179df1960dffc04860acb0a91c53e9c5cf7e107) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kzs ) /* The King of Fighters 2000 - Hack by UNKNOWN - (MVS protection removed - can choose Kula and Zero) */
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257zs.p1",  0x000000, 0x100000, CRC(ca73f3a5) SHA1(d083a47ff19317855da866e29eea3aa66a1ffb03) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000h )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257h.p1",  0x000000, 0x100000, CRC(613d1fc2) SHA1(69a6d8add28291a14d69e9a098dd78a84f6c9b31) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2kbj )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bj.p1",  0x000000, 0x100000, CRC(fafe059e) SHA1(6167c6a2f8d8b2d08d8a2dfd26e1722bdca9c3f7) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1",   0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2",   0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3",   0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4",   0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5",   0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6",   0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7",   0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8",   0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2ky )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257y.p1",  0x000000, 0x100000, CRC(ca715980) SHA1(869268d27fc2628ac1fe817b2d0491096821b8de) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

/**************************
 The King of Fighters '2000
******************************/

ROM_START( kof2000s01 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc01",   0x0c0000, 0x040000, CRC(86de115d) SHA1(242d499bf1d1fac16fb3cc9ffcbe74c81cb8d821) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s01.p2", 0x500000, 0x400000, CRC(c368138a) SHA1(e11c544a1c944d779dee38292dfaa5b00b8fd90f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s02 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc03",   0x0c0000, 0x040000, CRC(4661bd43) SHA1(93232731a499058cd92e27f003b032596d4fb1f7) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s02.p2", 0x500000, 0x400000, CRC(a31ade76) SHA1(288103d60c6830451570db4149b36e5685afd576) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s03 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc03",   0x0c0000, 0x040000, CRC(4661bd43) SHA1(93232731a499058cd92e27f003b032596d4fb1f7) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s02.p2", 0x500000, 0x400000, CRC(a31ade76) SHA1(288103d60c6830451570db4149b36e5685afd576) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s04 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc04",   0x0c0000, 0x040000, CRC(124247f2) SHA1(6e21d273be75025d768e5d72ce6afd936138d47d) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s04.p2", 0x500000, 0x400000, CRC(fecf7c7f) SHA1(8bbf243374a7d0985d996238420447c56689334f) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s05 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc05",   0x0c0000, 0x040000, CRC(e6a3d20b) SHA1(d00730dc5655c45101e82411392164909c4d58f3) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s05.p2", 0x500000, 0x400000, CRC(d382e18c) SHA1(14dacc8a8513222863ad8a2478d128d56c7f5cbe) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s01.c1", 0x0000000, 0x800000, CRC(b2489222) SHA1(0df08e7a26624f3d15f723b490b89f3a5836b5ce) )
	ROM_LOAD16_BYTE( "257s01.c2", 0x0000001, 0x800000, CRC(f2ae25d5) SHA1(dd6749fa04065d3c847abe9784ab25397cc45d08) )
	ROM_LOAD16_BYTE( "257s01.c3", 0x1000000, 0x800000, CRC(9f2826a6) SHA1(25f1ba66aa52ac3e7831870880c72691779133ff) )
	ROM_LOAD16_BYTE( "257s01.c4", 0x1000001, 0x800000, CRC(4683e01b) SHA1(20e0a430b834b4d11b42fdc676cacc6dcd2b4c48) )
	ROM_LOAD16_BYTE( "257s01.c5", 0x2000000, 0x800000, CRC(40a7857d) SHA1(b128b012d1df92b8dcf0a3dee293670973670b8c) )
	ROM_LOAD16_BYTE( "257s01.c6", 0x2000001, 0x800000, CRC(97e2f3af) SHA1(c8ebe453f90369d1d1798aaacacc82e307940b14) )
	ROM_LOAD16_BYTE( "257s01.c7", 0x3000000, 0x800000, CRC(af7462ef) SHA1(5726e0fdf63b6ec60b789acd306d93518413e6ae) )
	ROM_LOAD16_BYTE( "257s01.c8", 0x3000001, 0x800000, CRC(897745af) SHA1(9e4e9f3e8d0e6479710488139d20149a96b22907) )
ROM_END

ROM_START( kof2000s06 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma.ev",   0x0c0000, 0x040000, CRC(329d80c9) SHA1(b1360c265a17a14b885dccfce67d14b3e5bc43a5) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s06.p2", 0x500000, 0x400000, CRC(eea411cc) SHA1(7c249beffe1f30417540bae83508acdf2166731a) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s07 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc07",   0x0c0000, 0x040000, CRC(33ee6ecd) SHA1(f6eb8798afe4762891051aa7a198ebe3fb1b7401) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s07.p2", 0x500000, 0x400000, CRC(ab0e46b4) SHA1(4dc2b9a61d9af5b0533ad44d559d94879257c196) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s08 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-smahc07",   0x0c0000, 0x040000, CRC(33ee6ecd) SHA1(f6eb8798afe4762891051aa7a198ebe3fb1b7401) )
	ROM_LOAD16_WORD_SWAP( "257s08.p1", 0x100000, 0x400000, CRC(2a930c57) SHA1(a53921cdf96d385acfc9070135e30264eb0d1d11) )
	ROM_LOAD16_WORD_SWAP( "257s08.p2", 0x500000, 0x400000, CRC(b0dc1d03) SHA1(4288afb4dc87789743dbff3cfe08ddbfffac5fb6) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s09 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s09.p1", 0x100000, 0x400000, CRC(5f9857eb) SHA1(cd5eccbebd1337338f2c2a8b9579c7f312733469) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s10 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s10.p2", 0x500000, 0x400000, CRC(b192cf04) SHA1(519c92db4799b4b292e9106d01ee08cfddad103b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s11 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s11.p1", 0x100000, 0x400000, CRC(1af8059e) SHA1(b27a6ec83ed14c496280997d5e6af1d59f368b2f) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s12 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s12.p2", 0x500000, 0x400000, CRC(0cc3cb26) SHA1(27d47d473a2efa1477d2145819f8f6572fdbc17c) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s13 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s13.p2", 0x500000, 0x400000, CRC(6fe1a22e) SHA1(0c42c0987230fc141ee322a13e0c676fe1a686d9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s14 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s14.p2", 0x500000, 0x400000, CRC(7ea31eb1) SHA1(99e1760635b316565437eacc49174eb9a434f1cf) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s15 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s15.p2", 0x500000, 0x400000, CRC(eb1d9d1b) SHA1(4915986b05c3972a9811c2e089ef00b602bd6dc1) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s16 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s16.p2", 0x500000, 0x400000, CRC(8731e3c7) SHA1(23ba4ec94b7641173881e962c04e93b926bf5bad) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s17 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s17.p2", 0x500000, 0x400000, CRC(3a0f51cf) SHA1(d2097f3c6290e5b7e65a97fac9a6c9a832600cd1) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s18 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s18.p1", 0x100000, 0x400000, CRC(7464a739) SHA1(4bde463b2cfb646b6a725467eb0e616858866d49) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s19 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s19.p1", 0x100000, 0x400000, CRC(6441efb5) SHA1(7544f496d6eda8a05e8a17f86682f60e1f85cb6a) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s20 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s20.p1", 0x100000, 0x400000, CRC(b719169c) SHA1(57c043e45d3f5f77a2be1cb018afbd71b806a5a6) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s21 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s21.p1", 0x100000, 0x400000, CRC(e1ca66a7) SHA1(ae730798e5493c5227c37badc4582635a8094023) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s22 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s22.c1", 0x0000000, 0x800000, CRC(e755c354) SHA1(b17b92a29ca0aa637d779f1633b1820b314ff54f) )
	ROM_LOAD16_BYTE( "257s22.c2", 0x0000001, 0x800000, CRC(b7738f1c) SHA1(e701c0db2e277a66da8e67dd260070bcb01c2894) )
	ROM_LOAD16_BYTE( "257s22.c3", 0x1000000, 0x800000, CRC(4d2440f0) SHA1(44efc985ee68c23157daf026b743e04f1d658150) )
	ROM_LOAD16_BYTE( "257s22.c4", 0x1000001, 0x800000, CRC(7ad9b278) SHA1(d6dc72103ced5f886cbe60c5fa976225e5ae6444) )
	ROM_LOAD16_BYTE( "257s22.c5", 0x2000000, 0x800000, CRC(85630e35) SHA1(faade29cf5821b9eab082e7ded818dad36e4dd51) )
	ROM_LOAD16_BYTE( "257s22.c6", 0x2000001, 0x800000, CRC(4ba26d64) SHA1(b14a7a7990865dde0c385ba9abf282cc59bdff9a) )
	ROM_LOAD16_BYTE( "257s22.c7", 0x3000000, 0x800000, CRC(9460a514) SHA1(69b8c7f8f03ac300860dbc79ab36b15e527cbc96) )
	ROM_LOAD16_BYTE( "257s22.c8", 0x3000001, 0x800000, CRC(5d550927) SHA1(87216c0a4ed499ddae6e409c2586d95f8fe90d5c) )
ROM_END

ROM_START( kof2000s23 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s23.c1", 0x0000000, 0x800000, CRC(730c49ea) SHA1(0c79e7a2cfb734fddcf8c912fe9b8029df51bd20) )
	ROM_LOAD16_BYTE( "257s23.c2", 0x0000001, 0x800000, CRC(5bb75e5e) SHA1(a61025a26d85aa5a75df544035e8d0f031774aa0) )
	ROM_LOAD16_BYTE( "257s23.c3", 0x1000000, 0x800000, CRC(e399c6e8) SHA1(d69d200f245e8b5e9fbf70a0ca42e07e5caed4ba) )
	ROM_LOAD16_BYTE( "257s23.c4", 0x1000001, 0x800000, CRC(313b9240) SHA1(14ba39656617c369246f25a13c9e34bebf8aead3) )
	ROM_LOAD16_BYTE( "257s23.c5", 0x2000000, 0x800000, CRC(2d62889f) SHA1(5ec3400286d0360944a5c0355351d55e82dfecca) )
	ROM_LOAD16_BYTE( "257s23.c6", 0x2000001, 0x800000, CRC(ecb67aaa) SHA1(1ce7cac75c56a8e2d7a3e1ae543731ee5c4fa7fa) )
	ROM_LOAD16_BYTE( "257s23.c7", 0x3000000, 0x800000, CRC(b1a41172) SHA1(167cd7ae55f1d9a778619294a6cdc21ba71f3a85) )
	ROM_LOAD16_BYTE( "257s23.c8", 0x3000001, 0x800000, CRC(d55bf11f) SHA1(68eca1ae582ac4dc2f85f47d367283a24244a1c0) )
ROM_END

ROM_START( kof2000s24 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s24.c1", 0x0000000, 0x800000, CRC(b494d0e0) SHA1(70798c0087a951b621daa804ac13691e7a61b881) )
	ROM_LOAD16_BYTE( "257s24.c2", 0x0000001, 0x800000, CRC(e11d3124) SHA1(aadc733196542403ca98cf0ffa3817f502a42efc) )
	ROM_LOAD16_BYTE( "257s24.c3", 0x1000000, 0x800000, CRC(b7dfd8c0) SHA1(d6439d2d0cea7648f448a0625a8d805865bf4a0f) )
	ROM_LOAD16_BYTE( "257s24.c4", 0x1000001, 0x800000, CRC(9dd7f0cd) SHA1(0b52daf586bfd4dda9ba2855e3074b19417cae16) )
	ROM_LOAD16_BYTE( "257s24.c5", 0x2000000, 0x800000, CRC(31782782) SHA1(d20232275f899022065a05236979c27077c93c78) )
	ROM_LOAD16_BYTE( "257s24.c6", 0x2000001, 0x800000, CRC(35eb669b) SHA1(8fe7ba40eb2e639df2191ebb90b03ff62a268308) )
	ROM_LOAD16_BYTE( "257s24.c7", 0x3000000, 0x800000, CRC(fe3d83fc) SHA1(f02c9831212122b9a75c7979d124d6af10cdce97) )
	ROM_LOAD16_BYTE( "257s24.c8", 0x3000001, 0x800000, CRC(3689c150) SHA1(97c0aa7db3bbd63c384de4d1a5542b18bedd36cd) )
ROM_END

ROM_START( kof2000s25 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s25.c1", 0x0000000, 0x800000, CRC(2d2ed8e7) SHA1(5a0c3b51a0e4351f626ff545e8f4960bce5a65bc) )
	ROM_LOAD16_BYTE( "257s25.c2", 0x0000001, 0x800000, CRC(ad5dfcee) SHA1(d4bc0b1945cb97fad4bcb4414e33bb5498a0a851) )
	ROM_LOAD16_BYTE( "257s25.c3", 0x1000000, 0x800000, CRC(12aca312) SHA1(2831aa03bf5e6a5cce180fe2cf3d6a06cfc151e3) )
	ROM_LOAD16_BYTE( "257s25.c4", 0x1000001, 0x800000, CRC(3f5b3b21) SHA1(520ce1b75e6f4a8cf7bb626b7c2651cdca24aa5d) )
	ROM_LOAD16_BYTE( "257s25.c5", 0x2000000, 0x800000, CRC(ce18986b) SHA1(57c76fa4494792c0ca3936b4924050bd8ad2d897) )
	ROM_LOAD16_BYTE( "257s25.c6", 0x2000001, 0x800000, CRC(6940b9ca) SHA1(032aa28924591c695cd1d74653140277ecafab7d) )
	ROM_LOAD16_BYTE( "257s25.c7", 0x3000000, 0x800000, CRC(ee993d62) SHA1(33fa25bb1127631b4638d5d050ba392288e1a0dd) )
	ROM_LOAD16_BYTE( "257s25.c8", 0x3000001, 0x800000, CRC(33509f38) SHA1(97706dd72c0088c2396130f33b44bb6234f17081) )
ROM_END

ROM_START( kof2000s26 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s26.c1", 0x0000000, 0x800000, CRC(f586b1c0) SHA1(eff2c9393ed53eafe186ca83d50209ab08ed33f5) )
	ROM_LOAD16_BYTE( "257s26.c2", 0x0000001, 0x800000, CRC(9e9a4d92) SHA1(d1fb17000394c7ec360d34d2ef0ec12565248eb0) )
	ROM_LOAD16_BYTE( "257s26.c3", 0x1000000, 0x800000, CRC(f73a344f) SHA1(6bd589c9e1b9a6129406fc148ce277e85b9747f5) )
	ROM_LOAD16_BYTE( "257s26.c4", 0x1000001, 0x800000, CRC(ec9a92c3) SHA1(971e9597628db6aec2a040367d4f0c721bf4e88d) )
	ROM_LOAD16_BYTE( "257s26.c5", 0x2000000, 0x800000, CRC(835bdfb5) SHA1(1f1b4dc56a5aceae018fa9329cc21d9d2f95227d) )
	ROM_LOAD16_BYTE( "257s26.c6", 0x2000001, 0x800000, CRC(728cac73) SHA1(8d0c91aa9f7500411e7d35051b31589a7e4c6552) )
	ROM_LOAD16_BYTE( "257s26.c7", 0x3000000, 0x800000, CRC(6b5ca178) SHA1(51e7921d17e547498e7ee176b1a1bd6a48fefa10) )
	ROM_LOAD16_BYTE( "257s26.c8", 0x3000001, 0x800000, CRC(a638c74e) SHA1(4fe9897f838faccf88b9c869335a87b49e94f5d8) )
ROM_END

ROM_START( kof2000s27 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s27.c1", 0x0000000, 0x800000, CRC(35be1c4f) SHA1(c09f2037868d96dc3ccfa48f8f2df3fceb2823b6) )
	ROM_LOAD16_BYTE( "257s27.c2", 0x0000001, 0x800000, CRC(f8af1974) SHA1(623e4092ae6d8ce4192ae77a9ad60da07b7a24b1) )
	ROM_LOAD16_BYTE( "257s27.c3", 0x1000000, 0x800000, CRC(76ae9a36) SHA1(725b045c6b9abd2639b4d00aa5908998ebbf91e0) )
	ROM_LOAD16_BYTE( "257s27.c4", 0x1000001, 0x800000, CRC(dc02e155) SHA1(fdf36046aa64077bcea2be562eeca62c667f5d02) )
	ROM_LOAD16_BYTE( "257s27.c5", 0x2000000, 0x800000, CRC(9f847585) SHA1(4753eb53dccbba648179b113caa6d630e350abb8) )
	ROM_LOAD16_BYTE( "257s27.c6", 0x2000001, 0x800000, CRC(7e1d10ce) SHA1(fd8c4272178b521063435570c0cddc7877fdc888) )
	ROM_LOAD16_BYTE( "257s27.c7", 0x3000000, 0x800000, CRC(97116e77) SHA1(97e2ecddef7700df3a636c8672dd4cf682d5abe2) )
	ROM_LOAD16_BYTE( "257s27.c8", 0x3000001, 0x800000, CRC(108f1055) SHA1(736bf4e29e698a6e7a5ebfd7d134b61cd3ac7580) )
ROM_END

ROM_START( kof2000s28 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s28.c1", 0x0000000, 0x800000, CRC(933788b3) SHA1(db9d26d919a4187fab3be4da37a465df65394f96) )
	ROM_LOAD16_BYTE( "257s28.c2", 0x0000001, 0x800000, CRC(df7c6847) SHA1(1e5de5b1ba3de2f4986b9a50fce5b29b39734218) )
	ROM_LOAD16_BYTE( "257s28.c3", 0x1000000, 0x800000, CRC(baa2c1bf) SHA1(ca2d4bdfafb627c19155d0c46eb02d2fd8e526c6) )
	ROM_LOAD16_BYTE( "257s28.c4", 0x1000001, 0x800000, CRC(45e06b32) SHA1(a2a1ab2a2c94b78d7a630f0071bc5931a163f62a) )
	ROM_LOAD16_BYTE( "257s28.c5", 0x2000000, 0x800000, CRC(c0b77f1d) SHA1(c6cd237c16c48358f48220201ac464edbbfdab9f) )
	ROM_LOAD16_BYTE( "257s28.c6", 0x2000001, 0x800000, CRC(bc8ae7cc) SHA1(0f1e746f48a1fd4ad35bc19f034c86061bfe8178) )
	ROM_LOAD16_BYTE( "257s28.c7", 0x3000000, 0x800000, CRC(08df1c3d) SHA1(9b60524f4b6d705fd4bcb99c96b462dd49a9dcb2) )
	ROM_LOAD16_BYTE( "257s28.c8", 0x3000001, 0x800000, CRC(f48b78b1) SHA1(b68b176c0b0d80532789d9bf83a06f7f0c9e726e) )
ROM_END

ROM_START( kof2000s29 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s29.p1", 0x100000, 0x400000, CRC(f085a6d7) SHA1(6969188262158e255e2fb903098dfc0681984d15) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s30 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s30.p1", 0x100000, 0x400000, CRC(d0242653) SHA1(75251a1af1c76f57468be1dfa47d59275fcdc7af) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257ev.c1", 0x0000000, 0x800000, CRC(c89d1994) SHA1(2eb8a27f39dea743907b4be9e9d99f1858a30ba4) )
	ROM_LOAD16_BYTE( "257ev.c2", 0x0000001, 0x800000, CRC(19754968) SHA1(ca9692d5eac8e6eef5e5dd9888c5e8edcc9a0a7a) )
	ROM_LOAD16_BYTE( "257ev.c3", 0x1000000, 0x800000, CRC(c76b919b) SHA1(3f6245580e55c63d248478818005348f0cb92a6b) )
	ROM_LOAD16_BYTE( "257ev.c4", 0x1000001, 0x800000, CRC(5e03f2af) SHA1(85b7ec527a70411ad27d32a1169915b62230a3a7) )
	ROM_LOAD16_BYTE( "257ev.c5", 0x2000000, 0x800000, CRC(6a3b2fbd) SHA1(dbcf018f96767f753a2bab87f8d31fa6f6ef98d2) )
	ROM_LOAD16_BYTE( "257ev.c6", 0x2000001, 0x800000, CRC(ac4a8edc) SHA1(a305c8c5df3c2191fcdb73d799074a4191f2a252) )
	ROM_LOAD16_BYTE( "257ev.c7", 0x3000000, 0x800000, CRC(608ffca9) SHA1(0d3b184e44b9833f7338514e5633ccb3b3e39fb1) )
	ROM_LOAD16_BYTE( "257ev.c8", 0x3000001, 0x800000, CRC(73280ea8) SHA1(76bad66577b6d9618f2a190d54259eb3b1082d69) )
ROM_END

ROM_START( kof2000s31 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257.p1", 0x100000, 0x400000, CRC(60947b4c) SHA1(5faa0a7ac7734d6c8e276589bd12dd574264647d) )
	ROM_LOAD16_WORD_SWAP( "257s31.p2", 0x500000, 0x400000, CRC(ab8b2f82) SHA1(ce4f9de460ff4ce443b2c65472b3e9efe9b0d7b3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s32 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "neo-sma",   0x0c0000, 0x040000, CRC(71c6e6bb) SHA1(1bd29ded4c6b29780db8e8b772c452189699ca89) )
	ROM_LOAD16_WORD_SWAP( "257s32.p1", 0x100000, 0x400000, CRC(1aee72d7) SHA1(0d15a92441db5656d0ce8c81fd290e165feb3ab8) )
	ROM_LOAD16_WORD_SWAP( "257.p2", 0x500000, 0x400000, CRC(1b7ec415) SHA1(f19fa44e9ee5b5a6eb4a051349d6bc4acc3bbbdb) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s33 ) // kof2kps2, kof2000ps2 : cx,px confirmed
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s33.p1", 0x000000, 0x100000, CRC(56941018) SHA1(92d6d131111726f8ab616bf9dd54c1d5cbaa5bd5) )
	ROM_LOAD16_WORD_SWAP( "257s33.p2", 0x100000, 0x400000, CRC(1669a5ad) SHA1(64169a059aafcd91262243f6f5625a3104410d5b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257gbh.m1", CRC(a082f086) SHA1(809ef4a533cf541b86786f455a7f283a5acecd82) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s33.c7", 0x3000000, 0x800000, CRC(93c343ec) SHA1(b1a30c16f1bc2eee8c27e391b32dddecd979cc59) )
	ROM_LOAD16_BYTE( "257s33.c8", 0x3000001, 0x800000, CRC(ba92f698) SHA1(7a80c24472752f86130e7c963d14fed88b106bf6) )
ROM_END

ROM_START( kof2000s34 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s34.p1", 0x000000, 0x100000, CRC(14cd916b) SHA1(a762e58678b2dd90140b17a02ad0dbfdc32fc0e1) )
	ROM_LOAD16_WORD_SWAP( "257s34.p2", 0x100000, 0x400000, CRC(810740fa) SHA1(24c5624bc0528b1cb04908227b1dd81f763ee092) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s34.c1", 0x0000000, 0x800000, CRC(6fc94132) SHA1(4e3622ec021ca4ce989bab7828d2e1a01861a9c2) )
	ROM_LOAD16_BYTE( "257s34.c2", 0x0000001, 0x800000, CRC(d167cc43) SHA1(976d631a9bebb36d95038ee9d11fb4ab5c2de6a5) )
	ROM_LOAD16_BYTE( "257s34.c3", 0x1000000, 0x800000, CRC(87311da1) SHA1(6403712cf35ca13e108e220181e1a1c953f96b78) )
	ROM_LOAD16_BYTE( "257s34.c4", 0x1000001, 0x800000, CRC(b3dd4657) SHA1(b4fda32979a2b7c701e6afa71127b4a6d39964bc) )
	ROM_LOAD16_BYTE( "257s34.c5", 0x2000000, 0x800000, CRC(500298e5) SHA1(1e4cee48052577368e20644955e5de6b28ff0d5a) )
	ROM_LOAD16_BYTE( "257s34.c6", 0x2000001, 0x800000, CRC(609cba3d) SHA1(2582bf49f2ea9f00af93512b0ad6e814865bc0af) )
	ROM_LOAD16_BYTE( "257s34.c7", 0x3000000, 0x800000, CRC(42ad2649) SHA1(0367aa91a3560a76fc00b66ac537862b7fb5f295) )
	ROM_LOAD16_BYTE( "257s34.c8", 0x3000001, 0x800000, CRC(a6b69979) SHA1(6ea494acac45e39c90812fc6e3419d3298973070) )
ROM_END

ROM_START( kof2000s35 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bsd.p1", 0x000000, 0x100000, CRC(391948a6) SHA1(a41759bdb587a8765e5f5cc7a4631e9b002d4cf4) )
	ROM_LOAD16_WORD_SWAP( "257bsd.p2", 0x100000, 0x400000, CRC(7a6d80b8) SHA1(0a3bcf71a43b2b5dde0c33ed107c207a7c59e90c) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s35.c1", 0x0000000, 0x800000, CRC(11fdb7eb) SHA1(b9f911840efd05c3845eeaae6c3f686bad1e148b) )
	ROM_LOAD16_BYTE( "257s35.c2", 0x0000001, 0x800000, CRC(580bbd0b) SHA1(3d6f98dff9f72ea1128d6b83028a181581bb7fa3) )
	ROM_LOAD16_BYTE( "257s35.c3", 0x1000000, 0x800000, CRC(ed1414d7) SHA1(8a37858f0bf65a8614c6db68c085fc19d41b82e2) )
	ROM_LOAD16_BYTE( "257s35.c4", 0x1000001, 0x800000, CRC(e448fc89) SHA1(dd26a798b83fadb7d0d3a14e3a1562384cc6a438) )
	ROM_LOAD16_BYTE( "257s35.c5", 0x2000000, 0x800000, CRC(7510542e) SHA1(a23173d8a993a7ef71d762525c6a000a18fb319f) )
	ROM_LOAD16_BYTE( "257s35.c6", 0x2000001, 0x800000, CRC(cca7f13e) SHA1(fd87b618ad520458281bb0ab46a45eea298e5ae5) )
	ROM_LOAD16_BYTE( "257s35.c7", 0x3000000, 0x800000, CRC(2c9b3c00) SHA1(5db071d484e3a3646fcbb31c6d551fb423044fe2) )
	ROM_LOAD16_BYTE( "257s35.c8", 0x3000001, 0x800000, CRC(568b3ba3) SHA1(e124392ed7ca9e3bd104b49f3a033f2c1fde723c) )
ROM_END

ROM_START( kof2000s36 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s36.p1",  0x000000, 0x100000, CRC(afbf3774) SHA1(13c2b496678150e853dff044d073f6a3c8c9ba90) )
	ROM_LOAD16_WORD_SWAP( "257n.p2", 0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s37 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s37.p1", 0x000000, 0x100000, CRC(33433170) SHA1(dc1ed7bef7091c37970aceb6deb0f3429d94ccac) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s38 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s38.p1", 0x000000, 0x100000, CRC(bbe755b3) SHA1(c8484e4415b4661e3ae1082aab98f3ca002861a5) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s39 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s39.p1", 0x000000, 0x100000, CRC(6dc0591f) SHA1(17e8fbaed32b76f68a886613eb3c29fb8248fb1a) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s40 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s40.p1", 0x000000, 0x100000, CRC(0383f045) SHA1(70df7f760b3ebf214f903743412d37d69b887531) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s41 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s41.p1",  0x000000, 0x100000, CRC(51602d15) SHA1(a917a4b713c77374b2965a661da4a649b044381d) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s42 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bsd.p1", 0x000000, 0x100000, CRC(391948a6) SHA1(a41759bdb587a8765e5f5cc7a4631e9b002d4cf4) )
	ROM_LOAD16_WORD_SWAP( "257s42.p2", 0x100000, 0x400000, CRC(465e8981) SHA1(02f099db8d300922273b7f363a9861236ebbf37a) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257hn31.c1", 0x0000000, 0x800000, CRC(1d7649ae) SHA1(39f25783639cbcff7d5f09e721b99c2df40d27ba) )
	ROM_LOAD16_BYTE( "257hn31.c2", 0x0000001, 0x800000, CRC(e87b2472) SHA1(a53df088d01c0364640fa72ac84849ed19db90cf) )
	ROM_LOAD16_BYTE( "257hn31.c3", 0x1000000, 0x800000, CRC(695e912f) SHA1(c94073c9fafdf01dff7b19043816accd62c1b6d7) )
	ROM_LOAD16_BYTE( "257hn31.c4", 0x1000001, 0x800000, CRC(dae83f01) SHA1(d1d84604c1e503d49164bab5de58b38faa2e5023) )
	ROM_LOAD16_BYTE( "257hn31.c5", 0x2000000, 0x800000, CRC(12eebc71) SHA1(adf188ce3418c4b91b69e314119f7eb04995d49b) )
	ROM_LOAD16_BYTE( "257hn31.c6", 0x2000001, 0x800000, CRC(88bd53ef) SHA1(a984b22d8a2633743e81c675166205dd9d66811b) )
	ROM_LOAD16_BYTE( "257hn31.c7", 0x3000000, 0x800000, CRC(165d5fb2) SHA1(d2a9f37d6b3c5685d2d110f86cc75d0856c1e5b0) )
	ROM_LOAD16_BYTE( "257hn31.c8", 0x3000001, 0x800000, CRC(8adfed23) SHA1(fd72cfbd32a41afa1e447e146c748d2e7c71fd8c) )
ROM_END

ROM_START( kof2000s43 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s43.p1",  0x000000, 0x100000, CRC(a97dfaf2) SHA1(b2c5600b864434c078a1ea71e14f2cdd7c2be12e) )
	ROM_LOAD16_WORD_SWAP( "257n.p2",  0x100000, 0x400000, CRC(693c2c5e) SHA1(dc9121b7369ef46596343cac055a00aec81704d4) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257.c7", 0x3000000, 0x800000, CRC(7da11fe4) SHA1(065336cf166807acb6c8569d59d3bf37a19b0a42) )
	ROM_LOAD16_BYTE( "257.c8", 0x3000001, 0x800000, CRC(b1afa60b) SHA1(b916184f5cfe4121752270f4f65abf35d8eb0519) )
ROM_END

ROM_START( kof2000s44 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s44.p1",  0x000000, 0x100000, CRC(1cd3e047) SHA1(1d0e6a659309b26d3a2eb14624921b631a78f39f) )
	ROM_LOAD16_WORD_SWAP( "257pls.p2", 0x100000, 0x400000, CRC(9d716a8b) SHA1(da32f57719155b8dfa86124312d03ee82fbc7151) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257s44.s1", 0x60000, 0x20000, CRC(8d1f51fd) SHA1(196e2982fd1a13cfe12bbba28de076313ec8e37e) )
	ROM_CONTINUE(0x40000, 0x20000)
	ROM_CONTINUE(0x20000, 0x20000)
	ROM_CONTINUE(0x00000, 0x20000)

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257pls.c7", 0x3000000, 0x800000, CRC(eda5ea7f) SHA1(25e1d5279635eab65ba7b3f565d5cf0dd48ad201) )
	ROM_LOAD16_BYTE( "257pls.c8", 0x3000001, 0x800000, CRC(6df754d8) SHA1(94469836ae8e08448a01f346a09e660ceed9371f) )
ROM_END

ROM_START( kof2000s45 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s45.p1",  0x000000, 0x100000, CRC(e226d4b0) SHA1(04c3186e2439fa9e396346d02195f3ca7b910eb4) )
	ROM_LOAD16_WORD_SWAP( "257s45.p2", 0x100000, 0x400000, CRC(4c686a81) SHA1(2210a184e3b014515405a1dc5512d5d1b5ababdc) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257s44.s1", 0x60000, 0x20000, CRC(8d1f51fd) SHA1(196e2982fd1a13cfe12bbba28de076313ec8e37e) )
	ROM_CONTINUE(0x40000, 0x20000)
	ROM_CONTINUE(0x20000, 0x20000)
	ROM_CONTINUE(0x00000, 0x20000)

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257.c1", 0x0000000, 0x800000, CRC(cef1cdfa) SHA1(6135080f3a6b4712b76cc217edcc58e72b55c2b9) )
	ROM_LOAD16_BYTE( "257.c2", 0x0000001, 0x800000, CRC(f7bf0003) SHA1(9f7b19a2100cf7d12867e742f440dd5277b4f895) )
	ROM_LOAD16_BYTE( "257.c3", 0x1000000, 0x800000, CRC(101e6560) SHA1(8073ae1139e215d1167f8d32c14079a46ce3ee1c) )
	ROM_LOAD16_BYTE( "257.c4", 0x1000001, 0x800000, CRC(bd2fc1b1) SHA1(da0006761923ad49b404a08d7a151193ee307a69) )
	ROM_LOAD16_BYTE( "257.c5", 0x2000000, 0x800000, CRC(89775412) SHA1(b221b30224bc4239f1b3c2d2fd1cd4fa84e3523c) )
	ROM_LOAD16_BYTE( "257.c6", 0x2000001, 0x800000, CRC(fa7200d5) SHA1(6f2b0d38af34e280d56a58955400e5c679906871) )
	ROM_LOAD16_BYTE( "257s45.c7", 0x3000000, 0x800000, CRC(89b228af) SHA1(53265a7ce935b9e8c5fdab27efd24ba56b7a6da9) )
	ROM_LOAD16_BYTE( "257s45.c8", 0x3000001, 0x800000, CRC(6e20b468) SHA1(0543631a203475af782199e107cf9d548523c816) )
ROM_END

ROM_START( kof2000s46 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s46.p1", 0x000000, 0x100000, CRC(9e7a0c53) SHA1(d8b36eb5afb45749936eed8bf371db813398fabe) )
	ROM_LOAD16_WORD_SWAP( "257s46.p2", 0x100000, 0x400000, CRC(3ad938da) SHA1(4a7b31dd0816cc2ac06fa0c44fbed238b3ccef31) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257pls.s1", 0x60000, 0x20000, CRC(5a8d9e10) SHA1(2eb244a28b891a6fadbbccf10afe47b78d7948f0) )
	ROM_CONTINUE(0x40000, 0x20000)
	ROM_CONTINUE(0x20000, 0x20000)
	ROM_CONTINUE(0x00000, 0x20000)

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s46.c7", 0x3000000, 0x800000, CRC(1240f932) SHA1(92cc2d931e09e1e01869c65a5d61d1cb88ad7c27) )
	ROM_LOAD16_BYTE( "257s46.c8", 0x3000001, 0x800000, CRC(93d5ea7a) SHA1(88492fdbc9dedea304af099d5a2017936187d2b9) )
ROM_END

ROM_START( kof2000s47 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s47.p1", 0x000000, 0x100000, CRC(59f148fa) SHA1(fe0b9845809b69efbfef9ac6132c74097f5498b4) )
	ROM_LOAD16_WORD_SWAP( "257ice.p2",  0x100000, 0x400000, CRC(95df1ddd) SHA1(faecf18584d5397a588a69d002968a341a12adcb) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257pls.s1", 0x60000, 0x20000, CRC(5a8d9e10) SHA1(2eb244a28b891a6fadbbccf10afe47b78d7948f0) )
	ROM_CONTINUE(0x40000, 0x20000)
	ROM_CONTINUE(0x20000, 0x20000)
	ROM_CONTINUE(0x00000, 0x20000)

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s47.c7", 0x3000000, 0x800000, CRC(e6c0c3ff) SHA1(5b38ee4451d9d5af09751ee63a63124d65c62b34) )
	ROM_LOAD16_BYTE( "257s47.c8", 0x3000001, 0x800000, CRC(45709ae4) SHA1(abfa30d4881eb1da6e9c705fdfcd88e64e35ad88) )
ROM_END

ROM_START( kof2000s48 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s48.p1", 0x000000, 0x100000, CRC(d1edec62) SHA1(ec361e29fd8fe14ae3eebbe8984abe20886aa118) )
	ROM_LOAD16_WORD_SWAP( "257rp.p2",  0x100000, 0x400000, CRC(82a6aeed) SHA1(36f369313999d23f50201c1e240736d00d4921da) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2000s49 )
	ROM_REGION( 0x900000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s49.p1", 0x000000, 0x454F4E, CRC(d4faa368) SHA1(f2e181f38d3021eccf95cdb8bddd612256f2219f) )
	ROM_LOAD16_WORD_SWAP( "257s49.p2",  0x100000, 0x454F7C, CRC(0d7411ad) SHA1(c5422125a5cdeef1aeb8d944f16c6d2f201fed97) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s49.c1", 0x0000000, 0x800000, CRC(dc79d2ff) SHA1(4d390fd2066310cd9dbead3f10d3d7818df57e72) )
	ROM_LOAD16_BYTE( "257s49.c2", 0x0000001, 0x800000, CRC(0ee19c6d) SHA1(4afc4b972432eb9b438d99b64d08fb98177ecc78) )
	ROM_LOAD16_BYTE( "257s49.c3", 0x1000000, 0x800000, CRC(c2f7279b) SHA1(7bcfde9898622c600029cf81aa2532017335fb14) )
	ROM_LOAD16_BYTE( "257s49.c4", 0x1000001, 0x800000, CRC(041403f1) SHA1(117a4a6933e79013a677448199006197168d5761) )
	ROM_LOAD16_BYTE( "257s49.c5", 0x2000000, 0x800000, CRC(431c2c57) SHA1(2e78735011f8fdee82f895c10e6276476e41ce65) )
	ROM_LOAD16_BYTE( "257s49.c6", 0x2000001, 0x800000, CRC(7d8317a5) SHA1(5b1f95e889e72a0501ed98b60e41a5f189570609) )
	ROM_LOAD16_BYTE( "257s49.c7", 0x3000000, 0x800000, CRC(2a706de0) SHA1(b1f950fb15b733e86c634345e9bbc51eeff8c314) )
	ROM_LOAD16_BYTE( "257s49.c8", 0x3000001, 0x800000, CRC(d6a7842d) SHA1(862188cc2855ea5e54f1666ef10e3ffadc4c0220) )
ROM_END

ROM_START( kof2000s50 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bsd.p1",  0x000000, 0x100000, CRC(391948a6) SHA1(a41759bdb587a8765e5f5cc7a4631e9b002d4cf4) )
	ROM_LOAD16_WORD_SWAP( "257s50.p2",  0x100000, 0x400000, CRC(de073c79) SHA1(cf1bf7b71176b8519cfa60a55582897d74e118b8) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bsd.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257bsd.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s51 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bsd.p1",  0x000000, 0x100000, CRC(391948a6) SHA1(a41759bdb587a8765e5f5cc7a4631e9b002d4cf4) )
	ROM_LOAD16_WORD_SWAP( "257s51.p2",  0x100000, 0x400000, CRC(fc2a7f1d) SHA1(9e5907e4f3838f70a31fe806b9590e8f2aacbae5) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bsd.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257bsd.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s52 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bsd.p1",  0x000000, 0x100000, CRC(391948a6) SHA1(a41759bdb587a8765e5f5cc7a4631e9b002d4cf4) )
	ROM_LOAD16_WORD_SWAP( "257s52.p2",  0x100000, 0x400000, CRC(04382599) SHA1(b5cd75fc5fa55d008242b02013f94597f9a282b3) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bsd.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257bsd.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s53 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257bsd.p1",  0x000000, 0x100000, CRC(391948a6) SHA1(a41759bdb587a8765e5f5cc7a4631e9b002d4cf4) )
	ROM_LOAD16_WORD_SWAP( "257s53.p2",  0x100000, 0x400000, CRC(56de4f33) SHA1(f1fa083a7cf153495166b8805410f5f513af4c97) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bsd.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257bsd.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s54 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257rm.p1",  0x000000, 0x100000, CRC(597fdfc7) SHA1(10bb9e4ad0c3ff53336cc0e06303f83bcb5c94e4) )
	ROM_LOAD16_WORD_SWAP( "257pjc2.p2", 0x100000, 0x400000, CRC(136bd0a4) SHA1(5549ba017a9c633a3652ad3fc0d1c41bc247cdcd) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2000s55 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257rm.p1",  0x000000, 0x100000, CRC(597fdfc7) SHA1(10bb9e4ad0c3ff53336cc0e06303f83bcb5c94e4) )
	ROM_LOAD16_WORD_SWAP( "257pjc1.p2", 0x100000, 0x400000, CRC(c954c944) SHA1(3ca35a5393351ee22ef651f8984067b18aa02144) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2000s56 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257rm.p1",  0x000000, 0x100000, CRC(597fdfc7) SHA1(10bb9e4ad0c3ff53336cc0e06303f83bcb5c94e4) )
	ROM_LOAD16_WORD_SWAP( "257s56.p2",  0x100000, 0x400000, CRC(427662f3) SHA1(64c5b8a6b7afa0f97cd3db0f47b4210e5e604ee9) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2000s57 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257gbh.p1",  0x000000, 0x100000, CRC(5527a8fb) SHA1(5c861ab496ab713d04fe26ad5e6f73c2bb52bf48) )
	ROM_LOAD16_WORD_SWAP( "257ice.p2",  0x100000, 0x400000, CRC(95df1ddd) SHA1(faecf18584d5397a588a69d002968a341a12adcb) )

	NEO_SFIX_MT_512K
	// This came with the set but doesn't work
	//NEO_SFIX_128K( "257gbh.s1", BAD_DUMP CRC(cabc287b) SHA1(dbf3adc0fe31d3c6c246ed4c996ca9b8c9bbfa4d) ) // confirmed bad dump

	NEO_BIOS_AUDIO_256K( "257gbh.m1", CRC(a082f086) SHA1(809ef4a533cf541b86786f455a7f283a5acecd82) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bh.c7", 0x3000000, 0x800000, CRC(f7636227) SHA1(a76b331c96a7bf6fb4123c88a15f565c82b13373) )
	ROM_LOAD16_BYTE( "257bh.c8", 0x3000001, 0x800000, CRC(b887fe36) SHA1(d6fc2fba39c8f22ddbe911345ba1d21561cc4eb2) )
ROM_END

ROM_START( kof2000s58 )
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s45.p1",  0x000000, 0x100000, CRC(e226d4b0) SHA1(04c3186e2439fa9e396346d02195f3ca7b910eb4) )
	ROM_LOAD16_WORD_SWAP( "257s58.p2",  0x100000, 0x400000, CRC(b7b654ba) SHA1(b38d02079588954223123153725b847b9bd42456) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257s58.s1", 0x000000, 0x80000, CRC(38901d4d) SHA1(c7684f66ab4ed577094da6ae143477c9df28d1fe) )

	NEO_BIOS_AUDIO_ENCRYPTED_256K( "257.m1", CRC(4b749113) SHA1(2af2361146edd0ce3966614d90165a5c1afb8de4) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257s58.c1", 0x0000000, 0x800000, CRC(e01773f4) SHA1(268d06ddafdbc84bb6b1760eafde8b49c803fc23) )
	ROM_LOAD16_BYTE( "257s58.c2", 0x0000001, 0x800000, CRC(4b075833) SHA1(23fe03b4ed122a90ade7417b6356ecd8cb4a2e66) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END

ROM_START( kof2000s59 ) // kof2kps2
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s59.p1", 0x000000, 0x100000, CRC(6219fcc1) SHA1(ef61a7146643ce7dc01fc90ef6cf6c14c0864852) )
	ROM_LOAD16_WORD_SWAP( "257s33.p2", 0x100000, 0x400000, CRC(1669a5ad) SHA1(64169a059aafcd91262243f6f5625a3104410d5b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257gbh.m1", CRC(a082f086) SHA1(809ef4a533cf541b86786f455a7f283a5acecd82) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s33.c7", 0x3000000, 0x800000, CRC(93c343ec) SHA1(b1a30c16f1bc2eee8c27e391b32dddecd979cc59) )
	ROM_LOAD16_BYTE( "257s33.c8", 0x3000001, 0x800000, CRC(ba92f698) SHA1(7a80c24472752f86130e7c963d14fed88b106bf6) )
ROM_END

ROM_START( kof2000s60 ) // kof2000evol
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s60.p1", 0x000000, 0x100000, CRC(f74d599a) SHA1(40ceae4cdbf6f2b30906d9c3892cca165825684e) )
	ROM_LOAD16_WORD_SWAP( "257s60.p2", 0x100000, 0x400000, CRC(4c08fb12) SHA1(aedcc161d58489436491f290bd853615f94d9010) )

	NEO_SFIX_MT_512K
	ROM_LOAD( "257s58.s1", 0x000000, 0x80000, CRC(38901d4d) SHA1(c7684f66ab4ed577094da6ae143477c9df28d1fe) )

	NEO_BIOS_AUDIO_512K( "257s60.m1", CRC(e6122074) SHA1(e06e2d8eac8fff5450f5fe5134615149533010ad) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257s60.v1", 0x000000, 0x800000, CRC(2817845f) SHA1(bf8161942671c5b102f55fb01118f9213675ed59) )
	ROM_LOAD( "257s60.v2", 0x800000, 0x800000, CRC(fef0a7f4) SHA1(54ed26eacd7ed33af0ef013c6b409ffacb537446) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s60.c7", 0x3000000, 0x800000, CRC(0ceb9669) SHA1(b262e0b6327fa61cba78f7ac23b5221e66abc615) )
	ROM_LOAD16_BYTE( "257s60.c8", 0x3000001, 0x800000, CRC(381f3964) SHA1(7fa15a63783979a10628d2ab077f7b21bde8498d) )
ROM_END

ROM_START( kof2000s61 ) // kof2000otc
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s61.p1", 0x000000, 0x100000, CRC(5f3f1176) SHA1(617176f082bca7c5431ef04de8fad895b4728352) )
	ROM_LOAD16_WORD_SWAP( "257s61.p2", 0x100000, 0x400000, CRC(3b71cdd3) SHA1(2fffdbd923530875707b5ef95ab41a0904dd4c9b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257s61.m1", CRC(80ebc3aa) SHA1(1595314fd3dd9c68b8a653cda030916689546b88) )

	ROM_REGION( 0x1400000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )
	//ROM_LOAD( "257s61.v5", 0x1000000, 0x400000, CRC(54df285f) SHA1(218ac90b2660bd66f86e78eb96bfb1477daf7eb4) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s61.c7", 0x3000000, 0x800000, CRC(b2cd7102) SHA1(9c124c37ac680848b45a0b5a0c1f432995ad5c4d) )
	ROM_LOAD16_BYTE( "257s61.c8", 0x3000001, 0x800000, CRC(d11c3b66) SHA1(c79bb675aaa4dfbdee70275a4cd37a5b4eb0d0da) )
ROM_END

ROM_START( kof2000s62 ) // kof2000otc
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s62.p1", 0x000000, 0x100000, CRC(6bb2fdaf) SHA1(70871b42258fb0ddd6b9807cf6a34362edbb3c8e) )
	ROM_LOAD16_WORD_SWAP( "257s61.p2", 0x100000, 0x400000, CRC(3b71cdd3) SHA1(2fffdbd923530875707b5ef95ab41a0904dd4c9b) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257s61.m1", CRC(80ebc3aa) SHA1(1595314fd3dd9c68b8a653cda030916689546b88) )

	ROM_REGION( 0x1400000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )
	//ROM_LOAD( "257s61.v5", 0x1000000, 0x400000, CRC(54df285f) SHA1(218ac90b2660bd66f86e78eb96bfb1477daf7eb4) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s61.c7", 0x3000000, 0x800000, CRC(b2cd7102) SHA1(9c124c37ac680848b45a0b5a0c1f432995ad5c4d) )
	ROM_LOAD16_BYTE( "257s61.c8", 0x3000001, 0x800000, CRC(d11c3b66) SHA1(c79bb675aaa4dfbdee70275a4cd37a5b4eb0d0da) )
ROM_END

ROM_START( kof2000s63 ) // kof2000p
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s36.p1",  0x000000, 0x100000, CRC(afbf3774) SHA1(13c2b496678150e853dff044d073f6a3c8c9ba90) )
	ROM_LOAD16_WORD_SWAP( "257s60.p2", 0x100000, 0x400000, CRC(4c08fb12) SHA1(aedcc161d58489436491f290bd853615f94d9010) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_512K( "257s60.m1", CRC(e6122074) SHA1(e06e2d8eac8fff5450f5fe5134615149533010ad) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257s60.v1", 0x000000, 0x800000, CRC(2817845f) SHA1(bf8161942671c5b102f55fb01118f9213675ed59) )
	ROM_LOAD( "257s60.v2", 0x800000, 0x800000, CRC(fef0a7f4) SHA1(54ed26eacd7ed33af0ef013c6b409ffacb537446) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s60.c7", 0x3000000, 0x800000, CRC(0ceb9669) SHA1(b262e0b6327fa61cba78f7ac23b5221e66abc615) )
	ROM_LOAD16_BYTE( "257s60.c8", 0x3000001, 0x800000, CRC(381f3964) SHA1(7fa15a63783979a10628d2ab077f7b21bde8498d) )
ROM_END

ROM_START( kof2000s64 ) // kof2000otc
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s64.p1", 0x000000, 0x100000, CRC(11dbf4dc) SHA1(cb55339922a40ffdb779189863e5e379db052ce4) )
	ROM_LOAD16_WORD_SWAP( "257s64.p2", 0x100000, 0x400000, CRC(e1095f50) SHA1(53c31c6b64b670314c2e774e1ed7afde0dd9c984) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257s61.m1", CRC(80ebc3aa) SHA1(1595314fd3dd9c68b8a653cda030916689546b88) )

	ROM_REGION( 0x1400000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )
	//ROM_LOAD( "257s61.v5", 0x1000000, 0x400000, CRC(54df285f) SHA1(218ac90b2660bd66f86e78eb96bfb1477daf7eb4) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s61.c7", 0x3000000, 0x800000, CRC(b2cd7102) SHA1(9c124c37ac680848b45a0b5a0c1f432995ad5c4d) )
	ROM_LOAD16_BYTE( "257s61.c8", 0x3000001, 0x800000, CRC(d11c3b66) SHA1(c79bb675aaa4dfbdee70275a4cd37a5b4eb0d0da) )
ROM_END

ROM_START( kof2000s65 ) // kof2000otc
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s65.p1", 0x000000, 0x100000, CRC(25561805) SHA1(600f52bd8859fa34b40079d623069a53366b37c4) )
	ROM_LOAD16_WORD_SWAP( "257s64.p2", 0x100000, 0x400000, CRC(e1095f50) SHA1(53c31c6b64b670314c2e774e1ed7afde0dd9c984) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257s61.m1", CRC(80ebc3aa) SHA1(1595314fd3dd9c68b8a653cda030916689546b88) )

	ROM_REGION( 0x1400000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )
	//ROM_LOAD( "257s61.v5", 0x1000000, 0x400000, CRC(54df285f) SHA1(218ac90b2660bd66f86e78eb96bfb1477daf7eb4) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257s61.c7", 0x3000000, 0x800000, CRC(b2cd7102) SHA1(9c124c37ac680848b45a0b5a0c1f432995ad5c4d) )
	ROM_LOAD16_BYTE( "257s61.c8", 0x3000001, 0x800000, CRC(d11c3b66) SHA1(c79bb675aaa4dfbdee70275a4cd37a5b4eb0d0da) )
ROM_END

ROM_START( kof2000s66 ) //kof2000plus
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s66.p1",  0x000000, 0x100000, CRC(c9aaa132) SHA1(361f2a38681c5ff566feaf47db5026d2f3bd9eab) )
	ROM_LOAD16_WORD_SWAP( "257bsd.p2", 0x100000, 0x400000, CRC(7a6d80b8) SHA1(0a3bcf71a43b2b5dde0c33ed107c207a7c59e90c) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bsd.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257bsd.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s67 ) //kof2000plus
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257s67.p1",  0x000000, 0x100000, CRC(3805c7ab) SHA1(3d50a90cf3e3b90679e7730c9accf2a474fbb7ed) )
	ROM_LOAD16_WORD_SWAP( "257bsd.p2", 0x100000, 0x400000, CRC(7a6d80b8) SHA1(0a3bcf71a43b2b5dde0c33ed107c207a7c59e90c) )

	NEO_SFIX_MT_512K

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257bsd.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257bsd.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s68 ) //kof2000otc,kof2000hc01
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257_hc01.p1", 0x000000, 0x100000, CRC(dde67c6b) SHA1(697804eef124e3c8124d10e7cc79b2a23da41396) )
	ROM_LOAD16_WORD_SWAP( "257_hc01.p2", 0x100000, 0x400000, CRC(e1095f50) SHA1(53c31c6b64b670314c2e774e1ed7afde0dd9c984) )

	NEO_SFIX_512K( "257d.s1", CRC(38901d4d) SHA1(c7684f66ab4ed577094da6ae143477c9df28d1fe) )

	NEO_BIOS_AUDIO_256K( "257_hc01.m1", CRC(80ebc3aa) SHA1(1595314fd3dd9c68b8a653cda030916689546b88) )

	ROM_REGION( 0x2000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )
	ROM_LOAD( "257_hc01.v5", 0x1000000, 0x400000, CRC(54df285f) SHA1(218ac90b2660bd66f86e78eb96bfb1477daf7eb4) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257_hc01.c7", 0x3000000, 0x800000, CRC(b2cd7102) SHA1(9c124c37ac680848b45a0b5a0c1f432995ad5c4d) )
	ROM_LOAD16_BYTE( "257_hc01.c8", 0x3000001, 0x800000, CRC(d11c3b66) SHA1(c79bb675aaa4dfbdee70275a4cd37a5b4eb0d0da) )
ROM_END

ROM_START( kof2000s69 ) //kof2ksp,kof2000hc19
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257_hc19.p1", 0x000000, 0x100000, CRC(a9742061) SHA1(a0ab3bbc1d8439846d0112171132be03a2141121) )
	ROM_LOAD16_WORD_SWAP( "257_hc03.p2", 0x100000, 0x400000, CRC(48a1a381) SHA1(c32a7303c351422f66a3c0a535b01dbbdfca7d91) )

	NEO_SFIX_512K( "257d.s1", CRC(38901d4d) SHA1(c7684f66ab4ed577094da6ae143477c9df28d1fe) )

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257_hc03.c7", 0x3000000, 0x800000, CRC(110f72a3) SHA1(7540aa2be692fbbcd887c8377ca6891d1ba1b6ed) )
	ROM_LOAD16_BYTE( "257_hc03.c8", 0x3000001, 0x800000, CRC(4347f6af) SHA1(fc744d68e04905af1fa8d39d8772fba67e14777f) )
ROM_END

ROM_START( kof2000s70 ) //kof2000bc,kof2000hc03
	ROM_REGION( 0x500000, "maincpu", 0 )
	ROM_LOAD16_WORD_SWAP( "257_hc03.p1", 0x000000, 0x100000, CRC(737d5b20) SHA1(18880ad093b22910b46cfb3f82790c171d6fadd3) )
	ROM_LOAD16_WORD_SWAP( "257_hc03.p2", 0x100000, 0x400000, CRC(48a1a381) SHA1(c32a7303c351422f66a3c0a535b01dbbdfca7d91) )

	NEO_SFIX_512K( "257d.s1", CRC(38901d4d) SHA1(c7684f66ab4ed577094da6ae143477c9df28d1fe) )

	NEO_BIOS_AUDIO_256K( "257d.m1", CRC(d404db70) SHA1(8cd1f3e140a9a367de23544e76371b0491287909) )

	ROM_REGION( 0x1000000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "257.v1", 0x000000, 0x400000, CRC(17cde847) SHA1(4bcc0205b70dc6d9216b29025450c9c5b08cb65d) )
	ROM_LOAD( "257.v2", 0x400000, 0x400000, CRC(1afb20ff) SHA1(57dfd2de058139345ff2b744a225790baaecd5a2) )
	ROM_LOAD( "257.v3", 0x800000, 0x400000, CRC(4605036a) SHA1(51b228a0600d38a6ec37aec4822879ec3b0ee106) )
	ROM_LOAD( "257.v4", 0xc00000, 0x400000, CRC(764bbd6b) SHA1(df23c09ca6cf7d0ae5e11ff16e30c159725106b3) )

	ROM_REGION( 0x4000000, "sprites", 0 )
	ROM_LOAD16_BYTE( "257d.c1", 0x0000000, 0x800000, CRC(abcdd424) SHA1(1d52aae8a7806d48c098c2a7a77dff6e02ac4870) )
	ROM_LOAD16_BYTE( "257d.c2", 0x0000001, 0x800000, CRC(cda33778) SHA1(a619740364c952c443f27ed9b7c395610f2673c7) )
	ROM_LOAD16_BYTE( "257d.c3", 0x1000000, 0x800000, CRC(087fb15b) SHA1(f77cb6e670cdf7709d84d770ecf28533cbfbe6de) )
	ROM_LOAD16_BYTE( "257d.c4", 0x1000001, 0x800000, CRC(fe9dfde4) SHA1(23750ff0c4bc084d55eea66a5cdd0ef2d6c32cdc) )
	ROM_LOAD16_BYTE( "257d.c5", 0x2000000, 0x800000, CRC(03ee4bf4) SHA1(8f26c5bc525a5786de8e25797e2875a1dfe527be) )
	ROM_LOAD16_BYTE( "257d.c6", 0x2000001, 0x800000, CRC(8599cc5b) SHA1(9a05fc12273aebfbc4ac22e88b32ae9ecd269462) )
	ROM_LOAD16_BYTE( "257d.c7", 0x3000000, 0x800000, CRC(71dfc3e2) SHA1(1889a8dc88993e35f9fd93ce2bee1de52995932d) )
	ROM_LOAD16_BYTE( "257d.c8", 0x3000001, 0x800000, CRC(0fa30e5f) SHA1(0cb7fa6b0219e1af2df9b97786c677651a78f37a) )
ROM_END


/*    YEAR  NAME            PARENT    MACHINE        INPUT       INIT             MONITOR COMPANY                 FULLNAME FLAGS */
// The King of Fighters '2000
GAME( 2000, kof2000d,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "SNK", "Kof2000 (Decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 2014, kof2000ev,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack", "Kof2000 (Enhanced Version Super, 2014-11-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000r,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Raymonose, Jason & Kim", "Kof2000 (Remix Pro 1.00a)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kce,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "hack", "Kof2000 (Char color changed set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kch,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Chase", "Kof2000 (Diff Moves, 2003-05-03)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kcp,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "hack", "Kof2000 (Char color changed set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2keh,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Guangzhou Game Team", "Kof2000 (Add Char - Ultra kill start max)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kehr,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Raymonose", "Kof2000 (Add Char - Diff Moves - Ultra pow hack)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kevo,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Jason/K3 and Wesker", "Kof2000 (Evolution v1.2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kevo1,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Jason/K3 and Wesker", "Kof2000 (Evolution v1.01)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kevo2,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Jason/K3 and Wesker", "Kof2000 (Evolution v1.0)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kevo3,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "FCHT-EGHT", "Kof2000 (Evolution v1.3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kgold,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Anndy", "Kof2000 (Char color changed - Gold)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kgbh,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000, ROT0, "hack", "Kof2000 (Boss Hack - Gold Color Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kiori,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "ZKW", "Kof2000 (Iori Orochi)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kjlc,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Jui Lee", "Kof2000 (Char color changed for Athena 2P and Kula 2P)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kkf1,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Guangzhou Game Team", "Kof2000 (Add Char - MVS protection rem set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kkt,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "hack", "Kof2000 (Korean)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kkvs,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "KVS", "Kof2000 (Add Char - MVS protection rem set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kkzs,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "hack", "Kof2000 (Add Char - MVS protection rem set 3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2knd,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack", "Kof2000 (Non encrypted P,decrypted C)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kpjc,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "TcwLee", "Kof2000 (Color Fix, 2003-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kpjc1,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "TcwLee", "Kof2000 (Color Change v3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kpjc2,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "TcwLee", "Kof2000 (Color Change v4)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kpjc3,  kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "TcwLee", "Kof2000 (Color Changed - Striker not Perfect, 2003-03-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kpls,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Guangzhou Game Team", "Kof2000 Plus", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2krm,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Raymonose", "Kof2000 (Diff Moves)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2krp,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "FCHT", "Kof2000 (Remix Pro)(Diff Moves v1.0a 2003-11-03 beta)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kryu,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Iori Yagami", "Kof2000 (Ryu Hack)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kseh,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Guangzhou Game Team", "Kof2000 (Add Char - Ultra kill start max - Super pow)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kst,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "KoF1995", "Kof2000 (Add Char - Boss striker moves changed)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kwh,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Wesker", "Kof2000 (Diff Moves for Takuma)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kwh2,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Wesker", "Kof2000 (Diff Moves for Jhun)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kxxx,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Crispy", "Kof2000 (SP XXX, 2016-01-04)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kyd,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Dodowang and Ydmis", "Kof2000 (Style change - Select 2 Add Char)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kyg,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Guangzhou Game Team", "Kof2000 (Add Char set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kz,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Ydmis", "Kof2000 (Add Zero)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kzs,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "hack", "Kof2000 (Add Char - MVS protection rem set 4)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000h,   kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "hack", "Kof2000 (Boss Hack)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2kbj,    kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Jason/K3", "Kof2000 (Add Char set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2ky,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,  ROT0, "Ydmis",    "Kof2000 (Add Kula)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s01,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "wesker & Jason",    "Kof2000 (Evolution V1.2a)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s02,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Ydmis",    "Kof2000 (Enable Hidden Characters V1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s03,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Ydmis",    "Kof2000 (Enable Hidden Characters V2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s04,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Jason",    "Kof2000 (Enable Hidden Characters V3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s05,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Dodowang",    "Kof2000 (Enable Hidden Characters V4)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s06,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "0 Day-S",    "Kof2000 (Enable Hidden Characters V5)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s07,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Hidden Characters Zero Striker Moves v1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s08,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "danpaji1 & marcochen",    "Kof2000 (Hidden Characters Zero Striker Moves v2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s09,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Eddids",    "Kof2000 (Hidden Characters Add Boss ST Color)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s10,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "0 Day-S",    "Kof2000 (Hidden Characters Fix Boss ST Broken)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s11,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "kof1996",    "Kof2000 (Hidden Characters Bugfix For Zero's Special Move)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s12,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Creamymami",    "Kof2000 (Enhanced Counter & Armor Mode V1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s13,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Creamymami",    "Kof2000 (Enhanced Counter & Armor Mode V2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s14,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Creamymami",    "Kof2000 (Enhanced Counter & Armor Mode V3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s15,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Creamymami",    "Kof2000 (Enhanced Power)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s16,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Creamymami",    "Kof2000 (Free ST)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s17,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Creamymami",    "Kof2000 (Free Special Move)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s18,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Golden Style)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s19,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "zhangshee",    "Kof2000 (Icy Blue Style)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s20,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "tcwlee",    "Kof2000 (Color Change V1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s21,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "kim & tcwlee",    "Kof2000 (Color Change V2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s22,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Bikini-Athena)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s23,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Half Transparency Life Bar v1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s24,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Half Transparency Life Bar v2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s25,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Half Transparency Life Bar v3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s26,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Half Transparency Timer v1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s27,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Half Transparency Timer v2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s28,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "oak2003",    "Kof2000 (Half Transparency Striker Cage)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s29,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "sjx",    "Kof2000 (The Style Of Kyo'S D)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s30,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "sujianxiong",    "Kof2000 (The Eight Gods Of The Blood Of The Great Snake)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s31,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Eddids",    "Kof2000 (Unlimited Credits In Console Mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s32,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "yashional",    "Kof2000 (Investment Skills Hit)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s33,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Like PS2 Version V1.0 2013)(Hack only enable in AES mode)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s34,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "COGODO",    "Kof2000 (Chinese)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s35,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Eddids & 0 Day-S?A1",    "Kof2000 (Boss Striker Perfect Edtion)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s36,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Simplify The Move)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s37,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Yagami Nunnery Add '97 Shavings Wind)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s38,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "EtheN.H",    "Kof2000 (Move Correction)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s39,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Raymonose",    "Kof2000 (Remix)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s40,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "sjx",    "Kof2000 (No Length Limit For Robert's Special Move)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s41,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "kof1996",    "Kof2000 (Chaos Revision)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s42,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Eddids & 0 DAY-S",    "Kof2000 (Boss Striker 1.0)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s43,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Optimized Version, 2013-09-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s44,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 Plus (Enable Hidden Characters, 2015-02-10)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s45,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Boss ST Zero, 2010-09-05)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s46,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 Plus (Unknown Hack, 2006-06-02)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s47,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "Guangzhou Game Team", "Kof2000 Plus (Edition Chinese, 2007-04-23)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s48,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Pro 1.0a, 2007-08-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s49,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (SP Version, 2009-03-19)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s50,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Colors Set 1)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s51,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Colors Set 2)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s52,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Colors Set 3)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s53,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Edition Special Remix)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s54,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Colors Set 4)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s55,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Colors Set 5)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s56,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Remix Colors Set 6)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s57,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Boss Hack - Gold Color Edition, 2015-04-21)", MACHINE_SUPPORTS_SAVE )
GAME( 2000, kof2000s58,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Chinese Codogo Edition)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s59,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Playstation 2 Plus, 2020-02-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s60,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Evolution Blue Edition Simplified, 2020-02-27)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s61,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "OTC/Loushi", "Kof2000 (OTC Simplified, 2020-05-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s62,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "OTC/Loushi", "Kof2000 (OTC Original, 2020-05-26)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s63,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 (Blue Sky Edition Simplified Move, 2020-05-15)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s64,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "OTC/Loushi", "Kof2000 (OTC Original, 2020-06-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s65,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "OTC/Loushi", "Kof2000 (OTC Simplified, 2020-06-17)", MACHINE_SUPPORTS_SAVE )
GAME( 2019, kof2000s66,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 Plus (Resurgence Original, 2019-10-22)", MACHINE_SUPPORTS_SAVE )
GAME( 2020, kof2000s67,     kof2000,  neogeo_noslot, neogeo, neogeo_state,  init_kof2000,   ROT0, "hack",    "Kof2000 Plus (Resurgence Simplify, 2020-07-08)", MACHINE_SUPPORTS_SAVE )
GAME( 2022, kof2000s68,     kof2000,  neogeo_noslot,   neogeo, neogeo_state,    init_kof2000,  ROT0, "OTC/Loushi", "Kof2000 (OTC, 2022-07-20)", MACHINE_SUPPORTS_SAVE )
GAME( 2023, kof2000s69,     kof2000,  neogeo_noslot,   neogeo, neogeo_state,    init_kof2000,  ROT0, "GSC2007/EGCG", "Kof2000 (Special, 2023-03-06)", MACHINE_SUPPORTS_SAVE )
GAME( 2021, kof2000s70,     kof2000,  neogeo_noslot,   neogeo, neogeo_state,    init_kof2000,  ROT0, "GSC2007/EGCG/Aillis", "Kof2000 SP (Imitation BC 14 System Version, 2021-02-24)", MACHINE_SUPPORTS_SAVE )

